#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc MakeMenus { w menus } {
        global gui_flags
            if ![winfo exists $w.menu] {
                frame $w.menu -relief raised -borderwidth 1
                pack $w.menu -side top -fill x
                if {[llength [pack slaves $w]]!=0} {
                    pack config $w.menu -before [lindex [pack slaves $w] 0]
                }
            }
            set menubuttons ""
            foreach m $menus {
                set menuname [lindex $m 0]
                set menutext [lindex $m 1]
                set menuunderline [lindex $m 2]
                set menupack [lindex $m 3]
                if {$menuunderline==""} {
                    menubutton $w.menu.$menuname -text $menutext \
                        -menu $w.menu.$menuname.m \
                        -font $gui_flags(font,menus)
                } else {
                    menubutton $w.menu.$menuname -text $menutext \
                        -menu $w.menu.$menuname.m \
                        -underline $menuunderline \
                        -font $gui_flags(font,menus)
                }
                menu $w.menu.$menuname.m \
                            -font $gui_flags(font,menus)
                foreach menuitem [lindex $m 4] {
                    if {[lindex $menuitem 3]==""} {
                        set underline_args ""
                    } else {
                        set underline_args [list -underline [lindex $menuitem 3]]
                    }
                    set label_args [list -label [lindex $menuitem 1]]
                    case [lindex $menuitem 0] sep {
                        $w.menu.$menuname.m add sep
                    } command {
                        eval [list $w.menu.$menuname.m add command \
                            -command [lindex $menuitem 2]] \
                            $label_args \
                            $underline_args
                    } cascade {
                        eval [list $w.menu.$menuname.m add cascade \
                            -menu [lindex $menuitem 2]] \
                            $label_args \
                            $underline_args
                    } checkbutton {
                        if {[lindex $menuitem 4]==""} {
                            set underline_args ""
                        } else {
                            set underline_args [list -underline [lindex $menuitem 4]]
                        }
                        eval [list $w.menu.$menuname.m add checkbutton \
                            -variable [lindex $menuitem 2] \
                            -command [lindex $menuitem 3]] \
                            $label_args \
                            $underline_args
                    } default {
                        error "Bad menu entry type passed to MakeMenus"
                    }
                }
                pack $w.menu.$menuname -side $menupack
                lappend menubuttons $w.menu.$menuname
            }
        eval [list tk_menuBar $w.menu] $menubuttons
        focus_skip $w.menu 1
        return $w.menu
}

