#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





option add *NewRecDef.initial "" widgetDefault

proc NewRecDef { w args } {
        global gui_flags 
        global NewRecDef_flags
        global feedback
        global vals

        global busy
        incr busy

        for {set i 0} {$i<[llength $args]} {incr i} {
            case [lindex $args $i] -initial {
                incr i
                set initial [lindex $args $i]
            } default {
                error "unrecognized arg [lindex $args $i]"
            }
        }

        toplevel $w -class NewRecDef

        if ![info exists initial] { set initial [option get $w initial Initial] }

        wm withdraw $w
        wm title $w "New Recursive Definition"
        
        set feedback [list {} "Creating NewRecDef display..."]
        
        
        pack [frame $w.sources] -side top -fill both -expand yes -padx 5 -pady 5
        pack [frame $w.sources.l -relief sunken] -side left -fill both -expand yes
        pack [frame $w.sources.r -relief sunken] -side right -fill both -expand yes
        pack [frame $w.types] -in $w.sources.r -side top -fill both -expand yes -padx 5 -pady 5
        pack [frame $w.axiom] -in $w.sources.r -side top -fill both -expand no -padx 5 -pady 5
        pack [frame $w.templ] -in $w.sources.l -side top -fill both -expand yes -padx 5 -pady 5
        pack [frame $w.spec] -in $w.sources.l -side top -fill both -expand yes -padx 5 -pady 5
        
        pack [fontcheck label $w.templ.lab \
                -font $gui_flags(font,labels) \
                -text "Template (\"_\" marks recursive parameter):" \
                -anchor w \
        ] -side top -fill x
        pack [fontcheck entry $w.templ.templ \
                -font $gui_flags(font,codeentry) \
                -relief sunken \
        ] -side left -fill x -expand yes
        bind $w.templ.templ <Any-Return> "NewRecDef::remake_template_specification $w"

        pack [label $w.types.lab \
                -text "Type of recursive parameter:" \
                -font $gui_flags(font,labels) \
                -anchor w \
        ] -side top -fill x
        pack [scrollable listbox $w.types.types \
                -export 0 \
                -relief sunken \
                -font $gui_flags(font,listboxes) \
                -geometry 20x6 \
        ] -side top -fill both -expand yes
        bind $w.types.types.b <ButtonRelease-1> \
                "NewRecDef::new_type_selected $w"
        tk_listboxSingleSelect $w.types.types.b
        
        pack [fontcheck label $w.axiom.lab \
                -font $gui_flags(font,labels) \
                -text "Recursive Axiom:" \
                -anchor w \
        ] -side top -fill x
        pack [fontcheck entry $w.axiom.axiom \
                -font $gui_flags(font,codeentry) \
                -width 30 \
                -relief sunken \
        ] -side top -fill x
        bind $w.axiom.axiom <Any-Return> "NewRecDef::remake_template_specification $w"

        pack [fontcheck label $w.spec.lab \
                -font $gui_flags(font,labels) \
                -text "Full Specification:" \
                -anchor w \
        ] -side top -fill x
        pack [richtext $w.spec.spec \
                -richtextvar vals($w,richtext) \
                -showtypesvar vals($w,showtypes) \
                -structuredtextvar vals($w,structuredtext) \
                -editingvar vals($w,editing) \
        ] -expand yes -fill both
        $w.spec.spec text config \
                -height 10 \
                -width 60


        pack [frame $w.controls -borderwidth 2] -pady 5
        pack [fontcheck focusable button $w.controls.apply \
                -command "NewRecDef::remake_template_specification $w" \
                -text "Apply Template" \
                -width 13 \
                -font $gui_flags(font,buttons)] \
            -side left -fill x -padx 5

        pack [fontcheck focusable button $w.controls.define \
                -command "NewRecDef::define $w" \
                -text "Execute" \
                -width 9 \
                -font $gui_flags(font,buttons)] \
            -side left -fill x -padx 5

        set helpcommand "Help::tutorial NewRecDef"
        pack [fontcheck focusable button $w.controls.help \
                -command $helpcommand \
                -text "Help" \
                -width 9 \
                -font $gui_flags(font,buttons)] \
            -side left -fill x -padx 5
        pack [fontcheck focusable button $w.controls.close \
                -command "destroy $w" \
                -text "Close" \
                -width 9 \
                -font $gui_flags(font,buttons)] \
            -side left -fill x -padx 5
        
        widget_addBinding $w Destroy "unset_vals_for_widget $w"

        update
        wm deiconify $w
        tkwait visibility $w
        update
        button_setDefault $w.controls.apply 

        set feedback [list $w "Finding potential recursive types.\n\nThis only needs to be done once..."]
        set poss_types [lsort [ML -type stringlist \
                "subtract (map #Name (flatten (map types [hol_ancestry]))) [ml_stringlist [list num fun prod one ind bool set real hreal hrat rat int ltree]]"]]
        set poss_types [linsert $poss_types 0 num]
        eval $w.types.types.b insert end $poss_types
        if {$initial == ""} {
            $w.templ.templ insert 0 "NewConst _"
            $w.types.types.b sel from 0

            NewRecDef::new_type_selected $w
        } else {

            # Fetch the bits n pieces out of the arguments list for the script fragment

            set def [ML "#def (ScriptFragments.data_for_new_recursive_definition ($initial))"]
            set fixity [ML "#fixity (ScriptFragments.data_for_new_recursive_definition ($initial))"]
            set name [ML "#name (ScriptFragments.data_for_new_recursive_definition ($initial))"]
            set rec_axiom [ML "#rec_axiom (ScriptFragments.data_for_new_recursive_definition ($initial))"]

            set cleaned_defl ""
            foreach defl [split $def \n] {
                lappend cleaned_defl [string trim $defl]
            }
            set cleaned_def [join $cleaned_defl \n]

            $w.spec.spec editpreterm [list TEXT [hol_determ $cleaned_def]]
            regsub _Axiom [string trim $rec_axiom] "" type
            $w.templ.templ insert 0 "NewConst _"
            set size [$w.types.types.b size]
            for {set i 0} {$i < $size} {incr i} {
                if {[$w.types.types.b get $i]==$type} {
                    $w.types.types.b sel from $i
                    break
                }
            }
            $w.axiom.axiom insert end $rec_axiom
        }
        if {$initial == ""} {
            focus_goToFirst $w.templ.templ
        } else {
            update
            focus_goToFirst [$w.spec.spec text]
        }
        incr busy -1
        return $w
}

#----------------------------------------------------------------------------
# NewRecDef::remake_template_specification
#    This is all a dodgy hack to get primitive templating.  We do
# textual analysis on the lines stripping out the RHS of each spec
# in each datatype.  We then replace the lhs with the new version,
# trying to keep the same RHS.  Works about 50% of the time....
#
#----------------------------------------------------------------------------

proc NewRecDef::new_type_selected { w } {
        global busy
        incr busy
        set typename [$w.types.types.b get [$w.types.types.b cursel]]
        $w.axiom.axiom delete 0 end
        set axiomcode "theorem [ml_string $typename] [ml_string [set typename]_Axiom]"
        if {$typename=="num"} { set axiomcode "theorem [ml_string prim_rec] [ml_string num_Axiom]" }
        $w.axiom.axiom insert end $axiomcode
        NewRecDef::remake_template_specification $w
        incr busy -1
}

proc NewRecDef::remake_template_specification { w } {
        global gui_flags
        global busy
        incr busy
        set templ [$w.templ.templ get]
        set typename [$w.types.types.b get [$w.types.types.b cursel]]
        set axiomcode [$w.axiom.axiom get]
#       set thmspec [ML -type thmspec \
#               "(#lookup (primitive_recursive_types())) $typename"]
        if [catch {ML -type any -check 1 $axiomcode} err] {
            errormessage $w.error \
"$gui_flags(title)   could  not  find  the  default  recursive
axiom for the type \"$typename\".  This is because the code
\"$axiomcode\" does not evaluate correctly.  Perhaps the  theorem
named \"[set typename]_Axiom\" does not reside in the theory \"$typename\".

You  will  need  to  enter the ML code to access the recursive
axiom manually in the entry field on the lower right of this window."
            focus_goTo $w.axiom.axiom
            incr busy -1
            return
        }

        set fargs [ML -type stringlist -check 1 \
              "map (term_to_string o rand o lhs o snd o strip_forall) \
                ((strip_conj o body o rand o snd o strip_forall o concl) ($axiomcode))"]

        set oldspec [$w.spec.spec getpreterm]
        foreach farg $fargs {
            set argpos [string first $farg $oldspec]
            set from_argpos [string range $oldspec $argpos end]
            set eqpos [string first = $from_argpos]

            # BUG: this next line doesn't work if there are /\'s in the
            # specification.  Bummer.  Really need to parse the code
            # first to get this right, but I want to allow for
            # template modifications to unparsable code. 
            #
            # FIX: Look only for /\'s which occur at the end of a line.
            # Should also trim each line for whitespace...
            #
            # set andpos [string first "/\\" $from_argpos]
            set andpos [string first "/\\\n" $from_argpos]
        
            if {$argpos == -1 || $eqpos == -1 || (($andpos != -1) && ($andpos <= $eqpos))} {
                set oldpart "= ...)"
            } else {
                if {$andpos == -1} { 
                    set andpos end 
                } else {
                    incr andpos -2
                }
                set oldpart [string range $from_argpos $eqpos $andpos]
            }

            regsub -- {([^A-Za-z0-9])_} $templ "\\1[ml_opt_paren $farg]" piece
            lappend pieces "($piece $oldpart"
        }
        $w.spec.spec editpreterm [list TEXT [join $pieces " /\\\n"]]
        button_setDefault $w.controls.define
        incr busy -1
}

#----------------------------------------------------------------------------
# NewRecDef::define
#
#----------------------------------------------------------------------------

proc NewRecDef::define { w  } {
        global gui_flags
        global TkHol_flags
        global feedback
        global busy
        global vals
        incr busy
        set typename [$w.types.types.b get [$w.types.types.b cursel]]
#       set thmspec [ML -type thmspec \
#               "(#lookup (primitive_recursive_types())) $typename"]
#       set thmspec [list [set typename]_Axiom theorem $typename]
        set axiomcode [$w.axiom.axiom get]
        set spec [$w.spec.spec getpreterm]
        set neat_spec [join [split [hol_term [string trim $spec]] \n] "\n        "]

        set templ [$w.templ.templ get]
        scan $templ %s constname
        set thm_name [set constname]_DEF
        set sections ""


            if [hol90] {
                set defn "new_recursive_definition \{ \
\n    def=$neat_spec, \
\n    fixity=Prefix, \
\n    name=[ml_string $thm_name], \
\n    rec_axiom=$axiomcode \
\}"
            }
            set script "[ml_val] $thm_name = $defn[ml_end_dec]"
            lappend sections [list $thm_name $defn $script]

        set total_script ""
        set objspecs ""
        foreach section $sections {
            set name [lindex $section 0]
            set defn [lindex $section 1]
            set script [lindex $section 2]
            set feedback [list $w "Making/Proving $name"]
            if [catch {ML_bind -check 1 -log 0 $name $defn} err] {
                errormessage $w.error $err; incr busy -1; return
            }
            lappend objspecs [list $name [list THM [list CODE $name]]]
            ML -run 0 -toplevel 1 -log 1 $script
            set total_script "[set total_script]$script"
        }
                   
        if $TkHol_flags(managingScripts) {
            if {[choice $w.verify -text "$constname has been successfully defined.  Should $gui_flags(title) add this operation to [Scripts::current_script]?" -buttons [list Yes No]]=="Yes"} {
                Scripts::add_to_script $script
            }
        } else {
            set newwin [newwin TheoremsTopLevel \
                -title {New Recursive Definition: Results} \
                -header {Theorem Generated by new_recursive_definition:} \
                -objspecs $objspecs \
                -mlbindbuttons 0 \
                -expandbuttons 0 \
                -withtext 1 \
                -text $total_script]
            $newwin.objs expandall
        }
        incr busy -1    
        if {[choice $w.verify -text "Make another primitive recursive definition?" -buttons [list Yes No]]=="No"} {
            destroy $w
        }

}


#----------------------------------------------------------------------------
#
#----------------------------------------------------------------------------

proc tkntd { } {
   after 1 {
        source $NewRecDef_library/src/NewRecDef.tcl
        newwin NewRecDef
   }
}
