
proc ProofsPP::printer { ppfun kind flagsvar } {
        global ProofsPP_flags
        upvar 1 $flagsvar flags
        if [info exists flags(interface_maps)] { 
            set interface_maps $flags(interface_maps) 
        } else { 
            set interface_maps $ProofsPP_flags(interface_maps)
        }
        return "ProofsPPToStrings.val_to_strings
ProofsBranches.string_of_branch
\{initial_kind=[ml_string $kind],ppfun=$ppfun\}
\{interface_maps=map InterfaceMapsRegistry.find_interface_map \n[ml_stringlist $interface_maps],
parameters=
  \{dummy=true\}\}
\{initial_pos=($flags(initial_line),$flags(initial_char)),
   output_width=$flags(width)\}
"

}



proc BWDOP::header { objspec } {
        return ""
}


proc BWDOP::code { objspec } {
        return [lindex $objspec 1]
}

proc BWDOP::structuredtext_printer { flagsvar } {
        ProofsPP::delayedLoadStructuredText
        upvar 1 $flagsvar flags
        return [ProofsPP::printer ProofsPP.pp_bwdop BWDOP flags]
}

proc BWDOP::plaintext_printer { flagsvar } {
        ProofsPP::delayedLoadPlainText
        pvar 1 $flagsvar flags
        if [hol90] {
            return "Plaintext.goal_to_string \{
                        output_width=$width,
                        show_types=[ml_bool $flags(show_types)],
                        number_assums=[ml_bool $flags(number_assums)],
                        first_assum_on_top=[ml_bool $flags(first_assum_on_top)]
                \}"
        }
}


proc PBWDOP::header { objspec } {
        return ""
}


proc PBWDOP::code { objspec } {
            return [lindex $objspec 1]
}

proc PBWDOP::structuredtext_printer { flagsvar } {
        ProofsPP::delayedLoadStructuredText
        upvar 1 $flagsvar flags
        return [ProofsPP::printer ProofsPP.pp_pbwdop PBWDOP flags]
}

proc PBWDOP::plaintext_printer { flagsvar } {
        upvar 1 $flagsvar flags
        if [hol90] {
            return "Plaintext.term_to_string \{
                        output_width=$width,
                        show_types=[ml_bool $show_types]
                \}"
        }
}

