%============================================================================%
% Some examples.                                                             %
%============================================================================%

can unlink `IND-DEFS-EXAMPLES.th`;;

new_theory `IND-DEFS-EXAMPLES`;;

loadt `ind-defs`;;

%----------------------------------------------------------------------------%
% Some trivial non-mutual ones (taken from Tom's examples).                  %
%----------------------------------------------------------------------------%

new_inductive_definition `def1` [`constant`,`N`]
 (conjuncts
   "(!m:num. N R 0 m) /\
    (!n m k. N R n m /\ R m n ==> N R (n + 2) k)");;

new_inductive_definition `def2` [`constant`,`RTC1`]
 (conjuncts
   "(!x y. R x y ==> RTC1 R x y) /\
    (!x:*. RTC1 R x x) /\
    (!x y z. RTC1 R z y /\ R x z ==> RTC1 R x y)");;

new_inductive_definition `def3` [`constant`,`RTC2`]
 (conjuncts
   "(!x y. R x y ==> RTC2 R x y) /\
    (!x:*. RTC2 R x x) /\
    (!x y z. R z y /\ RTC2 R x z ==> RTC2 R x y)");;

new_inductive_definition `def4` [`constant`,`RTC3`]
 (conjuncts
   "(!x y. R x y ==> RTC3 R x y) /\
    (!x:*. RTC3 R x x) /\
    (!x y z. RTC3 R z y /\ RTC3 R x z ==> RTC3 R x y)");;

new_inductive_definition `def5` [`constant`,`XODD`]
 (conjuncts
   "XODD 2 3 /\
    !n m. XODD n m /\ (1 = 2) /\ (3 = 4) /\ XODD 2 3 ==> XODD (n + m) m");;

new_inductive_definition `def6` [`constant`,`XEVEN`]
 (conjuncts
   "XEVEN 0 /\
    !n. XEVEN(n) ==> XEVEN(n + 2)");;

%----------------------------------------------------------------------------%
% Some trivial ones which use mutuality in some way.                         %
%----------------------------------------------------------------------------%

new_inductive_definition `def7` [`constant`,`YEVEN`; `constant`,`YODD`]
 (conjuncts
   "YEVEN 0 /\ YODD 1 /\
    (!n. YEVEN(n) ==> YODD(SUC n)) /\
    (!n. YODD(n) ==> YEVEN(n + 1))");;

new_inductive_definition `def8`
  [`constant`,`RC`;
   `constant`,`RTC`;
   `constant`,`STC`;
   `constant`,`RSC`;
   `constant`,`RSTC`]
 (conjuncts
   "(!x:*. RC R x x) /\
    (!x y. R x y ==> RC R x y) /\
    (!x y. RC R x y ==> RSC R x y) /\
    (!x y. RSC R y x ==> RSC R x y) /\
    (!x y. R x y ==> STC R x y) /\
    (!x y z. STC R x y /\ STC R y z ==> STC R x z) /\
    (!u v. STC R u v ==> STC R v u) /\
    (!p q. STC R p q ==> RSTC R p q) /\
    (!w. RSTC R w w) /\
    (!x y. RC R x y ==> RTC R x y) /\
    (!x y z. RTC R x y /\ RTC R y z ==> RTC R x z)");;

%----------------------------------------------------------------------------%
% Some more complicated non-mutual ones.                                     %
%----------------------------------------------------------------------------%

new_inductive_definition `def9` [`constant`,`STUPID`]
 (conjuncts
   "(!a b c. STUPID a (a + b) (a + b + c)) /\
    (!l. ALL_EL (\x. STUPID x (SUC x) x) l ==> STUPID (HD l) 1 1) /\
    ((!l n. (?x. n = EL x l) ==> STUPID n (HD l) n) ==> STUPID 1 1 1)");;

new_inductive_definition `def10` [`constant`,`INSANE`]
 (conjuncts
   "(!n l. INSANE (P:*) (Q:num->bool) l n n ==> INSANE P Q [] 0 n) /\
    (!l n m. INSANE P Q l n (SUC m)) /\
    (!q n p. ALL_EL (\r. ?(l,s). INSANE P Q l r s) q ==> INSANE P Q q p n)");;

%----------------------------------------------------------------------------%
% A faintly realistic one: proof of WF recursion theorem.                    %
%----------------------------------------------------------------------------%

new_inductive_definition `def11` [`constant`,`RR`]
  ["!f (x:*). (!z:*. L(z,x) ==> RR L H z (f z :**)) ==> RR L H x (H f x)"];;

%----------------------------------------------------------------------------%
% Recursion theorem for N.                                                   %
%----------------------------------------------------------------------------%

new_inductive_definition `def12` [`constant`,`PRG`]
  (conjuncts
    "(PRG (e:*) f 0 e) /\
     (!n b. PRG e f n b ==> PRG e f (SUC n) (f b n))");;

%----------------------------------------------------------------------------%
% Proof system for propositional logic.                                      %
%----------------------------------------------------------------------------%

let Term_def = define_type `Term_def` `Term = Fal | Var num | Imp Term Term`;;

let Not_def = new_definition(`Not_def`,
  "Not p = Imp p Fal");;

new_inductive_definition `def13` [`constant`,`Proves`]
 (conjuncts
   "(!t. G t ==> Proves G t) /\
    (!p q. Proves G (Imp p (Imp q p))) /\
    (!p q r. Proves G (Imp (Imp p (Imp q r)) (Imp (Imp p q) (Imp p r)))) /\
    (!p. Proves G (Imp (Not (Not p)) p)) /\
    (!p q. Proves G (Imp p q) /\ Proves G p ==> Proves G q)");;

%----------------------------------------------------------------------------%
% Something similar for biconditional logic.                                 %
%----------------------------------------------------------------------------%

let biterm_Axiom_prefix = define_type `biterm`
  `biterm = Prop num
          | Iff_prefix biterm biterm`;;

new_special_symbol `<->`;;

let Iff = new_infix_definition(`Iff`,
  "$<-> s t = Iff_prefix s t");;

new_inductive_definition `def14` [`constant`,`provable`]
 (conjuncts
   "(!s. provable (s <-> s)) /\
    (!s t. provable ((s <-> t) <-> (t <-> s))) /\
    (!r s t. provable ((r <-> (s <-> t)) <-> ((r <-> s) <-> t))) /\
    (!s t. provable (s <-> t) /\ provable s ==> provable t)");;

%----------------------------------------------------------------------------%
% Combinatory logic.                                                         %
%----------------------------------------------------------------------------%

let cl_tydef_aux = define_type `cl_tydef_aux`
   `cl = Variable(num)
       | Const(num)
       | I_comb | K_comb | S_comb
       | Ap cl cl`;;

let imap = interface_map() in
  set_interface_map ([`I_comb`,`I`; `I`,`I_comb`;
                      `K_comb`,`K`; `K`,`K_comb`;
                      `S_comb`,`S`; `S`,`S_comb`]@imap);;

new_letter `'`;;

let Ap_quote = new_infix_definition(`Ap_quote`,
  "' = Ap");;

new_special_symbol `<=:`;;

new_inductive_definition `def15` [`infix`,`<=:`]
 (conjuncts
   "(!X. $<=: X X) /\
    (!X Y Z. $<=: X Y  ==> $<=: X (Y ' Z)) /\
    (!X Y Z. $<=: X Z ==> $<=: X (Y ' Z))");;

new_inductive_definition `def16` [`constant`,`weakcont`]
 (conjuncts
   "(!x. weakcont (I ' x) x) /\
    (!x y. weakcont ((K ' x) ' y) x) /\
    (!f g x. weakcont (((S ' f) ' g) ' x) ((f ' x) ' (g ' x))) /\
    (!X Y Z. weakcont X Y ==> weakcont (X ' Z) (Y ' Z)) /\
    (!W X Y. weakcont X Y ==> weakcont (W ' X) (W ' Y))");;

new_inductive_definition `def17` [`constant`,`weakred`]
 (conjuncts
   "(!x. weakred (I ' x) x) /\
    (!x y. weakred ((K ' x) ' y) x) /\
    (!f g x. weakred (((S ' f) ' g) ' x) ((f ' x) ' (g ' x))) /\
    (!X Y Z. weakred X Y ==> weakred (X ' Z) (Y ' Z)) /\
    (!W X Y. weakred X Y ==> weakred (W ' X) (W ' Y)) /\
    (!X. weakred X X) /\
    (!X Y Z. weakred X Y /\ weakred Y Z ==> weakred X Z)");;

%----------------------------------------------------------------------------%
% Provability in sequent calculus (1-sided sequents).                        %
%----------------------------------------------------------------------------%

load_library `pred_sets`;;

let Form_Axiom = define_type
  `Form_Axiom`
  `Form =  Rel    num  (Term list)
         | Neg    Form
         | And    Form Form
         | Or     Form Form
         | Impl   Form Form
         | Iff    Form Form
         | Forall num  Form
         | Exists num  Form`;;

new_constant(`Negate`,":Form->Form");;

new_constant(`PSUBST`,":(Term#num)list->Form->Form");;

new_infix(`FREE_INS`,":num->(Form->bool)->bool");;

set_interface_map [];;

hide_constant `S`;;

new_inductive_definition `def18` [`constant`,`SEQUENT`]
 (conjuncts
   "(!S f. SEQUENT (S UNION {f,Negate(f)})) /\
    (!S f1 f2. SEQUENT (S UNION {f1}) /\ SEQUENT (S UNION {f2})
                    ==> SEQUENT (S UNION {And f1 f2})) /\
    (!S f1 f2. SEQUENT (S UNION {f1}) ==> SEQUENT (S UNION {Or f1 f2})) /\
    (!S f x. SEQUENT (S UNION {f}) /\ ~(x FREE_INS S)
                    ==> SEQUENT (S UNION {Forall x f})) /\
    (!S t s x. SEQUENT (S UNION {PSUBST[s,x] t})
                    ==> SEQUENT (S UNION {Exists x t})) /\
    (!S f. SEQUENT (S UNION {f}) /\ SEQUENT (S UNION {Negate f})
                    ==> SEQUENT(S))");;

%----------------------------------------------------------------------------%
% The end.                                                                   %
%----------------------------------------------------------------------------%

close_theory();;
