Changes file for /usr/local/src/kcl/lsp/trace.lsp
Created on Wed May 23 12:36:37 1990
Usage \n@s[Original text\n@s|Replacement Text\n@s]
See the file rascal.ics.utexas.edu:/usr2/ftp/merge.c
for a program to merge change files.  Anything not between
"\n@s[" and  "\n@s]" is a simply a comment.
This file was constructed using emacs and  merge.el
Enhancements Copyright (c) W. Schelter All rights reserved.
   by (Bill Schelter)  wfs@carl.ma.utexas.edu 


****Change:(orig (5 5 c))
@s[;; proper "License Agreement for Kyoto Common LISP" with SIGLISP.

;;;;        trace.lsp

@s|;; proper "License Agreement for Kyoto Common LISP" with SIGLISP.

;;;;        trace.lsp 

@s]


****Change:(orig (8 8 a))
@s[;;;;        Tracer package for Common Lisp


@s|;;;;        Tracer package for Common Lisp

;;;;;; Modified by Matt Kaufmann to allow tracing options.

@s]


****Change:(orig (9 9 a))
@s[

@s|

;; If you are working in another package you should (import 'si::arglist)
;; to avoid typing the si::


@s]


****Change:(orig (17 17 a))
@s[

(in-package 'system)


@s|

(in-package 'system)

;;(proclaim '(optimize (safety 2) (space 3)))

@s]


****Change:(orig (19 19 d))
@s[(proclaim '(optimize (safety 2) (space 3)))

@s|
@s]


****Change:(orig (21 21 d))
@s[


@s|

@s]


****Change:(orig (28 29 c))
@s[      '*trace-list*
      `(mapcan #'trace-one ',r)))

@s|      '(mapcar #'car *trace-list*)
    `(let ((old (copy-list *trace-list*)) finish-flg)
       (unwind-protect
	   (prog1 (mapcan #'trace-one ',r)
	     (setq finish-flg t))
	 (when (null finish-flg)
	       (format *standard-output* "~%Newly traced functions:  ~S"
		       (mapcar #'car (set-difference *trace-list* old :test #'equal))))))))

@s]


****Change:(orig (33 33 c))
@s[      '(mapcan #'untrace-one *trace-list*)

@s|      '(mapcan #'untrace-one (mapcar #'car *trace-list*))

@s]


****Change:(orig (36 36 c))
@s[(defun trace-one (fname &aux f)

@s|(defun trace-one-preprocess (x)
  (cond
   ((symbolp x)
    (trace-one-preprocess (list x)))
   (t					; We've checked for CONSP with null last CDR
    (do ((tail (cdr x) (cddr tail))
	 (declarations)
	 (entryform `(cons (quote ,(car x)) arglist))
	 (exitform `(cons (quote ,(car x)) values))
	 (condform t)
	 (entrycondform t)
	 (exitcondform t)
	 (depth) (depthvar))
	((null tail)
	 (when depth
	       ;; Modify the :cond so that it first checks depth, and then
	       ;; modify the :entry so that it first increments depth.  Notice
	       ;; that :cond will be fully evaluated before depth is incremented.
	       (setq depthvar (gensym))
	       ;; now reset the condform
	       (if
		(eq condform t)
		(setq condform
		      `(< ,depthvar ,depth))
		 (setq condform `(if (< ,depthvar ,depth) ,condform nil)))
	       (setq declarations (cons (cons depthvar 0) declarations))
	       ;; I'll have the depth be incremented for all the entry stuff and no exit stuff,
	       ;; since I don't see any more uniform, logical way to do this.
	       (setq entrycondform
		     `(progn
			(setq ,depthvar (1+ ,depthvar))
			,entrycondform))
	       (setq exitcondform
		     `(progn
			  (setq ,depthvar (1- ,depthvar))
			,exitcondform)))
	 `(,(car x) ,declarations
	   (quote ,condform)
	   (quote ,entrycondform) (quote ,entryform)
	   (quote ,exitcondform) (quote ,exitform)))
	(case (car tail)
	      (:declarations
	       (setq declarations
		     (do ((decls (cadr tail) (cdr decls))
			  (result))
			 ((null decls) result)
			 (setq result
			       (cons (if (symbolp (car decls))
					 (cons (car decls) nil)
				       (cons (caar decls) (eval (cadar decls))))
				     result)))))
	      (:cond (setq condform (cadr tail)))
	      (:entrycond (setq entrycondform (cadr tail)))
	      (:entry (setq entryform (cadr tail)))
	      (:exitcond (setq exitcondform (cadr tail)))
	      (:exit (setq exitform (cadr tail))) 
	      (:depth (setq depth (cadr tail)))
	      (otherwise nil))))))

(defun check-trace-spec (form)
  (or (symbolp form)
      (if (and (consp form) (null (cdr (last form))))
	  (check-trace-args form (cdr form) nil)
	(error "Each trace spec must be a symbol or a list terminating in NIL, but ~S is not~&."
	       form))))

(defun check-declarations (declarations &aux decl)
  (when (consp declarations)
	(setq decl (if (consp (car declarations)) (car declarations) (list (car declarations) nil)))
	(when (not (symbolp (car decl)))
	      (error "Declarations are supposed to be of symbols, but ~S is not a symbol.~&"
		     (car decl)))
	(when (cddr decl)
	      (error "Expected a CDDR of NIL in ~S.~&"
		     decl))
	(when (assoc (car decl) (all-trace-declarations))
	      (error "The variable ~A is already declared for tracing"
		     (car decl)))))

(defun check-trace-args (form args acc-keywords)
  (when args
	(cond
	 ((null (cdr args))
	  (error "A trace spec must have odd length, but ~S does not.~&"
		 form))
	 ((member (car args) acc-keywords)
	  (error "The keyword ~A occurred twice in the spec ~S~&"
		 (car args) form))
	 (t
	  (case (car args)
		((:entry :exit :cond :entrycond :exitcond)
		 (check-trace-args form (cddr args) (cons (car args) acc-keywords)))
		(:depth
		 (when (not (and (integerp (cadr args))
				 (> (cadr args) 0)))
		       (error
			"~&Specified depth should be a positive integer, but~&~S is not.~&"
			(cadr args)))
		 (check-trace-args form (cddr args) (cons :depth acc-keywords)))
		(:declarations
		 (check-declarations (cadr args))
		 (check-trace-args form (cddr args) (cons :declarations acc-keywords)))
		(otherwise
		 (error "Expected :entry, :exit, :cond, :depth, or :declarations~&~
                         in ~S where instead there was ~S~&"
			form (car args))))))))

(defun trace-one (form &aux f (fname (if (consp form) (car form) form)))

@s]


****Change:(orig (47 53 c))
@s[        (cond ((and (consp (symbol-function fname))
                    (consp (nth 3 (symbol-function fname)))
                    (eq (car (nth 3 (symbol-function fname))) 'trace-call))
               (format *trace-output*

@s,              (t (untrace-one fname))))

@s|	(untrace-one fname))
  (check-trace-spec form)
  (setq form (trace-one-preprocess form))

@s]


****Change:(orig (54 54 a))
@s[  (si:fset (setq f (gensym)) (symbol-function fname))

@s|  (si:fset (setq f (gensym)) (symbol-function fname))
  (eval `(defun ,fname (&rest args)
	   (trace-call ',f args
		       ,@(cddr form))))

@s]


****Change:(orig (56 57 c))
@s[  (eval `(defun ,fname (&rest args) (trace-call ',fname ',f args)))
  (setq *trace-list* (cons fname *trace-list*))

@s|  (setq *trace-list* (cons (cons fname (cadr form)) *trace-list*))

@s]


****Change:(orig (60 76 c))
@s[(defun trace-call (fname temp-name args
                   &aux (*trace-level* *trace-level*) values indent)
  (setq *trace-level* (1+ *trace-level*))
  (setq indent (min (* *trace-level* 2) 20))

@s,  (values-list values))

@s|(defun reset-trace-declarations (declarations)
  (when declarations
	(set (caar declarations) (cdar declarations))
	(reset-trace-declarations (cdr declarations))))

@s]


****Change:(orig (77 77 a))
@s[

@s|
(defun all-trace-declarations ( &aux result)
  (dolist (v *trace-list*)
	  (setq result (append result (cdr v))))
  result)
	  
(defun trace-call (temp-name args cond entrycond entry exitcond exit
			 &aux (*trace-level* *trace-level*) vals indent)
  (when (= *trace-level* 0)
	(reset-trace-declarations (all-trace-declarations)))
  (cond
   ((eval `(let ((arglist (quote ,args))) ,cond))
    (setq *trace-level* (1+ *trace-level*))
    (setq indent (min (* *trace-level* 2) 20))
    (fresh-line *trace-output*)
    (when (or (eq entrycond t)		;optimization for common value
	      (eval `(let ((arglist (quote ,args))) ,entrycond)))
	  ;; put out the prompt before evaluating
	  (format *trace-output*
		  "~V@T~D> "
		  indent *trace-level*)
	  (format *trace-output*
		  "~S~%"
		  (eval `(let ((arglist (quote ,args))) ,entry)))
	  (fresh-line *trace-output*))
    (setq vals (multiple-value-list (apply temp-name args)))
    (when (or (eq exitcond t)		;optimization for common value
	      (eval `(let ((arglist (quote ,args)) (values (quote ,vals)))
		       ,exitcond)))
	  ;; put out the prompt before evaluating
	  (format *trace-output*
		  "~V@T<~D "
		  indent
		  *trace-level*) 
	  (format *trace-output*
		  "~S~%"
		  (eval `(let ((arglist (quote ,args)) (values (quote ,vals))) ,exit))))
    (setq *trace-level* (1- *trace-level*))
    (values-list vals))
   (t (apply temp-name args))))

@s]


****Change:(orig (79 92 c))
@s[(defun untrace-one (fname)
  (cond ((get fname 'traced)
         (if (and (consp (symbol-function fname))
                  (consp (nth 3 (symbol-function fname)))

@s,         (setq *trace-list* (list-delq fname *trace-list*))
         (list fname))

@s|(defun untrace-one (fname &aux sym)
  (cond ((setq sym (get fname 'traced))
	 (remprop fname 'traced)
	 (cond
	  ((not (fboundp fname))
	   (format *trace-output*
		   "The function ~S was traced, but is no longer defined.~%"
		   fname))

	  ;;(LAMBDA-BLOCK block-name lambda-list (TRACE-CALL ... ))
	  ((and (consp (symbol-function fname))
		(consp (nth 3 (symbol-function fname)))
		(eq (car (nth 3 (symbol-function fname))) 'trace-call))
	   (si:fset fname (symbol-function sym)))
	  (t
	   (format *trace-output*
		   "The function ~S was traced, but redefined.~%"
		   fname)))
	 (setq *trace-list*
	       (delete-if #'(lambda (u) (eq (car u) fname))
			  *trace-list* :count 1))
	 (list fname))

@s]


****Change:(orig (96 96 a))
@s[         (format *trace-output* "The function ~S is not traced.~%" fname)
         nil)))


@s|         (format *trace-output* "The function ~S is not traced.~%" fname)
         nil)))

#| Example of tracing a function "fact" so that only the outermost call is traced.

@s]


****Change:(orig (97 97 a))
@s[

@s|
(defun fact (n) (if (= n 0) 1 (* n (fact (1- n)))))

;(defvar in-fact nil)
(trace (fact :declarations ((in-fact nil))
	     :cond
	     (null in-fact)
	     :entry
	     (progn
	       (setq in-fact t)
	       (princ "Here comes input ")
	       (cons 'fact arglist))
             :exit
             (progn (setq in-fact nil)
		    (princ "Here comes output ")
                    (cons 'fact values))))

; Example of tracing fact so that only three levels are traced

(trace (fact :declarations
	     ((fact-depth 0))
	     :cond
	     (and (< fact-depth 3)
		  (setq fact-depth (1+ fact-depth)))
	     :exit
	     (progn (setq fact-depth (1- fact-depth)) (cons 'fact values))))
|#




@s]


****Change:(orig (258 258 a))
@s[  (values-list values))

@s|  (values-list values))


@s]

