signature ClamDatabase_sig =
sig
    datatype clam_data
      = Definition of {defs:(string * thm) list,
                       hol_constant_names:string list, hol_name:string,
                       thm:thm} * {clam_name:string, term:ClamAST.typ}
      | Fact of {fact:Fact.fact, hol_name:string}
                * {clam_name:string, goal:ClamAST.goal}
      | Goal of {goal:goal, hol_name:string}
                * {clam_name:string, goal:ClamAST.goal}
      | Rule of {hol_name:string, rule:string * thm, thm:thm}
                * {clam_name:string, term:ClamAST.typ}
      | Scheme of {hol_name:string, hol_types:hol_type list, thm:thm}
                  * {clam_name:string, term:ClamAST.typ}
      | Trans of {hol_name:string, rule:string * thm, thm:thm}
                 * {clam_name:string, term:ClamAST.typ}
    exception ClamDatabase of string
    val add_data : (unit -> unit) -> clam_data -> unit
    val add_translations : (string * string) list * (string * string) list
                           * (string * string) list * (string * string) list
                           -> unit
    val clam_data : unit -> clam_data list
    val delete_data : (unit -> unit) -> (clam_data -> bool) -> unit
    val delete_definition_data : (unit -> unit) -> string -> unit
    val delete_fact_data : (unit -> unit) -> string -> unit
    val delete_goal_data : (unit -> unit) -> string -> unit
    val delete_rule_data : (unit -> unit) -> string -> unit
    val delete_scheme_data : (unit -> unit) -> string -> unit
    val delete_transitivity_data : (unit -> unit) -> string -> unit
    val find_fact : string -> string * Fact.fact
    val find_goal : string -> goal * HOLtoClam.translations
    val find_scheme : string -> thm
    val find_theorem : string -> thm
    val known_hol_constants : unit -> string list
    val known_hol_types : unit -> hol_type list
    val reset_data : unit -> unit
end
