structure ClamPP =
struct

structure Const = ClamPPConstructors
and Dest = ClamPPDestructors
and Ext = ClamPPExternals;

structure PP =
struct

structure PPBoxes = PPBoxesFun (struct val char_size = 1000; end);

open PPBoxes;

fun pp (st:unit PrettySupport.string_table) s =
   let val (text_and_width,_) = #text_and_width st (s,())
   in pp_string_box text_and_width
   end;

end;

structure Local =
struct

open PrettySupport;

fun precedence "u(" = 37
  | precedence "atom" = 36
  | precedence "void" = 35
  | precedence "{true}" = 34
  | precedence "pnat" = 33
  | precedence "int" = 32
  | precedence "lambda" = 31
  | precedence "list" = 30
  | precedence "of" = 29
  | precedence "::" = 28
  | precedence "in" = 27
  | precedence "=" = 26
  | precedence ":" = 25
  | precedence "<=>" = 24
  | precedence "=>" = 24
  | precedence "#" = 24
  | precedence "\\" = 24
  | precedence "conjecture" = 23
  | precedence "thm" = 22
  | precedence "==>" = 21
  | precedence "external" = 20
  | precedence "induction" = 19
  | precedence "generalise" = 18
  | precedence "weak_fertilize" = 17
  | precedence "strong_fertilize" = 16
  | precedence "disjunction" = 15
  | precedence "-" = 14
  | precedence "hyp" = 13
  | precedence "use_hypotheses" = 12
  | precedence "term_cancel" = 11
  | precedence "new" = 10
  | precedence "equ" = 9
  | precedence "]" = 8
  | precedence "[" = 7
  | precedence "then" = 6
  | precedence "." = 5
  | precedence ")" = 4
  | precedence "," = 3
  | precedence "(" = 2
  | precedence "proof_plan" = 1
  | precedence _ = 0;

fun attrib (st:unit PrettySupport.string_table) s att =
   let fun attrib _ = (fn _ => "")
   in #attrib st s att handle PrettySupport.StringTable => attrib s att
   end;

fun is (st:unit PrettySupport.string_table) s att =
   let fun is _ = (fn _ => false)
   in #is st s att handle PrettySupport.StringTable => is s att
   end;

fun box_el f l = el PP.pp_empty_box f l;

fun lower_prec s = PREC (2 * precedence s - 1);

fun upper_prec s = PREC (2 * precedence s);

fun lpar st prec s =
   if prec_test (prec,upper_prec s) then PP.pp st "(" else PP.pp_empty_box;

fun rpar st prec s =
   if prec_test (prec,upper_prec s) then PP.pp st ")" else PP.pp_empty_box;

end;

val initial_precedence = Local.MINPREC;

val initial_params = ();

val default_h = 0
and default_v = (PP.ABSOLUTE 0,0)
and default_hv = (0,PP.ABSOLUTE 0,0)
and default_hov = (0,PP.ABSOLUTE 0,0);

structure D = Dest;

val error = " *** error *** ";

local
   open Portable Const
in

fun pp_plan st {outer_prec} tr =
   (case tr
    of Plan (goal',identifier1',number',method',identifier2') =>
       PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
          [PP.pp st "proof_plan",
           PP.pp_h_box 0
              [PP.pp st "(",
               PP.pp_hov_box (0,PP.ABSOLUTE 0,0)
                  [PP.pp_h_box 0
                      [pp_goal st {outer_prec = Local.MINPREC} goal',
                       PP.pp st ","],
                   PP.pp_h_box 0
                      [pp_identifier st {outer_prec = Local.MINPREC}
                          identifier1',PP.pp st ","],
                   PP.pp_h_box 0
                      [pp_number st {outer_prec = Local.MINPREC} number',
                       PP.pp st ","],
                   PP.pp_h_box 0
                      [pp_method st {outer_prec = Local.MINPREC} method',
                       PP.pp st ","],
                   pp_identifier st {outer_prec = Local.MINPREC}
                      identifier2'],PP.pp st ")",PP.pp st "."]])
   handle _ => PP.pp st error
and pp_method st {outer_prec} tr =
   (case tr
    of External (argument1',argument2',external') =>
       PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
          [PP.pp_h_box 0 [PP.pp st "external",PP.pp st "("],
           PP.pp_h_box 0
              [pp_argument st {outer_prec = Local.MINPREC} argument1',
               PP.pp st ","],
           PP.pp_h_box 0
              [pp_argument st {outer_prec = Local.MINPREC} argument2',
               PP.pp st ","],
           PP.pp_h_box 0
              [pp_external st {outer_prec = Local.MINPREC} external',
               PP.pp st ")"]]
     | Induction (argument',[],number',rest4 as _ :: _) =>
       let val rest4 = rev rest4
           val indtermss' = rev (tl rest4)
           and indterms' = hd rest4
       in PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
             [PP.pp_h_box 0 [PP.pp st "induction",PP.pp st "("],
              PP.pp_h_box 0
                 [pp_argument st {outer_prec = Local.MINPREC} argument',
                  PP.pp st "-"],
              PP.pp_h_box 0 [PP.pp st "[",PP.pp st "]",PP.pp st "-"],
              PP.pp_h_box 0
                 [pp_number st {outer_prec = Local.MINPREC} number',
                  PP.pp st "-"],
              PP.pp_h_box 0
                 [PP.pp st "[",
                  PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                     (map
                         (fn el =>
                             PP.pp_h_box 0
                                [Local.box_el
                                    (pp_indterms st
                                        {outer_prec = Local.MINPREC})
                                    indtermss' el,PP.pp st ","])
                         (Local.upto 1 (length indtermss')) @
                      [pp_indterms st {outer_prec = Local.MINPREC}
                          indterms']),PP.pp st "]",PP.pp st ")"]]
       end
     | Induction (argument',rest2 as _ :: _,number',rest4 as _ :: _) =>
       let val rest2 = rev rest2
           val typs' = rev (tl rest2)
           and typ' = hd rest2
           val rest4 = rev rest4
           val indtermss' = rev (tl rest4)
           and indterms' = hd rest4
       in PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
             [PP.pp_h_box 0 [PP.pp st "induction",PP.pp st "("],
              PP.pp_h_box 0
                 [pp_argument st {outer_prec = Local.MINPREC} argument',
                  PP.pp st "-"],
              PP.pp_h_box 0
                 [PP.pp st "[",
                  PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                     (map
                         (fn el =>
                             PP.pp_h_box 0
                                [Local.box_el
                                    (pp_typ st {outer_prec = Local.MINPREC})
                                    typs' el,PP.pp st ","])
                         (Local.upto 1 (length typs')) @
                      [pp_typ st {outer_prec = Local.MINPREC} typ']),
                  PP.pp st "]",PP.pp st "-"],
              PP.pp_h_box 0
                 [pp_number st {outer_prec = Local.MINPREC} number',
                  PP.pp st "-"],
              PP.pp_h_box 0
                 [PP.pp st "[",
                  PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                     (map
                         (fn el =>
                             PP.pp_h_box 0
                                [Local.box_el
                                    (pp_indterms st
                                        {outer_prec = Local.MINPREC})
                                    indtermss' el,PP.pp st ","])
                         (Local.upto 1 (length indtermss')) @
                      [pp_indterms st {outer_prec = Local.MINPREC}
                          indterms']),PP.pp st "]",PP.pp st ")"]]
       end
     | Generalise (typ1',typ2') =>
       PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
          [PP.pp_h_box 0 [PP.pp st "generalise",PP.pp st "("],
           PP.pp_h_box 0
              [PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                  [PP.pp_h_box 0
                      [pp_typ st {outer_prec = Local.MINPREC} typ1',
                       PP.pp st ","],
                   pp_typ st {outer_prec = Local.MINPREC} typ2'],
               PP.pp st ")"]]
     | WeakFertilize (argument1',argument2',argument3',identifier',typ') =>
       PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
          [PP.pp_h_box 0 [PP.pp st "weak_fertilize",PP.pp st "("],
           PP.pp_h_box 0
              [pp_argument st {outer_prec = Local.MINPREC} argument1',
               PP.pp st ","],
           PP.pp_h_box 0
              [pp_argument st {outer_prec = Local.MINPREC} argument2',
               PP.pp st ","],
           PP.pp_h_box 0
              [pp_argument st {outer_prec = Local.MINPREC} argument3',
               PP.pp st ","],
           PP.pp_h_box 0
              [pp_identifier st {outer_prec = Local.MINPREC} identifier',
               PP.pp st "-",pp_typ st {outer_prec = Local.MINPREC} typ',
               PP.pp st ")"]]
     | StrongFertilize (argument',identifier',typ') =>
       PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
          [PP.pp_h_box 0 [PP.pp st "strong_fertilize",PP.pp st "("],
           PP.pp_h_box 0
              [pp_argument st {outer_prec = Local.MINPREC} argument',
               PP.pp st ","],
           PP.pp_h_box 0
              [pp_identifier st {outer_prec = Local.MINPREC} identifier',
               PP.pp st "-",pp_typ st {outer_prec = Local.MINPREC} typ',
               PP.pp st ")"]]
     | Disjunction (rest1 as _ :: _) =>
       let val rest1 = rev rest1
           val typs' = rev (tl rest1)
           and typ' = hd rest1
       in PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
             [PP.pp_h_box 0 [PP.pp st "disjunction",PP.pp st "("],
              PP.pp_h_box 0
                 [PP.pp st "[",
                  PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                     (map
                         (fn el =>
                             PP.pp_h_box 0
                                [Local.box_el
                                    (pp_typ st {outer_prec = Local.MINPREC})
                                    typs' el,PP.pp st ","])
                         (Local.upto 1 (length typs')) @
                      [pp_typ st {outer_prec = Local.MINPREC} typ']),
                  PP.pp st "]",PP.pp st ")"]]
       end
     | Hyp (identifier',typ') =>
       PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
          [PP.pp_h_box 0 [PP.pp st "hyp",PP.pp st "("],
           PP.pp_h_box 0
              [pp_identifier st {outer_prec = Local.MINPREC} identifier',
               PP.pp st "-",pp_typ st {outer_prec = Local.MINPREC} typ',
               PP.pp st ")"]]
     | UseHypotheses (rest1 as _ :: _) =>
       let val rest1 = rev rest1
           val typs' = rev (tl rest1)
           and typ' = hd rest1
       in PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
             [PP.pp_h_box 0 [PP.pp st "use_hypotheses",PP.pp st "("],
              PP.pp_h_box 0
                 [PP.pp st "[",
                  PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                     (map
                         (fn el =>
                             PP.pp_h_box 0
                                [Local.box_el
                                    (pp_typ st {outer_prec = Local.MINPREC})
                                    typs' el,PP.pp st ","])
                         (Local.upto 1 (length typs')) @
                      [pp_typ st {outer_prec = Local.MINPREC} typ']),
                  PP.pp st "]",PP.pp st ")"]]
       end
     | TermCancel typ' =>
       PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
          [PP.pp_h_box 0 [PP.pp st "term_cancel",PP.pp st "("],
           PP.pp_h_box 0
              [pp_typ st {outer_prec = Local.MINPREC} typ',PP.pp st ")"]]
     | New (rest1 as _ :: _) =>
       let val rest1 = rev rest1
           val identifiers' = rev (tl rest1)
           and identifier' = hd rest1
       in PP.pp_h_box 0
             [PP.pp st "new",
              PP.pp_h_box 0
                 [PP.pp st "[",
                  PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                     (map
                         (fn el =>
                             PP.pp_h_box 0
                                [Local.box_el
                                    (pp_identifier st
                                        {outer_prec = Local.MINPREC})
                                    identifiers' el,PP.pp st ","])
                         (Local.upto 1 (length identifiers')) @
                      [pp_identifier st {outer_prec = Local.MINPREC}
                          identifier']),PP.pp st "]"]]
       end
     | Equ (typ',argument') =>
       PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
          [PP.pp_h_box 0 [PP.pp st "equ",PP.pp st "("],
           PP.pp_h_box 0
              [pp_typ st {outer_prec = Local.MINPREC} typ',PP.pp st ","],
           PP.pp_h_box 0
              [pp_argument st {outer_prec = Local.MINPREC} argument',
               PP.pp st ")"]]
     | MethodApp (identifier',[]) =>
       PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
          [pp_identifier st {outer_prec = Local.MINPREC} identifier']
     | MethodApp (identifier',rest2 as _ :: _) =>
       let val rest2 = rev rest2
           val arguments' = rev (tl rest2)
           and argument' = hd rest2
       in PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
             [pp_identifier st {outer_prec = Local.MINPREC} identifier',
              PP.pp_h_box 0
                 [PP.pp st "(",
                  PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                     (map
                         (fn el =>
                             PP.pp_h_box 0
                                [Local.box_el
                                    (pp_argument st
                                        {outer_prec = Local.MINPREC})
                                    arguments' el,PP.pp st ","])
                         (Local.upto 1 (length arguments')) @
                      [pp_argument st {outer_prec = Local.MINPREC}
                          argument']),PP.pp st ")"]]
       end
     | Methods (rest1 as _ :: _) =>
       let val rest1 = rev rest1
           val methods' = rev (tl rest1)
           and method' = hd rest1
       in PP.pp_h_box 0
             [PP.pp st "[",
              PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                 (map
                     (fn el =>
                         PP.pp_h_box 0
                            [Local.box_el
                                (pp_method st {outer_prec = Local.MINPREC})
                                methods' el,PP.pp st ","])
                     (Local.upto 1 (length methods')) @
                  [pp_method st {outer_prec = Local.MINPREC} method']),
              PP.pp st "]"]
       end
     | MethodThen (method1',method2') =>
       PP.pp_hv_box (1000,PP.ABSOLUTE 0,0)
          [PP.pp_hv_box (1000,PP.ABSOLUTE 0,0)
              [pp_method st {outer_prec = Local.MINPREC} method1',
               PP.pp st "then"],
           pp_method st {outer_prec = Local.MINPREC} method2'])
   handle _ => PP.pp st error
and pp_indterms st {outer_prec} tr =
   (case tr
    of InductionTerms ([],number') =>
       PP.pp_h_box 0
          [PP.pp st "[",PP.pp st "]",PP.pp st "-",
           pp_number st {outer_prec = Local.MINPREC} number']
     | InductionTerms (rest1 as _ :: _,number') =>
       let val rest1 = rev rest1
           val typs' = rev (tl rest1)
           and typ' = hd rest1
       in PP.pp_h_box 0
             [PP.pp st "[",
              PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                 (map
                     (fn el =>
                         PP.pp_h_box 0
                            [Local.box_el
                                (pp_typ st {outer_prec = Local.MINPREC}) typs'
                                el,PP.pp st ","])
                     (Local.upto 1 (length typs')) @
                  [pp_typ st {outer_prec = Local.MINPREC} typ']),PP.pp st "]",
              PP.pp st "-",pp_number st {outer_prec = Local.MINPREC} number']
       end)
   handle _ => PP.pp st error
and pp_argument st {outer_prec} tr =
   (case tr
    of Method method' => pp_method st {outer_prec = Local.MINPREC} method'
     | Metavar metavar' => pp_metavar st {outer_prec = Local.MINPREC} metavar'
     | In => PP.pp st "in"
     | Connective connective' =>
       pp_connective st {outer_prec = Local.MINPREC} connective'
     | NumList [] => PP.pp_h_box 0 [PP.pp st "[",PP.pp st "]"]
     | NumList (rest1 as _ :: _) =>
       let val rest1 = rev rest1
           val numbers' = rev (tl rest1)
           and number' = hd rest1
       in PP.pp_h_box 0
             [PP.pp st "[",
              PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                 (map
                     (fn el =>
                         PP.pp_h_box 0
                            [Local.box_el
                                (pp_number st {outer_prec = Local.MINPREC})
                                numbers' el,PP.pp st ","])
                     (Local.upto 1 (length numbers')) @
                  [pp_number st {outer_prec = Local.MINPREC} number']),
              PP.pp st "]"]
       end)
   handle _ => PP.pp st error
and pp_external st {outer_prec} tr =
   (case tr
    of Conjecture ([],typ2') =>
       PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
          [PP.pp_h_box 0 [PP.pp st "conjecture",PP.pp st "("],
           PP.pp_h_box 0 [PP.pp st "[",PP.pp st "]",PP.pp st ","],
           PP.pp_h_box 0
              [pp_typ st {outer_prec = Local.MINPREC} typ2',PP.pp st ")"]]
     | Conjecture (rest1 as _ :: _,typ2') =>
       let val rest1 = rev rest1
           val typs' = rev (tl rest1)
           and typ1' = hd rest1
       in PP.pp_hv_box (0,PP.ABSOLUTE 3000,0)
             [PP.pp_h_box 0 [PP.pp st "conjecture",PP.pp st "("],
              PP.pp_h_box 0
                 [PP.pp st "[",
                  PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                     (map
                         (fn el =>
                             PP.pp_h_box 0
                                [Local.box_el
                                    (pp_typ st {outer_prec = Local.MINPREC})
                                    typs' el,PP.pp st ","])
                         (Local.upto 1 (length typs')) @
                      [pp_typ st {outer_prec = Local.MINPREC} typ1']),
                  PP.pp st "]",PP.pp st ","],
              PP.pp_h_box 0
                 [pp_typ st {outer_prec = Local.MINPREC} typ2',PP.pp st ")"]]
       end
     | Thm identifier' =>
       PP.pp_h_box 0
          [PP.pp st "thm",PP.pp st "(",
           pp_identifier st {outer_prec = Local.MINPREC} identifier',
           PP.pp st ")"])
   handle _ => PP.pp st error
and pp_goal st {outer_prec} tr =
   (case tr
    of Goal ([],typ2') =>
       PP.pp_hv_box (0,PP.ABSOLUTE 2000,0)
          [PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
              [PP.pp_h_box 0 [PP.pp st "[",PP.pp st "]"],PP.pp st "==>"],
           pp_typ st {outer_prec = Local.MINPREC} typ2']
     | Goal (rest1 as _ :: _,typ2') =>
       let val rest1 = rev rest1
           val typs' = rev (tl rest1)
           and typ1' = hd rest1
       in PP.pp_hv_box (0,PP.ABSOLUTE 2000,0)
             [PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                 [PP.pp_h_box 0
                     [PP.pp st "[",
                      PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                         (map
                             (fn el =>
                                 PP.pp_h_box 0
                                    [Local.box_el
                                        (pp_typ st
                                            {outer_prec = Local.MINPREC})
                                        typs' el,PP.pp st ","])
                             (Local.upto 1 (length typs')) @
                          [pp_typ st {outer_prec = Local.MINPREC} typ1']),
                      PP.pp st "]"],PP.pp st "==>"],
              pp_typ st {outer_prec = Local.MINPREC} typ2']
       end)
   handle _ => PP.pp st error
and pp_typ st {outer_prec} tr =
   (case tr
    of Universe number' =>
       PP.pp_h_box 0
          [Local.lpar st outer_prec ")",
           PP.pp_h_box 0
              [PP.pp st "u(",
               pp_number st {outer_prec = Local.MINPREC} number',
               PP.pp st ")"],Local.rpar st outer_prec ")"]
     | Atom => PP.pp st "atom"
     | Void => PP.pp st "void"
     | True => PP.pp st "{true}"
     | Pnat => PP.pp st "pnat"
     | Int => PP.pp st "int"
     | Number number' => pp_number st {outer_prec = Local.MINPREC} number'
     | Identifier identifier' =>
       pp_identifier st {outer_prec = Local.MINPREC} identifier'
     | Metavariable metavar' =>
       pp_metavar st {outer_prec = Local.MINPREC} metavar'
     | Apply (identifier',rest2 as _ :: _) =>
       let val rest2 = rev rest2
           val typs' = rev (tl rest2)
           and typ' = hd rest2
       in PP.pp_h_box 0
             [Local.lpar st outer_prec "(",
              PP.pp_hv_box (0,PP.ABSOLUTE 2000,0)
                 [PP.pp_h_box 0
                     [pp_identifier st {outer_prec = Local.MINPREC}
                         identifier',PP.pp st "("],
                  PP.pp_h_box 0
                     [PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                         (map
                             (fn el =>
                                 PP.pp_h_box 0
                                    [Local.box_el
                                        (pp_typ st
                                            {outer_prec =
                                                Local.upper_prec ")"}) typs'
                                        el,PP.pp st ","])
                             (Local.upto 1 (length typs')) @
                          [pp_typ st {outer_prec = Local.upper_prec ")"}
                              typ']),PP.pp st ")"]],
              Local.rpar st outer_prec "("]
       end
     | Lambda (typ1',typ2') =>
       PP.pp_h_box 0
          [Local.lpar st outer_prec "(",
           PP.pp_hv_box (0,PP.ABSOLUTE 2000,0)
              [PP.pp_h_box 0 [PP.pp st "lambda",PP.pp st "("],
               PP.pp_h_box 0
                  [PP.pp_hv_box (0,PP.ABSOLUTE 0,0)
                      [PP.pp_h_box 0
                          [pp_typ st {outer_prec = Local.upper_prec "lambda"}
                              typ1',PP.pp st ","],
                       pp_typ st {outer_prec = Local.upper_prec "lambda"}
                          typ2'],PP.pp st ")"]],Local.rpar st outer_prec "("]
     | List typ' =>
       PP.pp_h_box 0
          [Local.lpar st outer_prec "list",
           PP.pp_hv_box (1000,PP.ABSOLUTE 2000,0)
              [pp_typ st {outer_prec = Local.upper_prec "list"} typ',
               PP.pp st "list"],Local.rpar st outer_prec "list"]
     | FunApp (typ1',typ2') =>
       PP.pp_h_box 0
          [Local.lpar st outer_prec "of",
           PP.pp_hv_box (1000,PP.ABSOLUTE 3000,0)
              [PP.pp_h_box 1000
                  [pp_typ st {outer_prec = Local.upper_prec "of"} typ1',
                   PP.pp st "of"],
               pp_typ st {outer_prec = Local.upper_prec "of"} typ2'],
           Local.rpar st outer_prec "of"]
     | Cons (typ1',typ2') =>
       PP.pp_h_box 0
          [Local.lpar st outer_prec "::",
           PP.pp_hv_box (0,PP.ABSOLUTE 2000,0)
              [PP.pp_h_box 0
                  [pp_typ st {outer_prec = Local.upper_prec "::"} typ1',
                   PP.pp st "::"],
               pp_typ st {outer_prec = Local.upper_prec "::"} typ2'],
           Local.rpar st outer_prec "::"]
     | Eq (typ1',typ2',typ3') =>
       PP.pp_h_box 0
          [Local.lpar st outer_prec "=",
           PP.pp_hv_sepbox
              (PP.pp_h_box 0
                  [pp_typ st {outer_prec = Local.upper_prec "in"} typ1',
                   PP.pp st "="])
              [((0,PP.RELATIVE 2000,0),
                pp_typ st {outer_prec = Local.upper_prec "in"} typ2'),
               ((1000,PP.RELATIVE 2000,0),
                PP.pp_h_box 1000
                   [PP.pp st "in",
                    pp_typ st {outer_prec = Local.upper_prec "in"} typ3'])],
           Local.rpar st outer_prec "="]
     | Inhabit (identifier',typ') =>
       PP.pp_h_box 0
          [Local.lpar st outer_prec ":",
           PP.pp_hv_box (0,PP.ABSOLUTE 2000,0)
              [PP.pp_h_box 0
                  [pp_identifier st {outer_prec = Local.MINPREC} identifier',
                   PP.pp st ":"],
               pp_typ st {outer_prec = Local.upper_prec ":"} typ'],
           Local.rpar st outer_prec ":"]
     | Prop (typ1',connective',typ2') =>
       PP.pp_h_box 0
          [Local.lpar st outer_prec connective',
           PP.pp_hv_box (1000,PP.ABSOLUTE 2000,0)
              [PP.pp_h_box 1000
                  [pp_typ st {outer_prec = Local.upper_prec connective'}
                      typ1',
                   pp_connective st {outer_prec = Local.MINPREC} connective'],
               pp_typ st {outer_prec = Local.upper_prec connective'} typ2'],
           Local.rpar st outer_prec connective'])
   handle _ => PP.pp st error
and pp_connective st {outer_prec} tr =
   (case tr of connective' => PP.pp st connective') handle _ => PP.pp st error
and pp_identifier st {outer_prec} tr =
   (case tr of identifier' => PP.pp st (Ext.string_of_string identifier'))
   handle _ => PP.pp st error
and pp_number st {outer_prec} tr =
   (case tr of number' => PP.pp st (Ext.string_of_integer number'))
   handle _ => PP.pp st error
and pp_metavar st {outer_prec} tr =
   (case tr of metavar' => PP.pp st (Ext.string_of_string metavar'))
   handle _ => PP.pp st error;

end;

fun print_plan st = pp_plan st {outer_prec = initial_precedence};

fun print_method st = pp_method st {outer_prec = initial_precedence};

fun print_indterms st = pp_indterms st {outer_prec = initial_precedence};

fun print_argument st = pp_argument st {outer_prec = initial_precedence};

fun print_external st = pp_external st {outer_prec = initial_precedence};

fun print_goal st = pp_goal st {outer_prec = initial_precedence};

fun print_typ st = pp_typ st {outer_prec = initial_precedence};

fun print_connective st = pp_connective st {outer_prec = initial_precedence};

fun print_identifier st = pp_identifier st {outer_prec = initial_precedence};

fun print_number st = pp_number st {outer_prec = initial_precedence};

fun print_metavar st = pp_metavar st {outer_prec = initial_precedence};

end;
