;;; Emacs interface for the Clam proof planner as a server
;;;
;;; Written by R.J.Boulton, 5th May 1998.
;;; Modified by R.J.Boulton, 14th October 1999.

(load-library "prolog")
(load-library "clam-mode")
(require 'comint)
(provide 'clam-server)

(defun clam-server (pname arg)
  (let ((args (cons "-emacs" (if (equal arg "") () (clam-args-to-list arg)))))
    (switch-to-buffer
      (if (null args)
          (apply 'make-comint "clam-server" pname nil)
          (apply 'make-comint "clam-server" pname nil args))))
  (setq major-mode 'inferior-prolog-mode
        mode-name "Inferior Clam"
        comint-prompt-regexp "^| [ ?][- ] *"
        font-lock-keywords clam-font-lock-keywords)
  (font-lock-mode))

;;; Copied from sml-proc.el
;;; (SML Mode 3.1 by Lars Bo Nielsen, Olin Shivers, and Matthew Morley)
(defun clam-args-to-list (string)
  (let ((where (string-match "[ \t]" string)))
    (cond ((null where) (list string))
          ((not (= where 0))
           (cons (substring string 0 where)
                 (clam-args-to-list (substring string (+ 1 where)
                                               (length string)))))
          (t (let ((pos (string-match "[^ \t]" string)))
               (if (null pos)
                   nil
                   (clam-args-to-list (substring string pos
                                                 (length string)))))))))
