
(defvar clam-mode-hook
  ()
  "Hooks to run when Inferior Clam mode is entered.  One might put

    (add-hook 'clam-mode-hook '(lambda () (font-lock-mode)))

to automatically enter font-lock-mode when running clam.")


(defvar clam-font-lock-keywords 
  '(
    ("FAILURE\\|DEPTH: \\|SELECTED METHOD\\|TERMINATING METHOD" .
     font-lock-keyword-face)
    ("fertilize\\wave\\unblock_then_fertilize\\elementary\\induction\\|step_case\\|base_case\\|generalise\\|normalize\\|ind_strat\\|induction_mutual\\|external_decision\\|external_lemma" . 
     clam-method-face)			; for example
    ("ih:.*$" . clam-induction-hypothesis-face)
    ("_[0-9]+" . clam-meta-variable-face)
    ;; notice that 1 and 3 sould be the same highlight!
    (clam-match (3 (progn clam-annotation-face-functor) t) ; 3 is the closing ")"
		(2 (progn clam-annotation-face-argument) t) ; 2 is the argument
		(1 (progn clam-annotation-face-functor) t))) ; 1 is "functor("
  "Used to initialize font-lock-keywords inside Inferior Clam mode.  See clam-annotations.")

(defvar clam-annotations '(("hole("  invisible clam-wave-hole-face)
			   ("wfout(" invisible clam-wave-front-out-face)
			   ("wfin("  invisible clam-wave-front-in-face)
			   ("sink("  invisible clam-sink-face))


  "A list of elements of the form (KW FACE1 FACE2).  KW is a string of
the form \"functor(\".  \"functor\" must be free of other grouping
characters or unpredicable (my img) behaviour may result.  In Inferior
Clam Mode, with font-lock enabled, this string and the corresponding
closing \"\)\" will be set to FACE1.  The intervening term structure
is set to FACE2.

There is a special case for FACE1: if it is 'invisible, that text will
be made invisble.

For example, Inferior Clam mode might use

   (\"wfout(\" 'invisible clam-wave-front-out-face)

to hide bits of term structure in the buffer and highlight in some
colour or other the wave-front.

Use this variable in order to get font-lock-mode to highlight term
structure.  The function clam-match should be used inside
font-lock-keywords in place of the regexp.")

(defvar clam-program-name "clam" "*Name of Prolog image containing Clam." )
(defun run-clam (program-name)

  "Run Clam proof-planner in buffer *PROGRAM-NAME*, in the current
directory.  The default PROGRAM-NAME to execute is the last one used,
and is shown in [...] at the prompt.  PROGRAM-NAME is \"clam\" initially.

This image runs under Inferior Clam mode, which is basically Inferior
Prolog mode with a few extensions for Clam when font-lock-mode is
eanbled (see clam-font-lock-keywords and clam-annotations for further
information).

clam-mode-hook is executed when the Prolog process is running.

\(Last modified by img/mrg/7-jul-98.\)"
  (interactive 
   (list (let ((str 
	  (read-string (concat "Clam executable [" clam-program-name "]: "))))
     (if (eq str "")
	 clam-program-name
       str)
     str)))
  (if (not (string-equal "" program-name))
      (setq clam-program-name program-name))
  (load "prolog-mode")
  (let ((prolog-mode-hook prolog-mode-hook)
	(prolog-program-name clam-program-name)
	(prolog-process-name clam-program-name)
	(prolog-process-buffer-name (concat "*" clam-program-name "*")))
    (add-hook 'prolog-mode-hook
	      '(lambda ()
		 (setq mode-name "Inferior Clam")
		 (setq font-lock-keywords clam-font-lock-keywords)
		 (run-hooks 'clam-mode-hook)) t)
    (run-prolog)))


;; stuff for inferior clam mode
(make-face 'clam-meta-variable-face)
(make-face 'clam-wave-front-out-face)
(make-face 'clam-wave-front-in-face)
(make-face 'clam-wave-hole-face)
(make-face 'clam-sink-face)
(make-face 'clam-induction-hypothesis-face)
(make-face 'clam-method-face)

(setq clam-annotation-face-functor 'clam-annotation-face-functor) ; a global variable!
(setq clam-annotation-face-argument 'clam-annotation-face-argument) ; a global variabl!e
(setq clam-meta-variable-face 'clam-meta-variable-face)
(setq clam-wave-front-out-face 'clam-wave-front-out-face)
(setq clam-wave-front-in-face 'clam-wave-front-in-face)
(setq clam-wave-hole-face 'clam-wave-hole-face)
(setq clam-sink-face 'clam-sink-face)
(setq clam-induction-hypothesis-face 'clam-induction-hypothesis-face)
(setq clam-method-face 'clam-method-face)

(defun x-color-display-p ()
  (not (equal 2 (length x-colors))))

(set-face-foreground 'clam-method-face "LimeGreen")

(set-face-foreground 'clam-wave-front-out-face "Black")
(set-face-background 'clam-wave-front-out-face "Gold")
(set-face-foreground 'clam-wave-front-in-face "Black")
(set-face-background 'clam-wave-front-in-face "GreenYellow")
(set-face-foreground 'clam-wave-hole-face "Black")
(set-face-background 'clam-wave-hole-face "Yellow")
(set-face-foreground 'clam-sink-face "Black")
(set-face-background 'clam-sink-face "PaleTurquoise")

(make-face-bold 'clam-induction-hypothesis-face)


(defun clam-match (limit)
  (clam-match-keywords clam-annotations limit))

(defun clam-match-keywords (keywords limit)
  (let ((result nil))
    (while (and 
	    (< (point) limit)
	    (not
	     (let* ((start (point))
		    (kwpair (searchkw keywords limit))
		    (cdrkwpair (cdr kwpair))
		    (keyword (nth 0 cdrkwpair))
		    (kwface  (nth 1 cdrkwpair))
		    (argface  (nth 2 cdrkwpair))
		    (invisible (eq 'invisible kwface))
		    (keywordend (car kwpair)))
	       (if (null keywordend)
		   t
		 (progn			; CAN BE REMOVED
		   (let ((keywordstart (- keywordend (length keyword)))
			 (state (parse-partial-sexp keywordend limit 0 nil
						    '(1 0 0 nil nil nil 0 nil) )))
		     (if (equal (car state) 0)
			 ;; The corresponding parenthesis has been found, and point
			 ;; is set just after it.
			 ;; Make a string that matches exactly.  this jumping
			 ;; through hoops is for integration with the use of
			 ;; match-beginning and match-end inside font-lock.
			 ;; This should always succeed since point is inside limit
			 (let* ((p (point))
				(p1 (- p 1))
				(str (concat
				      ;; first argument
				      "\\(" (regexp-quote (buffer-substring keywordstart keywordend)) "\\)"
				      ;; second argument (the argument of the keyword)
				      "\\(" (regexp-quote (buffer-substring keywordend p1)) "\\)"
				      ;; third argument (the closing ")")
				      "\\(" (regexp-quote (buffer-substring p1 p)) "\\)")))
			   (if invisible
			       (progn
				 (setq clam-annotation-face-functor font-lock-keyword-face)
				 (facemenu-set-invisible keywordstart keywordend) ; make the functor invisible
				 (facemenu-set-invisible p1 p)) ; and the closing ")"
			     (setq clam-annotation-face-functor kwface))
			   (goto-char keywordstart)
			   (re-search-forward str limit)
			   (setq clam-annotation-face-argument argface)
			   (goto-char keywordend)
			   (setq result keywordend))
		       ;; the term is incomplete, so simply return nil
		       (progn
			 (goto-char keywordend)
			 (setq result nil)))))))))
      t)
    result))

(defun searchkw (keywords limit)		    
  (assoc-min
   (filter (function (lambda (x)
		       (car x)))
	   (mapcar (lambda (kw)
		     (cons (save-excursion (search-forward (car kw) limit t))
			   kw))
		   keywords))))

(defun filter (p l)
  "Drop all elements of l not satisfying p."
  (if (null l)
      nil
    (let ((h (car l))
	  (rest (filter p (cdr l))))
      (if (apply p (list h))
	  (cons h rest)
	rest))))

(defun assoc-min (alist)
  (let ((h (car alist))
	(tl (cdr alist)))
    (assoc-min-try h tl)))
(defun assoc-min-try (min rest)
  (if (null rest)
      min
    (let ((r (car rest)))
      (if (< (car min) (car r))
	  (assoc-min-try min (cdr rest))
	(assoc-min-try r (cdr rest))))))

(defun zip (l m)
  "Zip l and m into an assoc list"
  (if (null l)
      nil
    (cons (cons (car l) (car m))
	  (zip (cdr l) (cdr m)))))
