/* 
** clam-engine.c
**
** SICStus Prolog standalone system to support HOL/Clam
**
**
** Author: Gordon Reid
** First version: 03/08/99
** Modified: 05/08/1999 by Richard Boulton
** Modified: 17/11/1999 by Richard Boulton
*/

#include <string.h>
#include <libgen.h>
#include <sicstus/sicstus.h>

/* The name of this file may change with new versions of SICStus Prolog. */
#define libsprt "libsprt37.so"

#define sp_runtime "/sp-runtime"
#define hol_clam "/hol-clam"

int main(int argc, char **argv, char **env)
{

  /* This path needs to be where sprt.sav lives. */
  char * sp_runtime_dir;

  /* The name of the main executable. */
  char * saved_state;

  sp_runtime_dir =
      (char *) calloc(strlen(argv[0]) + strlen(sp_runtime),sizeof(char));
  if (sp_runtime_dir == NULL) {
      exit (1);
    };
  strcpy(sp_runtime_dir,argv[0]);
  strcpy(sp_runtime_dir,dirname(sp_runtime_dir));
  strcat(sp_runtime_dir,sp_runtime);

  saved_state =
      (char *) calloc(strlen(argv[0]) + strlen(hol_clam),sizeof(char));
  if (saved_state == NULL) {
      exit (1);
    };
  strcpy(saved_state,argv[0]);
  strcpy(saved_state,dirname(saved_state));
  strcat(saved_state,hol_clam);

  if ( (SP_initialize(argc, argv, sp_runtime_dir)) != SP_SUCCESS )
     {
       int returnv;
       returnv = printf("SP_initialize failed\n");
       exit(1);
     }
  else { 
       int returnv;
       returnv = printf("SP_initialize succeeded\n");
       returnv =  main_loop(saved_state);
       returnv = printf("main_loop returned %d\n", returnv);
  }

  exit(0);
}

/* Main loop should have a listener for HOL that is 
** simply a call to whatever the Clam engine of HOL/Clam
** has listens on. Should we set up sockets on the Clam
** side??
**
**
**  (Runtime Systems have no predefined signal handling): 
**        void SP_raise_fault(char *message)
**     could be used
*/

int main_loop(char *saved_state)
{

 int returnv;

 /* These might be used if you were calling Clam from C
 ** instead of using 'start' predicate in SICStus.

 SP_pred_ref  call_clam;
 SP_term_ref  arg1 = SP_new_term_ref();
 SP_term_ref  arg2 = SP_new_term_ref();
 */

 returnv = printf("In main loop\n");
 returnv = printf("restoring %s\n",saved_state);

/* For this to succeed libsprt37.so must be in LD_LIBRARY_PATH 
** SP_restore normally returns, but our
**   saved state has a 'start' function. If we restore and it runs
**   'start' it does not return until the server closes.
*/

 if ( (returnv = SP_restore(saved_state)) != SP_SUCCESS ) {
     printf("SP_restore failed;  check %s is in LD_LIBRARY_PATH. 
     Alternatively the problem may be that the saved state and 
     runtime library have different versions. %d\n",libsprt,returnv);
     return SP_FAILURE;
 }
 else  { 

/*  In normal usage this message is not seen because end_clam();
**  seems to just kill the process
*/
       returnv=printf("SP_restore succeeded %d\n", returnv);
 }
 
  /*   If you want to call Clam from C then use the following.
   *   SP_predicate is more expensive than SP_pred... 
   *   We can call start from here if need be ... or create a loop.

	call_clam = SP_predicate("start", 0l , NULL);
	returnv = SP_query(call_clam, NULL);
	printf("Call to SP_query returned %d\n", returnv);
   */
  return(SP_SUCCESS);
}
