(* A very modest structure of binary trees. *)
structure Btree :> Btree =
struct

datatype 'a tree = Nil 
                 | Node of 'a * 'a tree * 'a tree;

type 'a btree = {comp : 'a -> 'a -> order,
                 tree : 'a tree}


fun empty c = {comp=c, tree=Nil};

(*---------------------------------------------------------------------------
 * Notice that we overwrite equal components.
 *---------------------------------------------------------------------------*)
fun add x {comp, tree} =
 let fun ins Nil = Node(x,Nil,Nil)
       | ins (Node(x1,left,right)) =
           case (comp x x1)
           of LESS => Node(x1, ins left, right)
            | EQUAL => Node(x,left,right)
            | GREATER => Node(x1,left,ins right)
 in 
   {comp=comp, tree=ins tree}
 end;

fun get pred {comp, tree} =
 let fun find Nil = NONE
       | find (Node(x,left,right)) =
           case (pred x)
           of LESS => find left
            | EQUAL => SOME x
            | GREATER => find right
 in find tree
 end;


fun filter P {comp,tree} =
 let fun find A Nil = A
       | find A (Node(x,left,right)) = 
           let val A' = find A right
               val A'' = if (P x handle _ => false) then x::A' else A'
           in 
              find A'' left
           end
 in find [] tree
 end;

fun elts btree = filter (fn _ => true) btree;

fun fold f {comp,tree} a = 
 let fun Ap Nil v = v
       | Ap (Node(x,left,right)) v = Ap left (f x (Ap right v))
 in Ap tree a
 end;


end;
