(****************************************************************************)
(*                                                                          *)
(* Copyright 1998-1999 University of Cambridge and University of Edinburgh  *)
(*                                                                          *)
(*                           All rights reserved.                           *)
(*                                                                          *)
(****************************************************************************)

(****************************************************************************)
(* FILE          : num_exp.sml                                              *)
(* DESCRIPTION   : Arithmetic expression example for HOL/Clam.              *)
(*                                                                          *)
(* AUTHOR        : R.J.Boulton                                              *)
(* DATE          : 17th August 1998                                         *)
(*                                                                          *)
(* LAST MODIFIED : R.J.Boulton                                              *)
(* DATE          : 16th November 1999                                       *)
(****************************************************************************)

start_clam {clam = "in_emacs clam-server"};

new_theory "num_exp";

new_parent "string";

val exp_Axiom =
   define_type
      {name = "exp",fixities = [Prefix,Prefix,Prefix,Prefix,Prefix],
       type_spec =
          `exp = Num of num | Var of string | Neg of exp
               | Plus of exp => exp | Mult of exp => exp`};

val exp_Induct = save_thm ("exp_Induct",prove_induction_thm exp_Axiom);

val VALUE =
   new_recursive_definition
      {name = "VALUE",fixity = Prefix,rec_axiom = exp_Axiom,
       def =
          Parse.term_parser
             `(!e. VALUE (Neg e) = 0 - VALUE e) /\
              (!e1 e2. VALUE (Plus e1 e2) = VALUE e1 + VALUE e2) /\
              (!e1 e2. VALUE (Mult e1 e2) = VALUE e1 * VALUE e2) /\
              (!n. VALUE (Num n) = n) /\
              (!s. VALUE (Var s) = 0)`};

val COMMUTE =
   new_recursive_definition
      {name = "COMMUTE",fixity = Prefix,rec_axiom = exp_Axiom,
       def =
          Parse.term_parser
           `(!n. COMMUTE (Num n) = Num n) /\
            (!e1 e2. COMMUTE (Plus e1 e2) = Plus (COMMUTE e2) (COMMUTE e1)) /\
            (!s. COMMUTE (Var s) = Var s) /\
            (!e. COMMUTE (Neg e) = Neg (COMMUTE e)) /\
            (!e1 e2. COMMUTE (Mult e1 e2) = Mult (COMMUTE e2) (COMMUTE e1))`};

g `!e. VALUE (COMMUTE e) = VALUE e`;
e CLAM_TAC;

(*
end_clam ();
*)
