(*--------------------------------------------------------------------------*)
(* Define structures required by the pretty-printer                         *)
(*--------------------------------------------------------------------------*)

structure ClamPPConstructors = ClamAST;
structure ClamPPDestructors = struct end;
structure ClamPPExternals = LexSupport;

(*--------------------------------------------------------------------------*)
(* Load the pretty-printer                                                  *)
(*--------------------------------------------------------------------------*)

use "clam.pp.sml";

(*--------------------------------------------------------------------------*)
(* Output functions                                                         *)
(*--------------------------------------------------------------------------*)

structure ClamPrint =
struct

structure Output = PPOutFun (ClamPP.PP.PPBoxes);

(*--------------------------------------------------------------------------*)
(* Printing to the display                                                  *)
(*--------------------------------------------------------------------------*)

fun print_to_display width =
   Output.display_ppbox width o
   ClamPP.print_plan DefaultStringTable.string_table;

(*--------------------------------------------------------------------------*)
(* Printing to a file                                                       *)
(*--------------------------------------------------------------------------*)

fun print_to_file filename width =
   Output.output_ppbox filename width o
   ClamPP.print_plan DefaultStringTable.string_table;

(*--------------------------------------------------------------------------*)
(* Printing to a stream                                                     *)
(*--------------------------------------------------------------------------*)

fun print_to_stream stream width =
   Output.output_to_stream_ppbox stream width o
   ClamPP.print_plan DefaultStringTable.string_table;

end; (* ClamPrint *)
