prettyprinter Clam =

attributes
   "u(" 37;
   "atom" 36;
   "void" 35;
   "{true}" 34;
   "pnat" 33;
   "int" 32;
   "lambda" 31;
   "list" 30;
   "of" 29;
   "::" 28;
   "in" 27;
   "=" 26;
   ":" 25;
   "<=>" 24;
   "=>" 24;
   "#" 24;
   "\\" 24;
   "conjecture" 23;
   "thm" 22;
   "==>" 21;
   "external" 20;
   "induction" 19;
   "generalise" 18;
   "weak_fertilize" 17;
   "strong_fertilize" 16;
   "disjunction" 15;
   "-" 14;
   "hyp" 13;
   "use_hypotheses" 12;
   "term_cancel" 11;
   "new" 10;
   "equ" 9;
   "]" 8;
   "[" 7;
   "then" 6;
   "." 5;
   ")" 4;
   "," 3;
   "(" 2;
   "proof_plan" 1;
end attributes

error = " *** error *** ";

rules for plan =
   Plan(*goal,*identifier1,*number,*method,*identifier2) ->
      [<hv 0,3,0> "proof_plan"
          [<h 0> "("
              [<hov 0,0,0> [<h 0> *goal:goal ","]
                  [<h 0> *identifier1:identifier ","]
                  [<h 0> *number:number ","] [<h 0> *method:method ","]
                  *identifier2:identifier] ")" "."]];
end rules

rules for method =
   External(*argument1,*argument2,*external) ->
      [<hv 0,3,0> [<h 0> "external" "("] [<h 0> *argument1:argument ","]
          [<h 0> *argument2:argument ","] [<h 0> *external:external ")"]];
   Induction(*argument,.,*number,**indtermss.*indterms) ->
      [<hv 0,3,0> [<h 0> "induction" "("] [<h 0> *argument:argument "-"]
          [<h 0> "[" "]" "-"] [<h 0> *number:number "-"]
          [<h 0> "["
              [<hv 0,0,0> **[<h 0> **indtermss:indterms ","]
                  *indterms:indterms] "]" ")"]];
   Induction(*argument,**typs.*typ,*number,**indtermss.*indterms) ->
      [<hv 0,3,0> [<h 0> "induction" "("] [<h 0> *argument:argument "-"]
          [<h 0> "[" [<hv 0,0,0> **[<h 0> **typs:typ ","] *typ:typ] "]" "-"]
          [<h 0> *number:number "-"]
          [<h 0> "["
              [<hv 0,0,0> **[<h 0> **indtermss:indterms ","]
                  *indterms:indterms] "]" ")"]];
   Generalise(*typ1,*typ2) ->
      [<hv 0,3,0> [<h 0> "generalise" "("]
          [<h 0> [<hv 0,0,0> [<h 0> *typ1:typ ","] *typ2:typ] ")"]];
   WeakFertilize(*argument1,*argument2,*argument3,*identifier,*typ) ->
      [<hv 0,3,0> [<h 0> "weak_fertilize" "("] [<h 0> *argument1:argument ","]
          [<h 0> *argument2:argument ","] [<h 0> *argument3:argument ","]
          [<h 0> *identifier:identifier "-" *typ:typ ")"]];
   StrongFertilize(*argument,*identifier,*typ) ->
      [<hv 0,3,0> [<h 0> "strong_fertilize" "("]
          [<h 0> *argument:argument ","]
          [<h 0> *identifier:identifier "-" *typ:typ ")"]];
   Disjunction(**typs.*typ) ->
      [<hv 0,3,0> [<h 0> "disjunction" "("]
          [<h 0> "[" [<hv 0,0,0> **[<h 0> **typs:typ ","] *typ:typ] "]" ")"]];
   Hyp(*identifier,*typ) ->
      [<hv 0,3,0> [<h 0> "hyp" "("]
          [<h 0> *identifier:identifier "-" *typ:typ ")"]];
   UseHypotheses(**typs.*typ) ->
      [<hv 0,3,0> [<h 0> "use_hypotheses" "("]
          [<h 0> "[" [<hv 0,0,0> **[<h 0> **typs:typ ","] *typ:typ] "]" ")"]];
   TermCancel(*typ) ->
      [<hv 0,3,0> [<h 0> "term_cancel" "("] [<h 0> *typ:typ ")"]];
   New(**identifiers.*identifier) ->
      [<h 0> "new"
          [<h 0> "["
              [<hv 0,0,0> **[<h 0> **identifiers:identifier ","]
                  *identifier:identifier] "]"]];
   Equ(*typ,*argument) ->
      [<hv 0,3,0> [<h 0> "equ" "("] [<h 0> *typ:typ ","]
          [<h 0> *argument:argument ")"]];
   MethodApp(*identifier,.) -> [<hv 0,3,0> *identifier:identifier];
   MethodApp(*identifier,**arguments.*argument) ->
      [<hv 0,3,0> *identifier:identifier
          [<h 0> "("
              [<hv 0,0,0> **[<h 0> **arguments:argument ","]
                  *argument:argument] ")"]];
   Methods(**methods.*method) ->
      [<h 0> "[" [<hv 0,0,0> **[<h 0> **methods ","] *method] "]"];
   MethodThen(*method1,*method2) ->
      [<hv 1,0,0> [<hv 1,0,0> *method1 "then"] *method2];
end rules

rules for indterms =
   InductionTerms(.,*number) -> [<h 0> "[" "]" "-" *number:number];
   InductionTerms(**typs.*typ,*number) ->
      [<h 0> "[" [<hv 0,0,0> **[<h 0> **typs:typ ","] *typ:typ] "]" "-"
          *number:number];
end rules

rules for argument =
   Method(*method) -> *method:method;
   Metavar(*metavar) -> *metavar:metavar;
   In() -> "in";
   Connective(*connective) -> *connective:connective;
   NumList(.) -> [<h 0> "[" "]"];
   NumList(**numbers.*number) ->
      [<h 0> "[" [<hv 0,0,0> **[<h 0> **numbers:number ","] *number:number]
          "]"];
end rules

rules for external =
   Conjecture(.,*typ2) ->
      [<hv 0,3,0> [<h 0> "conjecture" "("] [<h 0> "[" "]" ","]
          [<h 0> *typ2:typ ")"]];
   Conjecture(**typs.*typ1,*typ2) ->
      [<hv 0,3,0> [<h 0> "conjecture" "("]
          [<h 0> "[" [<hv 0,0,0> **[<h 0> **typs:typ ","] *typ1:typ] "]" ","]
          [<h 0> *typ2:typ ")"]];
   Thm(*identifier) -> [<h 0> "thm" "(" *identifier:identifier ")"];
end rules

rules for goal =
   Goal(.,*typ2) -> [<hv 0,2,0> [<hv 0,0,0> [<h 0> "[" "]"] "==>"] *typ2:typ];
   Goal(**typs.*typ1,*typ2) ->
      [<hv 0,2,0>
          [<hv 0,0,0>
              [<h 0> "[" [<hv 0,0,0> **[<h 0> **typs:typ ","] *typ1:typ] "]"]
              "==>"] *typ2:typ];
end rules

rules for typ =
   Universe(*number) ->
      [<h 0> lpar{")"} [<h 0> "u(" *number:number ")"] rpar{")"}];
   Atom() -> "atom";
   Void() -> "void";
   True() -> "{true}";
   Pnat() -> "pnat";
   Int() -> "int";
   Number(*number) -> *number:number;
   Identifier(*identifier) -> *identifier:identifier;
   Metavariable(*metavar) -> *metavar:metavar;
   Apply(*identifier,**typs.*typ) ->
      [<h 0> lpar{"("}
          [<hv 0,2,0> [<h 0> *identifier:identifier "("]
              [<h 0> [<hv 0,0,0> **[<h 0> (**typs <= ")") ","] (*typ <= ")")]
                  ")"]] rpar{"("}];
   Lambda(*typ1,*typ2) ->
      [<h 0> lpar{"("}
          [<hv 0,2,0> [<h 0> "lambda" "("]
              [<h 0>
                  [<hv 0,0,0> [<h 0> (*typ1 <= "lambda") ","]
                      (*typ2 <= "lambda")] ")"]] rpar{"("}];
   List(*typ) ->
      [<h 0> lpar{"list"} [<hv 1,2,0> (*typ <= "list") "list"] rpar{"list"}];
   FunApp(*typ1,*typ2) ->
      [<h 0> lpar{"of"}
          [<hv 1,3,0> [<h 1> (*typ1 <= "of") "of"] (*typ2 <= "of")]
          rpar{"of"}];
   Cons(*typ1,*typ2) ->
      [<h 0> lpar{"::"}
          [<hv 0,2,0> [<h 0> (*typ1 <= "::") "::"] (*typ2 <= "::")]
          rpar{"::"}];
   Eq(*typ1,*typ2,*typ3) ->
      [<h 0> lpar{"="}
          [<hv 0,++ 2,0> [<h 0> (*typ1 <= "in") "="] (*typ2 <= "in")
              <1,++ 2,0> [<h 1> "in" (*typ3 <= "in")]] rpar{"="}];
   Inhabit(*identifier,*typ) ->
      [<h 0> lpar{":"}
          [<hv 0,2,0> [<h 0> *identifier:identifier ":"] (*typ <= ":")]
          rpar{":"}];
   Prop(*typ1,*connective,*typ2) ->
      [<h 0> lpar{connective}
          [<hv 1,2,0> [<h 1> (*typ1 <= connective) *connective:connective]
              (*typ2 <= connective)] rpar{connective}];
end rules

rules for connective =
   connective -> connective;
end rules

rules for identifier =
   identifier -> (string_of_string(identifier));
end rules

rules for number =
   number -> (string_of_integer(number));
end rules

rules for metavar =
   metavar -> (string_of_string(metavar));
end rules

end prettyprinter
