structure Fact :> Fact_sig =
struct

type pprinter = PrettyPrint.ppstream -> unit;

 datatype fact = Proved of thm * pprinter
               | CantProve of term list * term
               | Refuted of term list * term;


 val empty = Btree.empty(fn (s,(f:fact)) => fn (t,g) => String.compare (s,t));
 val the_factDB = ref empty;

 fun clear() = (the_factDB := empty)

 fun add (s,f) = (the_factDB := Btree.add (s,f) (!the_factDB));

 fun get s1 = Btree.get (fn (s2,_) => String.compare (s1,s2)) (!the_factDB);

 fun elts () = Btree.elts (!the_factDB);

  datatype 'a age = NEW of 'a | OLD of 'a

  fun dest_age (NEW x) = x
    | dest_age (OLD x) = x;

end;
