/*
 * @(#)$Id: plus_cancel.pl,v 1.1.2.1 1999/06/08 14:50:21 rjb Exp $
 *
 * $Log: plus_cancel.pl,v $
 * Revision 1.1.2.1  1999/06/08 14:50:21  rjb
 * Extensions and modifications to support hardware verification.
 *
 */

/* Predicates for cancellation of summands that occur on both sides of an
 * equation.
 */

/* only_sum/2.
 */
only_sum(A,X):-
    natural_plus(F),
    A =.. [F,T,R],
    only_sum(T,X1),
    only_sum(R,X2),
    append(X1,X2,X), !.
only_sum(V,[V]).

/* putPlus/2.
 */
putPlus([],Zero):-
    natural_type(_,Zero,_).
putPlus([H],H).
putPlus([H|T],Goal):-
    natural_plus(F),
    Goal =.. [F,H,R],
    putPlus(T,R).

/* cancel_eq/4.
 */
cancel_eq([],L,[],L).
cancel_eq([H|T1],L,T,R):-
    select(H,L,L1),
    cancel_eq(T1,L1,T,R), !.
cancel_eq([H|T1],L,[H|Q1],Q2):-
    cancel_eq(T1,L,Q1,Q2).
