/*
 * @(#)$Id: method_pre.pl,v 1.1.2.1 1999/11/17 10:10:32 rjb Exp $
 *
 * $Log: method_pre.pl,v $
 * Revision 1.1.2.1  1999/11/17 10:10:32  rjb
 * Support for a lemma calculation (wave) critic.
 *
 */

% Simple critics for HOL/Clam.
%
% Code taken from Mike Jackson's Interactive Proof Critics version of
% XBarnacle, which was in turn taken from Andrew Ireland's Clam v3.2.
%
% Modifications by Richard Boulton for HOL/Clam:
% + Changed names of singleton variables so that they begin with an
%   underscore. It looks like some of the code involving them is redundant.
%   The singleton occurrence of AVars in one of the clauses of
%   extend_hyps_with_cond suggests that there is a missing argument. I have
%   added the argument with the effect of bringing the clause into play.

% XBARNACLE 2.6/IPC
% 
% Removed predicates that also arise in CLaM 2.6
% Removed unused predicates
%
% Altered definition of func_defeqn predicate to use a combination
% of rewrite/7 call and equation/4 call to generate appropriate output
% as this saves having to add an explicit un_defeqn structure like
% CLam 3.2 uses
%
% reduction_rule/3 is now called reduction_rule_32/3 also redegined
% to use combination of reduction/7 and equation/4 call to generate
% the appropriate output - for the same reasons (the renaming is due
% to the fact that CLaM 2.6 has a reduction_rule/3 predicate also.
%
% Changed call to scheme/1 in wave_occ to scheme/3 for compatability
%  with 2.6
%
% Changed definition of induction_hyp/2 to make use of 2.6 rather than
% 3.2 format

/*
 * CLAM.v3.2
 *
 * This file contains code for the meta-level predicates
 * used to define the proof methods. The file is divided
 * preconditions and effects.
 *
 */

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% PRECONDITIONS
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% induction_vars/3
%
%
induction_vars(Context, Goal, Vars, Typs):-
        wave_fronts(_, [], Goal),
        freevarsinterm(Goal, FVars),
        findall(OSVarTyps, (subseq(FVars, _, SVars), 
                            \+ SVars = [],
                            map_list(SVars, Var:=>(Var:Typ), 
                                            member(Var:Typ, Context), 
                                     SVarTyps),
                            order_vartyps(SVarTyps, OSVarTyps)), VarTypsL),
        member(VarTyps, VarTypsL), 
        vars_typs(VarTyps, Vars, Typs).


% order_vartyps/2: Hack to get ordering of induction variables
%                  compatible with scheme/5.
%
order_vartyps([V:T], [V:T]).
order_vartyps([V1:pnat,V2:T2], [V1:pnat,V2:T2]).
order_vartyps([V1:T1 list, V2:pnat], [V2:pnat, V1:T1 list]). 


vars_typs([], [], []).
vars_typs([V:T|VTs], [V|Vs], [T|Ts]):-
	vars_typs(VTs, Vs, Ts).

% wave_occ/4
%
%
wave_occ(H, G, VarTyps, IndTerms):-
        var(IndTerms),
        matrix(VTList, M, G),
        append(H, VTList, Context),
        induction_vars(Context, M, Vars, Typs),
        \+ non_wave_occ(M, Vars, _, _, _),
	wave_occ_(M, Vars, IndTerms), 
        vars_typs(VarTyps, Vars, Typs).
wave_occ(H, G, VarTyps, IndTerms):-
        var(IndTerms),
	matrix(VTList, M, G),
        append(H, VTList, Context),
        induction_vars(Context, M, Vars, Typs),
        non_wave_occ(M, Vars, _, _, _),
	wave_occ_(M, Vars, IndTerms), 
        vars_typs(VarTyps, Vars, Typs).
wave_occ(_H, _G, _VarTyps, IndTerms):-
        \+ var(IndTerms).


% wave_occ_/3
%
%
wave_occ_(Term, Vars, IndTerms):-
	wave_occ(Term, Vars, _, _, _, IndTerms, _).

% non_wave_occ/5: need to replace with a primary ripple path filter.
%
%
non_wave_occ(Term, Vars, VarsPosL, F, FPos):-
	wave_func(Term, Vars, VarsPosL, F, FPos, FSch, _),
	\+ (wave_rule(_, _, _ => FSch :=> _),
            base_rewrite(FSch)),!.

base_rewrite(FSch):-
	wave_fronts(F, WSpec, FSch),
        make_ground(F),
	forall{Pos\member(Pos-_, WSpec)}:
              (exp_at(F, Pos, Constr),
               oyster_type(_, [Constr], [BaseVal]),
	       replace(Pos, BaseVal, F, BasePatt),
               (func_defeqn(BasePatt, _);
                reduction_rule32(BasePatt, _, _))).

% wave_occ/7
%
%
wave_occ(Term, Vars, VarsPosL, F, FPos, IndTerms, Rn):-
        wave_func(Term, Vars, VarsPosL, F, FPos, FSch, VarsMVars),
        wave_rule(Rn, _, _ => FSch :=> RHS),
        wave_fronts(_, WFSpec, RHS),
        \+ (member(_-_/[Type,_], WFSpec), var(Type)),
        % \+ meta_term_occ_at(RHS, _, _), % Prevent spec wave-rules 
        %                                 % motivating an induction.
	zip(VarsMVars, _, MVars),
	\+ (member(T, MVars), var(T)),
        wave_fronts(IndTerms, _, MVars),
        \+ \+ scheme(IndTerms,_,_),!.

% wave_func/6
%
%
wave_func(Term, Vars, VAbsPosL, F, FinTerm, FSch, VarsMVars):-
        member(Var, Vars),
        exp_at(Term, VarinTerm, Var),
        append([_VarinF], FinTerm, VarinTerm),
        exp_at(Term, FinTerm, F),
        map_list(Vars, V :=> V-VRelPos-VAbsPos, (exp_at(F, VRelPos, V),
	                                         append(VRelPos, FinTerm, VAbsPos)),
                 VRelPosLVAbsPosL),
        zip(VRelPosLVAbsPosL, VRelPosL, VAbsPosL),
	replace_object_vars(VRelPosL, F, FSch, VarsMVars).

replace_object_vars(_, Term, _, _):-
	atomic(Term),!,fail.
replace_object_vars([], Term, Term, []).
replace_object_vars([Var-Pos|PosL], F, FSch, [Var-MVar|VarMVars]):-
	replace(Pos, MVar, F, NF),
	replace_object_vars(PosL, NF, FSch, VarMVars).

% induction_hyp/2
%
%

induction_hyp(V:IndHyp,H):-
	inductive_hypothesis(_,V:IndHyp,H).

% wave_occ_at/3
%
%
wave_occ_at(Exp, Pos, SubExp):-
    findall(Pos-SubExp, definite_wave_occ_at(Exp,Pos,SubExp), PosDWaves),
    map_list(PosDWaves, P-L:=> Size-(P-L), size(L,Size), PosSizeDWaves),
    smallest(Pos-SubExp, PosSizeDWaves).
wave_occ_at(Exp, Pos, SubExp):-
    findall(Pos-SubExp,potential_wave_occ_at(Exp,Pos,SubExp),PosPWaves),
    member(Pos-SubExp, PosPWaves).

% ripplable/2
%
%
ripplable(H, G) :-
    wave_occ_at(G, _, L),
    split_wave_fronts(L, _, LHS),
    wave_rule(_, _, C=>LHS:=>_),
    trivial(H==>C).
ripplable(H, G) :-
    wave_occ_at(G, _, LHS),
    wave_rule(_, _, C=>LHS:=>_),
    trivial(H==>C).
ripplable(_H, G) :-
    wave_occ_at(G, _, LHS),
    partial_wave_rule_match(LHS, _).

% partial_induction_hyp_match/5
%
%
partial_induction_hyp_match(Var, H, G, NewG, SubstL):-
    not var(H),
    not var(G),
    matrix(Vars, Mat, G),
    wave_fronts(_, [_|_], Mat),
    \+ (meta_variable_occ_at(Mat, _, MVar),
        meta_variable_occ_in_lemma(MVar, _)),
    elim_trailing_waves(Mat, SubstL),
    apply_annsubst_list(SubstL, Mat, L = R in Typ),
    all_waves_beached(L),
    all_waves_beached(R),
    induction_hyp(Var:IndHyp, H),
    matrix(HypVars, SL = SR in _, IndHyp),
    replace_universal_vars(HypVars, [SL,SR], [NSL,NSR]),
    (
     (exp_at(R, Pos, NSR),
      replace(Pos, NSL, R, NewR),
      matrix(Vars, L = NewR in Typ, NewG));
     (exp_at(L, Pos, NSL),
      replace(Pos, NSR, L, NewL),
      matrix(Vars, NewL = R in Typ, NewG))
     ).
%
% Conditional version.
%
partial_induction_hyp_match(Var, H, G, NewG, []):-
    not var(H),
    not var(G),
    matrix(Binds, Cond => Body, G),
    member(Body-NewBody, [(L = R in Typ)-(NewL = R in Typ), 
                          (L => R)-(NewL => R)]),
    wave_fronts(_, [], Cond),
    all_waves_beached(L),
    all_waves_beached(R),
    induction_hyp(Var:IndHyp, H),
    matrix(BindsIH, CondIH => BodyIH, IndHyp),
    elementary([]==>Cond=>CondIH, _),
    member(BodyIH, [LIH = RIH in Typ, LIH => RIH]),
    replace_universal_vars(BindsIH, [LIH,RIH], [MetaLIH,MetaRIH]),
    exp_at(L, Pos, MetaLIH),
    replace(Pos, MetaRIH, L, NewL),
    matrix(Binds, NewBody, NewG).

% Needs rationalizing with code for
% generate_annsubst_list/_ (wave_rule_match.pl)
%
elim_trailing_waves(Form, SubstL):-
        wave_fronts(EForm, WFSpec, Form),
	findall(Pos-WHPos, (meta_term_occ_at(EForm, Pos, MTerm),
                            functor(MTerm, MVar, _),
                            \+ meta_variable_occ_in_lemma(MVar, _),
                            member(Pos-[WHPos]/_, WFSpec)),
                PosL),
        map_list(PosL, (Pos-WHPos):=> Subst, 
                       (exp_at(EForm, Pos, MTerm),
	                MTerm =.. [F|Args],
                        same_length(Args, MArgs),
                        map_list(MArgs, L:=>GL-L, is_grounded(GL), GMArgsL),
                        zip(GMArgsL, GArgs, MArgs),
                        GTerm =.. [F|GArgs],
                        wave_fronts(GTerm, [[]-[WHPos]/[_,out]], AnnGTerm),
                        [ArgPos] = WHPos,
                        arg(ArgPos, GTerm, NGTerm),
                        replace_universal_vars_1(GMArgsL, [AnnGTerm, NGTerm], Subst)),
                SubstL).
                                  
% induction_hyp_match/4
%
%
induction_hyp_match(Var, H, G, SubstL):-
    not var(H),
    not var(G),
    ind_hyp_match(Var, H, G, SubstL).

% ind_hyp_match/4
%
% First-order case
%
ind_hyp_match(Var, H, G, []):-
    not potential_wave_occ(G),
    % matrix(_, L = R in _, G),
    matrix(_, M, G),
    induction_hyp(Var: IndHyp, H),
    instantiate(IndHyp, M, _).
%
% Higher-order case
%
ind_hyp_match(Var, H, G, SubstL):-
    matrix(Vars, M, G),
    potential_wave_occ(M),
    % (fully_rippled(M); 
    % not definite_wave_occ(M),
    coerce_meta_variables(M, SubstL1),
    wave_fronts(ErasedM1, _, M),
    apply_subst_list(SubstL1, ErasedM1, ErasedM2),
    append(H, Vars, Context),
    coerce_sinks(Context, ErasedM2, SubstL2),
    apply_subst_list(SubstL2, ErasedM2, ErasedM3),
    apply_subst_list(SubstL2, H, NewH),
    matrix(Vars, ErasedM3, NewG),
    \+ disprove(NewH==>NewG),
    induction_hyp(Var: IndHyp, H),
    instantiate(IndHyp, ErasedM3, _),
    append(SubstL1, SubstL2, SubstL).
    
%
% Forcing fertilization projection of
% meta wave-functions.
%
ind_hyp_match(Var, H, G, SubstList):-
    matrix(Vars, L = R in Typ, G),
    potential_wave_func(L),
    potential_wave_func(R),
    strip_meta_annotations(L, EraseL),
    strip_meta_annotations(R, EraseR),
    meta_term_occ_at(EraseL, _PosL, MTermL),
    meta_term_occ_at(EraseR, _PosR, MTermR),
    build_projection(MTermL, SubstL),
    build_projection(MTermR, SubstR),
    append(SubstL, SubstR, SubstList),
    apply_subst_list(SubstList, EraseL = EraseR in Typ, NewM),
    matrix(Vars, NewM, NewG),
    apply_subst_list(SubstList, H, NewH),
    \+ disprove(NewH==>NewG),
    induction_hyp(Var: IndHyp, H),
    apply_subst_list(SubstList, IndHyp, NIndHyp),
    instantiate(NIndHyp, NewM, _),
    writef('%t==>%t\n',[NewH,NewG]).

build_projection(MTerm, [[SkelMTerm, SkelMArg]]):-
    skeleton(MTerm, SkelMTerm),
    SkelMTerm =.. [_|SkelMArgs],
    member(SkelMArg, SkelMArgs).
    
% coerce_meta_variables/2
%
%
coerce_meta_variables(Term, SubstL):-
    fully_rippled(Term),
    meta_variable_occ_at(Term, _, MVar),
    meta_variable_occ_in_lemma(MVar, Lemma),
    eval_partial_lemma(Lemma, SubstL),
    apply_subst_list(SubstL, Lemma, NewLemma),
    \+ disprove([]==>NewLemma).
coerce_meta_variables(Term, SubstL):-
    erase_potential_waves(Term, _, SubstL),
    meta_variable_occ_at(Term, _, MVar),
    meta_variable_occ_in_lemma(MVar, Lemma),
    apply_subst_list(SubstL, Lemma, NewLemma),
    \+ disprove([]==>NewLemma).

% coerce_sinks/3
%
%
coerce_sinks(_Context, L = R in _Typ, []):-
    sinks(L, Sink),
    sinks(R, Sink).
coerce_sinks(Context, L = R in Typ, SubstL):-
    sinks(L, SinkL),
    sinks(R, SinkR),
    freevarsinterm(SinkL, VarsinSinkL),
    freevarsinterm(SinkR, VarsinSinkR),
    union(VarsinSinkL, VarsinSinkR, Vars),
    map_list(Vars, V:=> (V:T), member(V:T, Context), NewContext),
    matrix(NewContext, SinkL = SinkR in Typ, Lemma),
    eval_partial_lemma(Lemma, SubstL),
    apply_subst_list(SubstL, Lemma, NewLemma),
    \+ disprove([]==>NewLemma).
coerce_sinks(_, Form, []):-
    sinks(_, [], Form).

% sinks/2
%
%    
sinks(Term, Sink):-
	sinks(_, SPosL, Term),
        member(SPos, SPosL),
	exp_at(Term, SPos, Sink).

% trivial/1
%
%
trivial(H==>C):-
    \+ var(C),
    trivial(H,C).
trivial(_,[]).
trivial(H,[C]):-
    strip_meta_annotations(C,CC),
    elementary(H==>[CC],_).
/*
% sinkable/1
%
%
sinkable(Term):-
	\+ var(Term),
	wave_fronts(_, WFSpec, Term),
	findall(AbsWHPos, (member(WPos-[WHPos]/[_,in], WFSpec),
                           append(WHPos, WPos, AbsWHPos)), AbsWHPosL),
        sinkable(AbsWHPosL, Term).
*/
sinkable([], _Term).
sinkable([Pos|PosL], Term):-
	exp_at(Term, Pos, SubTerm),
        sinks(_, [_|_], SubTerm),
	sinkable(PosL, Term). 

sinkable(WavePos, Goal, SinkVar):-
    \+ var(WavePos), \+ var(Goal),
    matrix(_, Matrix, Goal),
    exp_at(Matrix, WavePos, SubTerm),
    \+ equality_term(SubTerm),
    sinks(_, SSpec, SubTerm),
    wave_fronts(_, WFSpec, SubTerm),
    member(SPos, SSpec),
    member(WFPos-_/[hard,_], WFSpec),
    \+ SPos == WFPos,
    append(SPos, WavePos, SinkVarPos),
    exp_at(Matrix, SinkVarPos, SinkVar).

equality_term(_ = _ in _).
equality_term(_ = _).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% EFFECTS
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

/*
 * As replace/3 except position is taken to be
 * with respect to the matrix of the given formula.
 *
 */

replace_in_matrix(Pos, Exp, Form, NewForm):-
    matrix(Vars, Mat, Form),
    replace(Pos, Exp, Mat, NewMat),
    matrix(Vars, NewMat, NewForm).

/***********************************

 sink_expansions/2 

 **********************************/

sink_expansions(G, NewG):-
    matrix(Vars, Mat, G),
    sinks(NMat, SSpec, Mat),
    wave_fronts(_, WSpec, Mat),
    sink_expansions(WSpec, SSpec, NewSSpec),
    sinks(NMat, NewSSpec, NewMat),
    matrix(Vars, NewMat, NewG).

strip_redundant_waves([], Term, Term).
strip_redundant_waves([P|PL], Term, NewTerm):-
    exp_at(Term, P, SubTerm),
    wave_fronts(ESubTerm, _, SubTerm),
    replace(P, ESubTerm, Term, NTerm),
    strip_redundant_waves(PL, NTerm, NewTerm).

%===============================================================================
%
%  Version 2.1 method predicates
%
%===============================================================================
/*
 * This file contains the predicates of the method-language. The
 * connectives that can be used in the method-language (apart of course
 * from the Prolog conjunction ",") live in the file method-conn.pl
 */


surrounding_term( Pos, Term, SurTerm, STPos ) :-
      reverse( Pos, RPos ),
      surr_term( RPos, Term, SurTerm, [], STPos ).
surr_term( [_|_], Term, Term, STPos, STPos ).
surr_term( [H|T], Term, SurTerm, CurPos, STPos ) :-
    exp_at( Term, [H], SbTerm ),
    surr_term( T, SbTerm, SurTerm, [H|CurPos], STPos ).


        % reduction_rule(?Exp,?RuleName:?Rule,?Pos) :-
        % RuleName is the name of an equality which is a reduction rule.
        % Rule is the equality, with all universally quantified
        % variables replaced by meta-(Prolog) variables.
        % Pos is the position in Exp which is being rewritten. 
        %
        % A reduction rule is a rule which either removes a constant
        % expression, or which is a wave rule where the wave front is a
        % type constructor. 
        %
        % These things are stored at load time, so all we have to do is
        % to access the cached representation.
/*
reduction_rule(Exp,RuleName:Rule,Pos) :-
    recorded(reduction,reduction(Exp,RuleName:Rule,Pos),_).
*/

% This version allows us to make use of 2.6s reduction/7
% entries. Note that we have the not-equation check since
% CLam 3.2 does not add reduction rules for equations, only
% for theorems loaded in as reduction rules (red)
%
% Note that CLaM v3.2 reduction rules are determined by
 % % reduction.pl/is_a_reduction_rule/3 where Pos is a position
 % in L. However from examination of this procedure the exp_at/3
 % predicate that gets this Pos the variables from it are not
 % used of changed in any way - they always return [].
 % Besides reduction_rule32/3 is only used at one point by CLaM v3.2
 % here in method_pre.pl and it ignores the second and third arguments
 
reduction_rule32(L,Name:C=>L:=>R,[]) :-
   reduction(L,_,R,_,C,_,Name),
   \+ equation(_,Name,_).

        % func_defeqn/2 for the expression Exp the base-case defining
        % equation named Rule is applicable.
/*
func_defeqn(Exp,Rewrite):-
    recorded(un_defeqn,
             un_defeqn(Exp,Rewrite),_).
*/

% This version saves us having to add un_defeqn entries
% It just uses Clam 2.6s rewrite/7 clause to get the same
% information as provided by un_defeqn entries and equation/3
% entries to check that the rewrite entry retrieved corresponds
% to an equation used as part of a definition (and not other
% rewrites).

func_defeqn(L,Name:C=>L:=>R):-
	rewrite(L,_,R,_,CC,equ(left),Name),
	func_defeqn_c(CC,C),
        equation(_,Name,_).	

func_defeqn_c([],[]):-!.
func_defeqn_c(CC,[CC]):-!.

       % split_into_cases( +CaseAnal, +Goal, -SplitGoal )
       % Given a case-analysis (a list of Name:Type) and a CLaM goal
       % build the list of CLaM goals that result from applying the
       % case-analysis.
       %
       % Try to preserve the Name's, if possible, as the names of
       % the new hypotheses in the case-split goals.

split_into_cases( [Cond|Rest], H==>G, [NH==>G|RestHG] ) :-
    extend_hyps_with_cond( Cond, H, NH ),
    !,
    split_into_cases( Rest, H==>G, RestHG ).
split_into_cases( [], _, [] ).

extend_hyps_with_cond( [V:Cond|Rest], AVars, Hyps, EHyps ) :-
    hyp( V:Cond, Hyps ),
    !,
    extend_hyps_with_cond( Rest, AVars, Hyps, EHyps ).
extend_hyps_with_cond( [V:Cond|Rest], AVars, Hyps, EHyps ) :-
    hfree( [V], Hyps ),
    !,
    append(Hyps, [V:Cond], NHyps),
    extend_hyps_with_cond( Rest, AVars, NHyps, EHyps ).
extend_hyps_with_cond( [V:Cond|Rest], AVars, Hyps, EHyps ) :-
    !,
    hfree([VV], Hyps ),
    DD =.. [dd|Rest],
    s( DD, [VV], [V], SDD ),
    SDD =.. [_|SRest],
    append(Hyps, [VV:Cond], NHyps),
    extend_hyps_with_cond( SRest, AVars, NHyps, EHyps ).
extend_hyps_with_cond( [Cond|Rest], AVars, Hyps, EHyps ) :-
    append(Hyps, AVars, Context),
    hfree([V], Context),
    append(Hyps, [V:Cond], NHyps),
    extend_hyps_with_cond( Rest, AVars, NHyps, EHyps ).
extend_hyps_with_cond( [], _, H, H ).

smallest( BigT, S_Ts ) :-
    select( S-T, S_Ts, RestS_Ts ),
    \+ ( member( S1-_, RestS_Ts ), S > S1 ),
    !,
    ( T= BigT ; smallest( BigT, RestS_Ts ) ).






