(****************************************************************************)
(*                                                                          *)
(*            Copyright 1993, 1994, 1996 University of Cambridge            *)
(*                                                                          *)
(*                           All rights reserved.                           *)
(*                                                                          *)
(****************************************************************************)

(****************************************************************************)
(* FILE          : ppboxes.sig                                              *)
(* DESCRIPTION   : Signatures for pretty-printing boxes.                    *)
(*                                                                          *)
(* AUTHOR        : R.J.Boulton                                              *)
(* DATE          : 7th December 1993                                        *)
(*                                                                          *)
(* LAST MODIFIED : R.J.Boulton                                              *)
(* DATE          : 1st July 1996                                            *)
(****************************************************************************)

signature PPSTREAM =
sig
   type ppstream
   val mk_ppstream : {consumer:string->unit,flush:unit->unit,linewidth:int} ->
                     ppstream
   val dest_ppstream : ppstream ->
                       {consumer:string->unit,flush:unit->unit,linewidth:int}
   val clear_ppstream : ppstream -> unit
   val flush_ppstream : ppstream -> unit
end;

signature PPBOXES =
sig
   structure PPStream : PPSTREAM
   structure Scale   : sig
                          val char_size : int
                          val num_of_chars : int -> int
                       end
   type ppbox
   datatype ppindent = ABSOLUTE of int | RELATIVE of int
   val pp_empty_box  : ppbox
   val pp_string_box : string * int -> ppbox
   val pp_h_box      : int -> ppbox list -> ppbox
   val pp_v_box      : ppindent * int -> ppbox list -> ppbox
   val pp_hv_box     : int * ppindent * int -> ppbox list -> ppbox
   val pp_hov_box    : int * ppindent * int -> ppbox list -> ppbox
   val pp_h_sepbox   : ppbox -> (int * ppbox) list -> ppbox
   val pp_v_sepbox   : ppbox -> ((ppindent * int) * ppbox) list -> ppbox
   val pp_hv_sepbox  : ppbox -> ((int * ppindent * int) * ppbox) list -> ppbox
   val pp_hov_sepbox : ppbox -> ((int * ppindent * int) * ppbox) list -> ppbox
   val write_ppbox   : ppbox -> PPStream.ppstream -> unit
end;

signature LABEL_PPBOXES =
sig
   structure PPStream : PPSTREAM
   structure Scale   : sig
                          val char_size : int
                          val num_of_chars : int -> int
                       end
   type 'a ppbox
   datatype ppindent = ABSOLUTE of int | RELATIVE of int
   val pp_empty_box  : 'a ppbox
   val pp_string_box : 'a -> string * int -> 'a ppbox
   val pp_h_box      : 'a -> int -> 'a ppbox list -> 'a ppbox
   val pp_v_box      : 'a -> ppindent * int -> 'a ppbox list -> 'a ppbox
   val pp_hv_box     : 'a -> int * ppindent * int -> 'a ppbox list -> 'a ppbox
   val pp_hov_box    : 'a -> int * ppindent * int -> 'a ppbox list -> 'a ppbox
   val pp_h_sepbox   : 'a -> 'a ppbox -> (int * 'a ppbox) list -> 'a ppbox
   val pp_v_sepbox   : 'a -> 'a ppbox ->
                       ((ppindent * int) * 'a ppbox) list -> 'a ppbox
   val pp_hv_sepbox  : 'a -> 'a ppbox ->
                       ((int * ppindent * int) * 'a ppbox) list -> 'a ppbox
   val pp_hov_sepbox : 'a -> 'a ppbox ->
                       ((int * ppindent * int) * 'a ppbox) list -> 'a ppbox
   val write_ppbox   : 'a ppbox -> PPStream.ppstream -> unit
   type 'a text
   val commit_ppbox  : int -> 'a ppbox -> 'a text
   val write_text    : 'a text -> PPStream.ppstream -> unit
   val width_of_text : 'a text -> int
   val is_in_text    : int * int -> 'a text * int * int -> bool
   exception Label_at
   val label_at      : int * int -> 'a text -> 'a
   val all_labels    : 'a text * int * int ->
                       ((int * int) * (int * int) * 'a) list
   val leaf_nodes_p  : 'a text * int * int ->
                       (string * (int * int) * (int * int) * 'a) list
   val leaf_nodes_c  : 'a text * int * int -> (string * (int * int) * 'a) list
end;
