structure ClamAST =
struct

datatype plan = Plan of goal * identifier * number * method * identifier
and method
   = External of argument * argument * external
   | Induction of argument * typ list * indterms list
   | Generalise of typ * typ
   | WeakFertilize of argument * argument * argument * identifier * typ
   | StrongFertilize of argument * identifier * typ
   | Disjunction of typ list
   | Hyp of identifier * typ
   | UseHypothesis of typ list
   | New of identifier list
   | Equ of typ * argument
   | MethodApp of identifier * argument list
   | Methods of method list
   | MethodThen of method * method
and indterms = InductionTerms of typ list
and argument
   = Method of method
   | Metavar of metavar
   | In
   | Connective of connective
   | NumList of number list
and external = Conjecture of typ list * typ | Thm of identifier
and goal = Goal of typ list * typ
and typ
   = Universe of number
   | Atom
   | Void
   | True
   | Pnat
   | Int
   | Number of number
   | Identifier of identifier
   | Metavariable of metavar
   | Apply of identifier * typ list
   | Lambda of typ * typ
   | List of typ
   | FunApp of typ * typ
   | Cons of typ * typ
   | Eq of typ * typ * typ
   | Inhabit of identifier * typ
   | Prop of typ * connective * typ
withtype connective = String.string
and identifier = String.string
and number = Int.int
and metavar = String.string;

end;
