start_clam {clam = "xterm -e clam-server"};

send_definition("ADD",definition "arithmetic" "ADD");
send_definition("MULT",definition "arithmetic" "MULT");
send_scheme("num_INDUCTION",theorem "num" "INDUCTION");

set_goal (dest_thm (theorem "arithmetic" "ADD_ASSOC"));  e CLAM_TAC;
set_goal (dest_thm (theorem "arithmetic" "ADD_SYM"));    e CLAM_TAC;
set_goal (dest_thm (theorem "arithmetic" "MULT_ASSOC")); e CLAM_TAC;
set_goal (dest_thm (theorem "arithmetic" "MULT_SYM"));   e CLAM_TAC;


send_definition("APPEND",definition "list" "APPEND");
send_definition("LENGTH",definition "list" "LENGTH");
send_definition("MAP",definition "list" "MAP");
send_scheme("list_INDUCTION",list_induct);

set_goal (dest_thm (theorem "list" "APPEND_ASSOC"));  e CLAM_TAC;
set_goal (dest_thm (theorem "list" "LENGTH_APPEND")); e CLAM_TAC;
set_goal (dest_thm (theorem "list" "MAP_APPEND"));    e CLAM_TAC;

fun Define s q = 
 new_recursive_definition{fixity=Prefix, name=s,
                          rec_axiom = theorem"list" "list_Axiom", 
                          def=Parse.term_parser q}
  handle _ => definition"-" s;

new_theory"foo" handle _ => ();

val rev_def = Define 
    "REV_DEF"
    `(REV [] = []) /\
     (REV (CONS h t) = APPEND (REV t) [h:'a])`;


val fast_rev_def = Define 
    "FREV_DEF"
    `(FREV [] A = (A:'a list)) /\
     (FREV (CONS h t) A = FREV t (CONS h A))`;

send_definition("REV",rev_def);
send_definition("FREV",fast_rev_def);


(*---------------------------------------------------------------------------
 * The order that the following 4 are taken in is interesting. Suppose we
 * really want to prove (3). We can prove it if we can prove (2) and then 
 * use  (0). Clam fails to find a plan for (2), but it can find one for (1),
 * which is a generalization of (2). Is there a way to automate this 
 * generalization? It seems non-trivial.
 * 
 * Anyways, (2) and (3) fail to be planned.
 *---------------------------------------------------------------------------*)
(*0*)
set_goal ([],Parse.term_parser`!L:'a list. REV(REV L) = L`); e CLAM_TAC;
(*1*)
set_goal
   ([],Parse.term_parser`!l1 l2:'a list. FREV l1 l2 = APPEND(REV l1) l2`);
e CLAM_TAC;
(*2*)
set_goal ([],Parse.term_parser`!l:'a list. FREV l [] = REV l`);  e CLAM_TAC;
(*3*)
set_goal ([],Parse.term_parser`!l:'a list. FREV(FREV l []) [] = l`);
e CLAM_TAC;

end_clam ();
