open Portable;

structure Tokens = Tokens;

type pos = Int.int;
type svalue = Tokens.svalue;
type ('a,'b) token = ('a,'b) Tokens.token;
type lexresult = (svalue,pos) token;
type arg = string;

val eof = fn _ => Tokens.EOF (0,0);
fun error (text,(file,(first:pos,last:pos))) =
   let val f = string_of_int first
       and l = string_of_int last
       val prefix = if (file = "") then "Line" else file ^ ", line"
       val location =
          if (first = 0)
          then ""
          else if (first = last)
               then (prefix ^ " " ^ f ^ ": ")
               else (prefix ^ "s " ^ f ^ "-" ^ l ^ ": ")
   in  TextIO.output (TextIO.stdOut,location ^ text ^ "\n")
   end;
fun lex_error (text,file,pos) = error (text,(file,(pos,pos)));
val linenum = ref 1;
val quotelevel = ref 0;
val quote = ref "";
val quotelineno = ref 0;

fun keyword "external" = Tokens.EXTERNAL
  | keyword "induction" = Tokens.INDUCTION
  | keyword "generalise" = Tokens.GENERALISE
  | keyword "disjunction" = Tokens.DISJUNCTION
  | keyword "hyp" = Tokens.HYP
  | keyword "new" = Tokens.NEW
  | keyword "equ" = Tokens.EQU
  | keyword "then" = Tokens.THEN
  | keyword "in" = Tokens.IN
  | keyword "conjecture" = Tokens.CONJECTURE
  | keyword "thm" = Tokens.THM
  | keyword "atom" = Tokens.ATOM
  | keyword "void" = Tokens.VOID
  | keyword "pnat" = Tokens.PNAT
  | keyword "int" = Tokens.INT
  | keyword "lambda" = Tokens.LAMBDA
  | keyword "list" = Tokens.LIST
  | keyword "of" = Tokens.OF
  | keyword _ = raise Fail "keyword";

fun is_special s =
   let fun sub sin = substring sin handle Substring => ""
       val s2 = sub (s,0,2)
       and s10 = sub (s,0,10)
       and s1 = sub (s,0,1)
       and s14 = sub (s,0,14)
       and s16 = sub (s,0,16)
       and s3 = sub (s,0,3)
       and s6 = sub (s,0,6)
   in s2 = "/*" orelse s2 = "*/" orelse s2 = "u(" orelse s2 = "::" orelse
      s2 = "=>" orelse s10 = "proof_plan" orelse
      (s1 = "(" orelse s1 = "," orelse s1 = ")" orelse s1 = "." orelse
       s1 = "-" orelse s1 = "[" orelse s1 = "]" orelse s1 = "=" orelse
       s1 = ":" orelse s1 = "#" orelse s1 = "\\") orelse
      (s14 = "weak_fertilize" orelse s14 = "use_hypotheses") orelse
      s16 = "strong_fertilize" orelse (s3 = "==>" orelse s3 = "<=>") orelse
      s6 = "{true}"
   end;

%%

%s COMMENT1;
%reject
%header (functor ClamLexFun (structure Tokens : Clam_TOKENS));
%arg (s'file);
identifier = [a-z][a-zA-Z0-9_]*;
number = [0-9]+;
metavar = _[0-9]+;

%%

<INITIAL>([\ \t]|"\012")+ => (continue ());
<INITIAL>\n => (inc linenum; continue ());
<INITIAL>"/*" =>
   (YYBEGIN COMMENT1;
    quotelevel := 1;
    quote := "";
    quotelineno := ! linenum;
    continue ());
<INITIAL>"*/" =>
   (lex_error ("unmatched close comment",s'file,! linenum); continue ());
<INITIAL>[A-Za-z]+ =>
   (keyword yytext (! linenum,! linenum) handle _ => REJECT ());
<INITIAL>"proof_plan" => (Tokens.PROOFUNDERPLAN (! linenum,! linenum));
<INITIAL>"(" => (Tokens.LPAREN (! linenum,! linenum));
<INITIAL>"," => (Tokens.COMMA (! linenum,! linenum));
<INITIAL>")" => (Tokens.RPAREN (! linenum,! linenum));
<INITIAL>"." => (Tokens.DOT (! linenum,! linenum));
<INITIAL>"-" => (Tokens.MINUS (! linenum,! linenum));
<INITIAL>"[" => (Tokens.LBRACKET (! linenum,! linenum));
<INITIAL>"]" => (Tokens.RBRACKET (! linenum,! linenum));
<INITIAL>"weak_fertilize" =>
   (Tokens.WEAKUNDERFERTILIZE (! linenum,! linenum));
<INITIAL>"strong_fertilize" =>
   (Tokens.STRONGUNDERFERTILIZE (! linenum,! linenum));
<INITIAL>"use_hypotheses" =>
   (Tokens.USEUNDERHYPOTHESES (! linenum,! linenum));
<INITIAL>"==>" => (Tokens.EQ2GREAT (! linenum,! linenum));
<INITIAL>"u(" => (Tokens.ULPAREN (! linenum,! linenum));
<INITIAL>"{true}" => (Tokens.LBRACETRUERBRACE (! linenum,! linenum));
<INITIAL>"::" => (Tokens.COLON2 (! linenum,! linenum));
<INITIAL>"=" => (Tokens.EQ (! linenum,! linenum));
<INITIAL>":" => (Tokens.COLON (! linenum,! linenum));
<INITIAL>"<=>" => (Tokens.LESSTEQGREAT (! linenum,! linenum));
<INITIAL>"=>" => (Tokens.EQGREAT (! linenum,! linenum));
<INITIAL>"#" => (Tokens.SHARP (! linenum,! linenum));
<INITIAL>"\\" => (Tokens.BSLASH (! linenum,! linenum));
<INITIAL>{metavar} =>
   (if is_special yytext
    then REJECT ()
    else Tokens.METAVAR (yytext,! linenum,! linenum));
<INITIAL>{number} =>
   (if is_special yytext
    then REJECT ()
    else Tokens.NUMBER
            (LexSupport.integer_of_string yytext,! linenum,! linenum));
<INITIAL>{identifier} =>
   (if is_special yytext
    then REJECT ()
    else Tokens.IDENTIFIER (yytext,! linenum,! linenum));
<INITIAL>. =>
   (lex_error ("ignoring bad character " ^ yytext,s'file,! linenum);
    continue ());
<COMMENT1>"*/" => (YYBEGIN INITIAL; continue ());
<COMMENT1>\n => (continue ());
<COMMENT1>. => (continue ());
