signature Fact_sig =
sig

  type pprinter = PrettyPrint.ppstream -> unit;

  datatype fact = Proved  of thm * pprinter
              | CantProve of term
              | Refuted   of term
              (* | Simplified of thm;*)

  val clear : unit -> unit
  val add   : string * fact -> unit
  val get   : string -> (string * fact) option
  val elts  : unit -> (string * fact) list

  datatype 'a age = NEW of 'a | OLD of 'a
  val dest_age : 'a age -> 'a

end
