/*
 * @(#)$Id: library.pl,v 1.42.2.1 1998/08/21 11:47:52 rjb Exp $
 *
 * $Log: library.pl,v $
 * Revision 1.42.2.1  1998/08/21 11:47:52  rjb
 * Support for user-defined transitivity relations.
 *
 * Revision 1.42  1997/11/14 16:28:30  img
 * *** empty log message ***
 *
 * Revision 1.41  1997/11/14 12:23:56  img
 * reorded clauses in lib_save and lib_load
 *
 * Revision 1.40  1997/11/14 12:21:24  img
 * reorded clauses in lib_save and lib_load
 *
 * Revision 1.39  1997/11/11 17:25:17  img
 * typo
 *
 * Revision 1.38  1997/11/08 12:27:22  img
 * cosmetic changes
 *
 * Revision 1.36  1997/10/09 17:02:15  img
 * lib_fname_exists/3: added lib_fname/2
 *
 * Revision 1.35  1997/09/26 15:05:05  img
 * general bug fixes; lib_load(scheme) calls add_induction_scheme/1
 *
 * Revision 1.34  1997/07/09 15:29:31  img
 * Alter format of registry in trs object for inequalities.  Extend
 * uniq_recorda for scheme objects (incomplete).
 *
 * Revision 1.33  1997/06/17 14:40:39  img
 * Pass registry explicitly.
 *
 * Revision 1.32  1997/06/05 10:47:56  img
 * uniq_recorda: added clause for schemes; lib_present: eqn's are present
 * if rewrite rules are present; lib_delete: don't require presence of
 * def when trying to remove eqn's.
 *
 * Revision 1.31  1997/04/07 11:46:07  img
 * Improve user interface on lib_set/1.
 *
 * Revision 1.30  1997/01/14 10:45:20  img
 * Generalized conditional for multifile declaration.
 *
 * Revision 1.29  1996/12/17 18:45:54  img
 * typo.
 *
 * Revision 1.28  1996/12/12 13:25:11  img
 * Typo.
 *
 * Revision 1.27  1996/12/12 12:41:58  img
 * Error message stuff.
 *
 * Revision 1.26  1996/12/06 14:36:54  img
 * lib_save(plan(.)) added.  Timing info added to proof-plan object.
 *
 * Revision 1.25  1996/12/04 12:49:16  img
 * Check that a rewrite rule is added if one was called for.  proof_plan
 * object has extra argument for CPU time. Don't fail if there are no
 * eqn's to save when saving a def. Don't attempt to save individual
 * equations---need more effort here. lib_fname_exists/3: new clause to
 * deal with '*'.
 *
 * Revision 1.24  1996/07/09 15:00:10  img
 * lib_save(thm(.)): give oyster_version/1 and the statement of the
 * conjecture in the plan object written to the library.
 *
 * Revision 1.23  1996/07/05  10:23:54  img
 * Alert user when a theorem is loaded which is not "complete".
 *
 * Revision 1.22  1996/06/18  17:21:11  img
 * lib_save(eqn()): allow numbered equations to be saved.  Cosmetic
 * changes.
 *
 * Revision 1.21  1996/06/12  12:47:38  img
 * singletons are sometimes called valerie
 *
 * Revision 1.20  1996/06/11  16:44:01  img
 * moved much of the reduction rule stuff to add_rule/_; changes to the
 * library mechanism to deal with trs library objects and reduction rules
 * in uniq_recorda/_
 *
 * Revision 1.19  1996/05/24  10:01:10  img
 * Preliminary support for trs logical object: to load and save rewriting
 * systems.  lib_delete: fewer cases are mapped into delete(anythm).
 * special clauses for wave, red and plan allow the user to remove a wave
 * rule without removing (say) associated reduction rules.  All eqn's are
 * stored as reduction rules: hence, there are no func_defeqn anymore.
 * Things loaded as wave are not added as red.  Labelled term rewriting
 * support.
 *
 * Revision 1.18  1995/11/28  16:17:38  img
 * delete complementary sets when theorem on which they are based is deleted
 *
 * Revision 1.17  1995/10/24  14:53:06  img
 * removed old parsing code
 *
 * Revision 1.16  1995/10/18  12:14:29  img
 * lib_load(eqn...) extended to allow individual equations to be added
 *
 * Revision 1.15  1995/10/03  13:10:14  img
 * logical object "plan" added;  lib_save(plan(.)) added;  uniq_recorda
 * added;  library search  path added;  complementary sets recorded at
 * load-time.
 *
 * Revision 1.14  1995/07/31  12:05:07  img
 * uniq_recorda no longer tries to delete rewrite records, since it
 * cannot do so reliably;  use lib_present not Oyster
 *
 * Revision 1.13  1995/07/19  14:23:10  img
 * lib_error gives brief documentation (via logical_object/3);  deletion
 * of definitions debugged.
 *
 * Revision 1.12  1995/07/19  11:18:06  img
 * added lib-create/[1;2];  fixed bugs in lib-save(def(O))
 *
 * Revision 1.11  1995/07/18  18:15:32  img
 * eqns are no longer parsed as wave-rules
 *
 * Revision 1.10  1995/07/17  15:48:31  img
 * Removed fixed limit of 20 equations in lib_load and lib_save eqn(D).
 * Now loads and saves as many as can be found _provided_ they are
 * consecutively numbered.
 *
 * Revision 1.9  1995/05/17  02:18:58  img
 * 	* Conditional multifile declaration (for Quintus).
 *
 * Revision 1.8  1995/03/01  04:15:22  img
 * 	* Added file_version/1 and associated multifile declaration
 *
 * Revision 1.7  1995/03/01  03:47:01  img
 * 	* Redundant call to add_recursive_clause/1 removed;
 * 	  lib_delete adjusted
 *
 * Revision 1.6  1995/02/14  03:16:01  img
 * 	* deleted redundant add_complementary_eqns
 *
 * Revision 1.5  1995/02/14  02:51:56  img
 * 	* stuff to do with gazing removed
 *
 * Revision 1.4  1994/09/22  10:12:21  dream
 * 	* removed spurious tryto in add_wave_rules_list
 * 	* undid some of the previous changes (re. rewrite rule
 * 	  database) and moved them to wave_rules.pl
 *
 * Revision 1.3  1994/09/22  00:13:52  dream
 * 	* added recorda record for the new class of things "rewrite" these
 * 	  are all the theorems which can be used as wave-rules by the
 * 	  dynamic wave-rule parser (cf. wave_rules.pl)
 *
 * Revision 1.2  1994/09/16  10:53:41  dream
 * 	* made singleton variables anonymous; removed some dead code
 *
 * Revision 1.1  1994/09/16  09:19:36  dream
 * Initial revision
 *
 */

?-if(multifile_needed). ?-multifile file_version/1. ?-endif.
file_version('$Id: library.pl,v 1.42.2.1 1998/08/21 11:47:52 rjb Exp $').

/*
 * This file contains a primitive library mechanism which can be used to
 * keep track of dependencies between logical objects such as
 * definitions, theorems, lemma's etc.
 *
 * Main predicates defined in this file are
 *      lib_load/[1;2;3]
 *      lib_save/[1;2]
 *      lib_delete/1
 *      lib_present/1
 *      lib_edit/[1;2]
 *      lib_set/1
 *      lib_tidy/0
 *      needed/2
 */


        % lib_load(+Thing) will load object Thing, plus all other
        % objects needed by Thing which are not already loaded. 
        % 
        % Thing can be:
        % - mthd(M): M is of the form F/A and specifies a method with
        %   functor F of arity A. 
        % - smthd(M): M is of the form F/A and specifies a submethod with
        %   functor F of arity A. 
        % 
logical_object(thm(T),'%t is a theorem',[T]).
logical_object(lemma(T),
	'%t is a lemma which is only needed for technical
        reasons, and is not interesting as a thm in its own right.
        Thus, if %t is both an interesting theorem in its own right
        but can also be used as a lemma, it is a thm, not a lemma.
        Consequently the only things that should be lemmas are thms
        needed for "technical" reasons (ie to beef up arithmetic or so).',[T,T]).
logical_object(wave(T),
	       '%t is a thm, but is needed in its role as a wave rule',[T]).
logical_object(synth(T),
	       '%t is a theorem only used to synthesise a particular
        function.  In this sense, synths are close to def''s.',[T]).

logical_object(scheme(T),
	       '%t is an induction scheme.',[T]).
logical_object(def(T),'%t is a definition.  Loading def(%t) will also result
        in loading all consecutively numbered eqn''s of the form Dn, with
        n=1... These are expected to be the recursion equations for %t.',[T,T,T]).
logical_object(eqn(T),'%t is a theorem, used as a recursion equation for def(%t).',
	       [T,T]).
logical_object(red(T),'%t is a reduction rule.',[T]).
logical_object(trans(T),'%t is a transitivity rule.',[T]).
logical_object(mthd(M/A),'Specifies a method with functor %t of arity %t.',
	       [M,A]).
logical_object(smthd(M/A),'Specifies a submethod with functor %t of arity %t.',
	       [M,A]).
logical_object(hint(M/A),'Specifies a hint with functor %t of arity %t.',
	       [M,A]).
logical_object(plan(T),'Specifies a proof-plan of theorem %t.',
	       [T]).
logical_object(trs(T),'Specifies a TRS labelled %t.',
	       [T]).

/* The corresponding files are expected to be in directories thm,
 * lemma, synth, scheme, def, mthd and smthd.  Apart from loading the
 * Oyster representation of theorems, defs, etc., we maintain our own
 * storage mechanism which is partly much more efficient than Oysters
 * and partly so that we can cache often re-computed results.  This is
 * all done in the recorded database under the keys rewrite, wave,
 * theorem and reduction. 
 *
 * Dependancies between objects are expected to stored in needs/2
 * clauses such as
 *   needs(thm(assm), [def(times)]).
 *   needs(def(times),[def(plus)]).
 * 
 * The real work is done by lib_load/2, which as a second argument
 * takes the directory path from which the stuff is to be loaded.  If
 * not given it defaults to the value specified by lib_dir/1.  For
 * methods, the arguments are slightly different: second argument is
 * position-in-database (one of {first,last,before(_),after(_)}) or
 * mthd-file to read methods from.  Both arguments can also be given
 * via lib_load/3.  The real work for (sub)methods is done by
 * load_mthd in method-db.pl.  */

/* load lists of things */
lib_load([]) :- !.
lib_load([H|T]):- !, lib_load(H),lib_load(T).

lib_load(mthd(M/A))  :- !, load_method(M/A).
lib_load(smthd(M/A)) :- !, load_submethod(M/A).
lib_load(hint(M/A)) :- !, load_hint(M/A).
lib_load(Thm) :- lib_dir(LibDir), lib_load(Thm,LibDir).

lib_load([],_):- !.
lib_load([H|T],Arg2) :- !, lib_load(H,Arg2), lib_load(T,Arg2).
lib_load(Thing,_) :-
    Thing =.. [_,[]],
    !.
lib_load(Thing,Path) :-
    Thing =.. [Type,[O|Os]],!,
    OneThing =.. [Type,O],
    lib_load(OneThing,Path),
    RestThing =.. [Type,Os],
    lib_load(RestThing,Path).

lib_load(mthd(M/A),Arg2) :- !, load_method(M/A,Arg2).
lib_load(smthd(M/A),Arg2) :- !, load_submethod(M/A,Arg2).
lib_load(hint(M/A),Arg2) :- !, load_hint(M/A,Arg2).
%lib_load(rtype(N),Arg2) :- !,load_rectype(N,Arg2).
lib_load(synth(T),Dir) :- !, lib_load(anythm(T,synth),Dir).
lib_load(lemma(T),Dir) :- !, lib_load(anythm(T,lemma),Dir).
lib_load(thm(T),Dir)   :- !, lib_load(anythm(T,thm),Dir).
lib_load(scheme(T),Dir):- !,
    lib_load(anythm(T,scheme),Dir),
    add_induction_scheme(T).

lib_load(plan(T),Path) :- !,
    (lib_fname_exists(Path,_Dir,T,plan,File) ->true;
     clam_user_error('There is no plan(%t) in the library path: %t\n',
		     [T,Path]),fail),
    (lib_present(thm(T)) -> true;
     clam_user_error('Please load thm(%t) before loading the plan.',[T]),fail),
    readfile(File,proof_plan(H==>G,T,TimeTaken,P,Planner)),
    uniq_recorda(proof_plan,proof_plan(H==>G,T,TimeTaken,P,Planner),_),
    writef('Loaded plan(%t)\n', [T]).


/* EXPERIMENTAL: load a known terminating rewrite system.  There can
   only be one such system loaded at a given time.  */
lib_load(trs(TRS),Path) :- !,
    TRS = default,
    write('lib_load(trs(.)) is not yet implemented.'),nl,fail,
    (lib_fname_exists(Path,_Dir,TRS,trs,_File) -> true;
     clam_user_error('There is no trs(%t) in the library path: %t\n',
		     [TRS,Path]),fail),
    writef('Loaded trs(%t)\n',[TRS]),
    %% read_from_file(File,Term),
    %% record Term in the database
    true.

lib_load(def(D),Path) :-
   \+ is_list(D),!,
    needs(def(D),Needed),
    forall {Need \ Needed}: (lib_present(Need) orelse lib_load(Need,Path)),!,
    (lib_fname_exists(Path, Dir,D,'synth', _)
      -> lib_load(synth(D),[Dir])
      ;  true),
    (lib_fname_exists( Path, _, D,'def',File) -> true;
     clam_user_error('There is no def(%t) in the library path: %t\n',
		     [D,Path]),fail),
    create_def(File),!,
    lib_load(eqn(D),Path),			% load any recursion equations
    writef('Loaded def(%t)\n',[D]).


        % LOADING EQNs
        % Find out if there are any recursion equations for definition D
        % and call lib_load(anythm(..,eqn)) for each of them. Also, try
        % installing the wave/5 record for those equations to which
        % that applies.
lib_load(eqn(D),Path) :- !,
    %% It is useful to allow individual equations to be loaded, by
    %% giving the full equation name, including the number: plus2 for
    %% example.  
    atom_chars(D,Dname),
    atom_chars('1',[OneCode]),atom_chars('9',[NineCode]), %could be compiled in
    %% find the last code
    append(_,[LastCode],Dname),
    ((LastCode < OneCode; LastCode > NineCode) ->
     lib_load_aux(D,Path,_Dir,DRootList,1)
      ;
     (lib_load(anythm(D,eqn),Path), 
      DRootList = [D])),
    add_rewrite_rules_list(DRootList),
    add_complementary_sets(DRootList),
    add_reduction_rules(DRootList).
    
lib_load(eqn(_),_) :- !.
        % LOADING WAVEs
        % Firstly deal with the case where condition sets are
        % specified by the user using the wave([r1,..,rn]) notation.
lib_load(wave(Tlist),Dir) :-
    is_list(Tlist),!,
    lib_load_list(thm(Tlist),Dir),
    add_rewrite_rules_list(Tlist),
    add_complementary_sets(Tlist).

        % Secondly deal with the case where a single wave rule
        % is supplied.
lib_load(wave(T),Dir) :- !,
    lib_load(thm(T),Dir),
    add_rewrite_rules_list([T]),
    add_cancel_rule(T).


/* Loading reduction rules: First load T as a thm and then add the
   reduction rule.  */
lib_load(red([]),_Dir).
lib_load(red([T|Ts]),Dir) :-
    lib_load(red(T),Dir),
    lib_load(red(Ts),Dir).
lib_load(red(T),Dir) :-
    !,
    lib_load(thm(T),Dir),
    add_reduction_rules([T]).

/* Loading transitivity rules: First load T as a thm and then add the
   transitivity rule.  */
lib_load(trans([]),_Dir).
lib_load(trans([T|Ts]),Dir) :-
    lib_load(trans(T),Dir),
    lib_load(trans(Ts),Dir).
lib_load(trans(T),Dir) :-
    !,
    lib_load(thm(T),Dir),
    add_transitivity_rule(T).

/* LOADING THMs 
 * Deals with synth, lemma, thm, scheme and eqn.  Load thing from file
 * and store the theorem/4 record which we use as our own theorem
 * represention (in preference to Oyster's representations).
 *
 * If Thm is a list of things, load each of them, in the same way.
 */
lib_load(anythm(ThmList,Type),Path) :-
    is_list(ThmList),!,
    map_list(ThmList, Thm :=> nothing, 
	     (lib_load(anythm(Thm,Type),Path)->true;
	      writef('Clam warning: failed to load %t(%t)\n',[Type,Thm])),_),
    !.
lib_load(anythm(Thm,Type),Path) :- !,
    TypeThm =.. [Type,Thm],
    needs(TypeThm,Needed),
    forall {Need \ Needed}: (lib_present(Need) orelse lib_load(Need,Path)),!,
    (lib_fname_exists(Path,_Dir,Thm,Type,File) -> true;
     clam_user_error('There is no %t(%t) in the library path: %t\n',
		     [Type,Thm,Path]),fail),
    load_thm(Thm,File,Status),
    record_thm( Thm, Type ),
    writef('Loaded %t(%t)\n',[Type,Thm]),
    if(\+ Status == complete,
     clam_warning('Theorem %t has status %t\n',[Thm,Status])).

        % report error in case of failure.
lib_load(T,_) :- lib_error(T).

/* Load as many _consecutively_ indexed equations as can be found
 * There is a choice as to whether all equations should be loaded from
 * the same directory (i.e., disregarding other directories in the
 * Path.  For the moment, I choose the least liberal, that is, looking
 * for the first equation in the Path and then loading all subsequent
 * eqns from that same directory.  */
lib_load_aux(D,Path,Dir,[Root|DRootList], N) :-
    var(Dir),					%still to find an eqn
    concat_atom([D,N],Root),
    lib_fname_exists(Path,Dir,Root,'eqn',_),!,
    lib_load(anythm(Root,eqn),[Dir]),
    M is N + 1,
    lib_load_aux(D,Path,Dir,DRootList, M).
lib_load_aux(D,Path,Dir,[Root|DRootList], N) :-
    \+var(Dir),					% continue with the
						% same Dir
    concat_atom([D,N],Root),
    lib_fname_exists([Dir],_,Root,'eqn',_),!,
    lib_load(anythm(Root,eqn),[Dir]),		%force same Dir
    M is N + 1,
    lib_load_aux(D,Path,Dir,DRootList, M).
lib_load_aux(_D,_Path,_Dir,[], _M) :- !.
 
        % CODE for lib_load/3 only useful for methods:
lib_load([],_,_).
lib_load([H|T],Where,File) :- lib_load(H,Where,File), lib_load(T,Where,File).
lib_load(mthd(M),Where,File)  :- !, load_method(M,Where,File).
lib_load(smthd(M),Where,File) :- !, load_submethod(M,Where,File).
lib_load(hint(M),Where,File) :- !, load_hint(M,Where,File).
lib_load(T,_,_) :- lib_error(T).

record_thm( Thm, Type ) :-
    % Oyster dependent:!
    ctheorem(Thm)=:problem(_==>Goal,_,_,_),
    (Type=eqn
     ->( name(Thm,NameNum),
         append(NameL,[_Num],NameNum),
         name(Name,NameL)
       )
     ; 
     Name=Thm
    ),
    uniq_recorda(theorem,theorem(Name,Type,Goal,Thm),_),
    !.

lib_load_list(thm([]),_).
lib_load_list(thm([H|T]),Dir) :-
    lib_load(thm(H),Dir),
    lib_load_list(thm(T),Dir).
add_rewrite_rules_list([]).
add_rewrite_rules_list([H|T] ) :-
    add_rewrite_rules(H),
    if(\+ rewrite_rule(_,_,_,_,H,_),
       clam_warning('No rewrite/wave rules were derived from %t.\n',[H])),
    add_rewrite_rules_list(T).

/* pre-compute complementary set information for groups of
 * wave-rules/equations as they are loaded, and store them in the
 * recorded database.  One expects methods to access complementary
 * sets via this pre-computed form, rather than via
 * complementary_set/1 or complementary_sets/1 because it will be
 * faster; however, note that computing the set dynamically is more
 * powerful since the entire database is used when finding
 * complementary rewrites.  */
add_complementary_sets(Thms) :-
    complementary_set(Thms,CS),
    uniq_recorda(comp_set,comp_set(Thms,CS),_),
    writef('Added complementary set record for %t\n', [Thms]),
    !.
add_complementary_sets(_).

lib_tidy :-
    recorded(comp_set,_,R),
    erase(R),
    fail.
lib_tidy.

        % lib_save(Thing, Dir) saves Thing in directory Dir in files
        % with the appropriate suffix.
        %
        % lib_save(Thing) is as lib_save/2, with Dir defaulting to the
        % current dir:
/* load lists of things */
lib_save([]) :- !.
lib_save([H|T]):- !, lib_save(H),lib_save(T).

lib_save(Thing) :- lib_sdir(D),lib_save(Thing, D).
lib_save([],_):- !.
lib_save([H|T],Arg2) :- !, lib_save(H,Arg2), lib_save(T,Arg2).
lib_save(Thing,_) :-
    Thing =.. [_,[]],
    !.
lib_save(Thing,Path) :-
    Thing =.. [Type,[O|Os]],!,
    OneThing =.. [Type,O],
    lib_save(OneThing,Path),
    RestThing =.. [Type,Os],
    lib_save(RestThing,Path).

lib_save(thm(T), Dir) :- !, lib_save(anythm(T,thm),Dir).
lib_save(lemma(T), Dir) :- !, lib_save(anythm(T,lemma),Dir).
lib_save(scheme(T), Dir) :- !, lib_save(anythm(T,scheme),Dir).
lib_save(synth(T), Dir) :- !, lib_save(anythm(T,synth),Dir).
lib_save(wave(T), Dir) :- !, lib_save(anythm(T,thm),Dir).
lib_save(red(T,_), Dir) :- !, lib_save(anythm(T,thm),Dir).
lib_save(trans(T,_), Dir) :- !, lib_save(anythm(T,thm),Dir).

/* EXPERIMENTAL: save a known terminating rewrite system.  There can
   only be one such system loaded at a given time.  */
lib_save(trs(TRS),Dir) :- !,
    TRS = default,
    write('lib_save(trs(.)) is not yet implemented.'),nl,fail,
    lib_fname_exists(_Path,Dir,TRS,trs,_File),
    writef('Saved trs(%t)\n',[TRS]),
    %% read_from_file(File,Term),
    %% record Term in the database
    true.

lib_save(plan(T),Dir) :-
    recorded(proof_plan,proof_plan(H==>G,T,TimeTaken,P,Planner),_),!,
    lib_fname(Dir,T,'plan',File),
    clam_version(CV),
    oyster_version(OV),
    (tell(File) -> true;
     (clam_user_error('Unable to save plan(%t) to %t\n',[T,File]),fail)),
    write('/*  This is a proof plan for theorem:'),nl,
    writef('    %t: %t\n',[T,H==>G]),
    writef('    planner = %t, clam_version(%t), oyster_version(%t)\n',[Planner,CV,OV]),
    writef('\n    Time taken to find plan: %tms\n    Environment:\n',[TimeTaken]),
    findall(X,(lib_present(X), \+ X=plan(_)),Xs),
    prlist(Xs),
    writef(' */\n'),
    nl,
    %% and it is nice to see the pretty-printed one there too
    writef('/* This is the pretty-printed form\n'),
    print_plan(P),nl,
    writef('*/\n'),
    nl,
    writeq(proof_plan(H==>G,T,TimeTaken,P,Planner)),write('.'),nl,
    told,
    writef('Saved currently stored plan for %t\n',[T]).

lib_save(plan(T),_Dir) :-
    writef('There is no proof-plan for theorem %t currently stored.\n',[T]),!.

        % lib_save anythm in appropriate file
lib_save(anythm(T,Type),Dir) :- !,
    lib_fname(Dir,T,Type,File),
    (save_thm(T,File) -> true;
     (clam_user_error('Unable to save %t(%t) to %t\n',[Type,T,Dir]),fail)),
    writef('Saved %t(%t)\n',[Type,T]).
        % For saving definitions we first save the def (easy), and then
        % save all the eqns for that def.
lib_save(def(D),Dir) :- !,
    definition(D/_<==>_),
    lib_fname(Dir,D,'def',File),
    (save_def(D,File)  -> true;
     (clam_user_error('Unable to save def(%t) to %t\n',[D,Dir]),fail)),
    writef('Saved def(%t)\n',[D]),
    ( lib_present( synth(D) ) -> lib_save( synth(D), Dir ) ; true ),
    tryto lib_save(eqn(D),Dir).			% there may be some equations

lib_save(defeqn(D),Dir) :- !,
    lib_save(def(D),Dir),
    writef('Registering these definitions...'),nl,
    lib_load(def(D),Dir).

/* Pick up all thms that could be eqns for def(D), and save them. */
lib_save(eqn(D),Dir) :-
    lib_save_aux(D,Dir,1,Flag),
    Flag == saved,!.
/* The following is buggy; need to check that D really is an equation
lib_save(eqn(D),Dir) :-
    ctheorem(D) =: _,!,
    lib_save(anythm(D,eqn),Dir),!.
*/
lib_save(mthd(_),_)  :- !,writef('CLaM ERROR: Cannot save methods (yet)\n').
lib_save(smthd(_),_) :- !,writef('CLaM ERROR: Cannot save submethods (yet)\n').
lib_save(hint(_),_)  :- !,writef('CLaM ERROR: Cannot save hints (yet)\n').
lib_save(T,_) :- lib_error(T).

lib_save_aux(D,Dir,N,saved) :-
    (concat_atom([D,N], Eqn);
     concat_atom([D,'_d',N],Eqn)),
    ctheorem(Eqn) =: _,!,
    lib_save(anythm(Eqn,eqn),Dir),
    M is N + 1,
    lib_save_aux(D,Dir,M,_).

lib_save_aux(_D,_Dir,_N,_).

/* lib_present(?Object) succeeds if Object is present in the current
 * environment.  Can be used to test for presence, or to generate the
 * entire contents of the currently loaded library if you feel like
 * it.  The order of the clauses below is significant: Defs create
 * eqns and eqns create thms, so the order is def;eqn;thm. This is so
 * that lib_delete(_) can use this predicate to generate the library
 * in a decent order for deleting things.  */
/* load lists of things */
lib_present(def(T)) :- definition(T/_<==>_).
lib_present(eqn(T)) :-
    recorded(theorem,theorem(_,eqn,_,T),_);
    recorded(rewrite, rewrite(_L,_Ll,_R,_Rl,_C,_Dir,T),_).
lib_present(wave(T)) :-				% a wave-rule is a rewrite
    recorded(rewrite, rewrite(_L,_Ll,_R,_Rl,_C,_Dir,T),_).
lib_present(red(T)) :- recorded(reduction,reduction(_,_,_,_,_C,_D,T),_).
lib_present(trans(T)) :- recorded(transitivity,transitivity(_,T),_).
lib_present(trs(default)) :-
    once((recorded(registry,registry(positive,_Tau,_Prec),_);
	  recorded(registry,registry(negative,_Tau,_Prec),_))).
lib_present(cancel(T)) :- recorded(cancel,cancel(_,T:_),_).
lib_present(thm(T)) :- recorded(theorem,theorem(T,thm,_,_),_).
lib_present(lemma(T)) :- recorded(theorem,theorem(T,lemma,_,_),_).
lib_present(synth(T)) :- recorded(theorem,theorem(T,synth,_,_),_).
lib_present(scheme(T)) :- recorded(theorem,theorem(T,scheme,_,_),_).
lib_present(mthd(M)) :- list_methods(L), remove_dups(L,L1),member(M,L1).
lib_present(smthd(M)) :- list_submethods(L), remove_dups(L,L1),member(M,L1).
lib_present(hint(M)) :- list_hints(L), remove_dups(L,L1),member(M,L1).
lib_present(plan(T)) :- recorded(proof_plan,proof_plan(_,T,_,_,_),_).
lib_present(T) :-
    \+ var(T), T\==[], \+ functorp(T,.,2),\+ logical_object(T,_,_), lib_error(T).

        % lib_present prints out all objects currently in the library.
lib_present :- lib_present(O), write(O), nl, fail.
lib_present.

        % lib_delete(?Object) removes Object from the current
        % environment. Fails if Object is not present in the current
        % environment.
        % First clause makes that we can use mode lib_delete(_), which,
        % on backtracking, will delete the whole library.
lib_delete(Object) :- var(Object), !, lib_present(Object),lib_delete(Object).
lib_delete(Object) :-
    \+ var(Object),
    \+ functorp(Object,anythm,2), Object\==[], \+ functorp(Object,.,2),
    \+ logical_object(Object,_,_),
    !,lib_error(Object).
lib_delete(Object) :-
    logical_object(Object,_,_),
    \+ (Object=anythm(_,_); lib_present(Object)),
    writef('CLaM WARNING: %t not present, so cannot be deleted\n',[Object]),
    !,fail.
/* remove any existing registries, and make a fresh start with this
   base registry.  */

lib_delete(trs(default)) :-
    lib_present(trs(default)),
    if(lib_present(red(_)),lib_delete(red(_))),
    %% The default TRS is defined by two registries
    if(recorded(registry,registry(positive,_,_),Ref1), erase(Ref1)),
    if(recorded(registry,registry(negative,_,_),Ref2), erase(Ref2)),
    writef('Deleted trs(%t)\n',[default]).


lib_delete(thm(T)) :- lib_delete(anythm(T,thm)).
lib_delete(lemma(T)) :- lib_delete(anythm(T,lemma)).
lib_delete(wave(T)) :-
    findall(Ref,
            (recorded(rewrite,rewrite(_L,_Ll,_R,_Rl,_C,_D,T),Ref),
	     erase(Ref),
             writef('Deleted rewrite/wave record for %t\n',[T])
            ),_),
    findall(Ref,
            (recorded(cancel,cancel(_,T:_),Ref),
             erase(Ref),
             writef('Deleted cancel record for %t\n',[T])
            ),_).
lib_delete(eqn(T)) :- lib_present(eqn(T)), lib_delete(anythm(T,eqn)).
lib_delete(red(T)) :-
    findall(Ref,
            (recorded(reduction,reduction(_L,_Ll,_R,_Rl,_C,_D,T),Ref),
             erase(Ref), writef('Deleted reduction record for %t\n',[T])
            ),_),
    clam_info('Some rewrite rules have been removed from the TRS; However,\n',[]),
    clam_info('any possible weakenings of the registry have not been made.\n',[]).
lib_delete(trans(T)) :-
    findall(Ref,
            (recorded(transitivity,transitivity(Relation,T),Ref),
             erase(Ref),
             writef('Deleted transitivity record for %t\n',[T]),
             (% If no other records exist for this relation,
              % delete the relation itself.
              recorded(transitivity,transitivity(Relation,_),_);
              (retract(transitive(Relation)); true))
            ),_).
lib_delete(synth(T)) :-
    lib_present(synth(T)), 
    lib_delete(anythm(T,synth)).
lib_delete(scheme(T)) :-
    lib_present(scheme(T)),
    findall(_,(recorded(scheme,scheme(T,_,_),Ref),erase(Ref)),_),
    lib_delete(anythm(T,scheme)).
        % anythm case does most work: delete theorem-, rewrite and
        % delete thm itself.
lib_delete(plan(T)) :-
    findall(Ref,
            (recorded(proof_plan,proof_plan(_,T,_,_,_),Ref),
             erase(Ref),
	     writef('Deleted proof-plan record for %t\n',[T])
            ),_).
lib_delete(anythm(T,Type)) :-
    findall(Ref,
	    %% remove any complementary sets mentioning T
            (recorded(comp_set,comp_set(Thms,_CS),Ref),
	     member(T,Thms), erase(Ref),
             writef('Deleted complementary set record for %t\n',[Thms])
            ),_),
    if(lib_present(wave(T)),lib_delete(wave(T))),
    findall(Ref,
            (recorded(cancel,cancel(_,T:_),Ref),
             erase(Ref), writef('Deleted cancel record for %t\n',[T])
            ),_),
    if(lib_present(red(T)),lib_delete(red(T))),
    findall(Ref,
            (recorded(theorem,theorem(_,_,_,T),Ref),
             erase(Ref),
             writef('Deleted theorem record for %t\n',[T])
            ),_),
    ctheorem(T) := _ , writef('Deleted %t(%t)\n',[Type,T]).

        % For def's, for recursive definitions, we delete recursive
        % record, pick up all the equations and delete them, and finally
        % we delete def itself.  
lib_delete(def(D)) :-
    lib_delete_aux(D,1),
    if(lib_present(synth(D)),lib_delete(synth(D))),
    if(lib_present(wave(D)),lib_delete(wave(D))),    
    if(lib_present(red(D)),lib_delete(red(D))),    
    if(definition(D/_<==>_), erase_def(D)),
    writef('Deleted def(%t)\n',[D]).
   
        % For (sub)methods we map into the code that handles the
        % (sub)method databases.
        % The calls to lib_present/1 are strictly speaking unnecessary
        % (since we already tested for presence of mthd(M/A) at the top
        % of lib_delete), but it serves to instantiate M/A properly if
        % lib_delete was called with a var argument.
lib_delete(mthd(M/A)) :-
    lib_present(mthd(M/A)),
    delete_method(M/A),
    writef('Deleted %t\n',[mthd(M/A)]).
lib_delete(smthd(M/A)) :-
    lib_present(smthd(M/A)),
    delete_submethod(M/A),
    writef('Deleted %t\n',[smthd(M/A)]).
lib_delete(hint(M/A)) :-
    lib_present(hint(M/A)),
    delete_hint(M/A),
    writef('Deleted %t\n',[hint(M/A)]).

        % iterative version:
lib_delete([]).
lib_delete([H|T]) :- lib_delete(H), lib_delete(T).

lib_delete_aux(D,N) :-
    (concat_atom([D,N], Eqn);
     concat_atom([D,'_d',N],Eqn)),
    lib_present(eqn(Eqn)),
    lib_delete(anythm(Eqn,eqn)),
    M is N + 1,
    lib_delete_aux(D,M).
lib_delete_aux(_D,_N).

        % lib_delete deletes all objects in the current library.
lib_delete :- lib_delete(_), fail.
lib_delete.

lib_sdir(X) :-
    saving_dir(X).

        % lib_set/1 can set some global parameters. Currently only the
        % default directory for library-loading and the editor called by
        % lib_edit. 
lib_set(dir(D)) :-
    ground(D),
    is_list(D),!,
    writef('Setting library search path to %t.\n',[D]),
    remove_pred(lib_dir,1), assert(lib_dir(D)).
lib_set(sdir(D)) :- !,
    ground(D),
    \+ is_list(D),!,
    writef('Setting library save directory to %t.\n',[D]),
    remove_pred(saving_dir,1), assert(saving_dir(D)).
lib_set(editor(E)) :- !,
    writef('Setting editor to %t.\n',[E]),
    remove_pred(lib_editor,1), assert(lib_editor(E)).
lib_set(_) :-
    clam_user_error(
	'Argument to lib_set/1 must be one of dir([..]), sdir(.), editor(.)\n',[]),
    !,fail.

        % lib_edit(+Mthd) will edit Mthd (which is a (sub)method
        % specification of the form mthd(M/N) or smthd(M/N)). After
        % editing, Mthd will be loaded.
        % Optional second argument specifies directory where Mthd is to
        % be found, defaulting to the library directory.
        %
        % lib_edit/0 will edit most recently edited (sub)method.
:- dynamic lib_editor/1.
lib_edit(Mthd) :- lib_dir(Dir), lib_edit(Mthd,Dir).
lib_edit(Mthd,Dir) :- clause(lib_editor(Edit),_),!,lib_edit(Mthd,Dir,Edit).
lib_edit(Mthd,Dir) :- 
    (environ('VISUAL', Edit)
     orelse environ('EDITOR', Edit)
     orelse Edit=vi
    ),
    assert(lib_editor(Edit)),
    lib_edit(Mthd,Dir).
lib_edit(Mthd,Dir,Edit) :-
    Mthd =.. [Type,M/_], member(Type,[mthd,smthd]),
    (recorded(lib_edit,_,Ref)->erase(Ref);true),
    recorda(lib_edit,(Mthd,Dir),_),
    concat_atom([Edit,' ',Dir,'/',M,'.',Type],Command),
    unix(shell(Command)),!,
    lib_load(Mthd,Dir).
lib_edit(_,_,_) :-
    writef('CLaM ERROR: Can (currently) only edit mthd(M/N) or smthd(M/N)\n'),
    !,fail.
lib_edit :-
    recorded(lib_edit,(Mthd,Dir),_),!,lib_edit(Mthd,Dir).
lib_edit :-
    writef('CLaM ERROR: No previously edited object\n'),!,fail.


/* search down Path (a list of directories) for a directory Dir which
 * points to an object Type(D).  We don't use member/2 here since we
 * want to be sure to scan Path in the correct order.  The special
 * symbol '*' in a Path signifies the default system directory: this
 * cannot be changed by the user, it is defined at compile-time.  In
 * case of non-list path argument, expand into a singleton path.  */  
lib_fname_exists(Directory, Dir,D, Type, File) :-
    \+ is_list(Directory),
    !,
    lib_fname_exists([Directory], Dir,D, Type, File).
lib_fname_exists([], _Dir,_D, _Type, _File) :- !,fail.
lib_fname_exists(['*'|_Path], Dir,D, Type, File) :-
    lib_dir_system(Dir),
    lib_fname(Dir,D,Type,File),			% get the full name
    file_exists(File),!.
lib_fname_exists([Dir|_Path], Dir,D, Type, File) :-
    lib_fname(Dir,D,Type,File),			% get the full name
    file_exists(File),!.
lib_fname_exists([_|Path], Dir,D, Type, File) :-
    lib_fname_exists(Path, Dir,D, Type, File).	% else recurse


/* simpler version for directory searching and a single filename */
lib_fname_exists([],_File,_AbsFile) :- !,fail.
lib_fname_exists(['*'|_Path],File,AbsFile) :-
    lib_dir_system(Dir),
    concat_atom([Dir,'/',File],AbsFile1),
    lib_fname(AbsFile1,AbsFile),
    file_exists(AbsFile),!. 
lib_fname_exists([D|_Path],File,AbsFile) :-
    concat_atom([D,'/',File],AbsFile1),
    lib_fname(AbsFile1,AbsFile),
    file_exists(AbsFile),!. 
lib_fname_exists([_D|Path],File,AbsFile) :-
    lib_fname_exists(Path,File,AbsFile).


        % Try to give decent error messages to user:
lib_error(AnyThing) :-
    \+ logical_object(AnyThing,_Str,_Args),
    findall(O-S-A,(logical_object(O,S,A),numbervars(O-A,1,_)),Os),
    writef('CLaM ERROR: Illegal specification of logical object: %t.\n',
                        [AnyThing]),
    writef('            Should be one of:\n'),
    lib_error_aux(Os),
    fail.

lib_error_aux([]).
lib_error_aux([O-A-S|Os]) :-
    tab(4),
    print(O), write(' --- '),
    writef(A,S),nl,
    lib_error_aux(Os).

        % transitive closure of the needs/2 relation. Can be used
        % both ways round! For example:
        %   needed(thm(t1),def(D)) finds all definitions needed for
        %   theorem t1, and
        %   needed(thm(T),def(d1)) finds all theorems that need
        %   definition d1. 

needed(Needer,Needed) :-
    needs(Needer,N),
    member(Needed,N).
needed(Needer,Needed) :-
    needs(Needer,N),
    member(N1,N),
    needed(N1,Needed).

/* uniq_recorda/3 is like recorda/3, except that it has specialised
 * knowledge about what kind of duplicate information should be
 * avoided in the various databases.  If it spots a potential
 * duplicate, it first removes the duplicate and calls itself again.
 * This means that we don't have to worry about duplicates in all the
 * places where we do record's, but we can leave it to this predicate
 * to take care of avoiding duplication.

 * Since this predicate uses unification to match existing records and
 * new records, it can happen (and does happen) that it gets caught
 * out by Prolog's lack of occur's check when records contain unbound
 * variables.  In those cases we therefore make the existing item
 * ground before unification (and then of course have to use double
 * negation to avoid variables in the new record to get bound).  */
uniq_recorda(theorem, theorem(Name,Type,_,Thm),_) :-
    recorded(theorem, theorem(Name,Type,_,Thm),OldRef),
    erase(OldRef),
    fail.
uniq_recorda(registry, registry(Reg,_,_),_) :-
    %% Removing the registry forces us to remove all reduction rules,
    %% otherwise a non-terminating system may result. 
    recorded(registry, registry(Reg,_,_),OldRef),
    erase(OldRef),
    recorded(reduction,
	     reduction(_,_,_,_,_,_,_RuleName),RuleOldRef),
    erase(RuleOldRef),
    fail.
uniq_recorda(comp_set, comp_set(Thms,_CS),_) :-
    %% complementary sets are defined by a collection of rewrite rules
    %% (Thms), and we want to avoid duplication of these sets.
    recorded(comp_set, comp_set(Thms2,_),OldRef),
    subset(Thms2,Thms),
    erase(OldRef),
    fail.

/* It is conceivable that rewrites will one-day include quantifiers, so
   in that case we would parse x:t=>y:s=>P(x,y) as a rewrite P(X,Y)
   (as normal) and also the two other cases y:s=>P(X,y) and
   x:t=>P(x,Y).  Similarly, Clam currently uses p=>q=>r=>s as two
   rules, one conditional on p, the other on p=>q.

   In these cases, the Name/TypeDir is insufficient to pin-down the
   rewrite, so we need to check the LHS, RHS and Cond as well.
   Unification is ok since we do not want
   generalizations/specializations to be stored under the same name
   (in other words it boils down to alpha-convertibility).
 */
uniq_recorda(reduction, reduction(L,_,R,_,C,TypeDir,RuleName),_) :-
    recorded(reduction, reduction(LL,_,RR,_,CC,TypeDir,RuleName),OldRef),
    unifiable(LL-RR-CC,L-R-C),
    erase(OldRef),
    fail.
uniq_recorda(rewrite,rewrite(L,_,R,_,C,TypeDir,Name),_) :-
    recorded(rewrite,rewrite(LL,_,RR,_,CC,TypeDir,Name),OldRef),
    unifiable(LL-RR-CC,L-R-C),
    erase(OldRef),
    fail.
uniq_recorda(scheme,scheme(A,B,C),_) :-
    /* erase all schemes less general than this one */
    recorded(scheme,scheme(AA,BB,CC),OldRef),
    \+ \+ (make_ground(scheme(AA,BB,CC)),
	   scheme(AA,BB,CC) = scheme(A,B,C)),
    erase(OldRef),
    fail.
uniq_recorda(scheme,scheme(A,B,C),_) :-
    /* ... and only add this one if it is not an instance of an existing one */
    \+ \+ (make_ground(scheme(A,B,C)),
	   recorded(scheme,scheme(A,B,C),_)),!.
uniq_recorda( method, _, _) :-
    recorded( method, _, OldRef ),
    erase(OldRef),
    fail.
uniq_recorda( submethod, _, _ ) :-
    recorded( submethod, _, OldRef ),
    erase(OldRef),
    fail.
uniq_recorda( hint, _, _ ) :-
    recorded( hint, _, OldRef ),
    erase(OldRef),
    fail.
uniq_recorda( proof_plan, proof_plan(_,T,_,_,_), _ ) :-
    recorded( proof_plan, proof_plan(_,T,_,_,_), OldRef ),
    erase(OldRef),
    fail.
uniq_recorda( Index, method(A,_ ), _ ) :-
    recorded( Index, method(A,_), OldRef ),
    erase(OldRef),
    fail.
uniq_recorda( Index, submethod(A, _ ), _ ) :-
    recorded( Index, submethod(A,_), OldRef ),
    erase(OldRef),
    fail.
uniq_recorda( Index, hint(A, _ ), _ ) :-
    recorded( Index, hint(A,_), OldRef ),
    erase(OldRef),
    fail.
/* base clause does the real work (ie. if no duplicate is found,
 * possibly after duplicates have removed):  */
uniq_recorda(Index,Term,Ref) :- recorda(Index,Term,Ref).

/* Beginnings of a lib_create */
lib_create(trs(default)) :-
    if(lib_present(trs(default)),lib_delete(trs(default))),
    uniq_recorda(registry,registry(positive,[in/ms],[]-[]),_),
    uniq_recorda(registry,registry(negative,[in/ms],[]-[]),_).

lib_create(defeqn(Name)):-
    read_type(Name, Type),
    write('Enter equations for... ("eod." to finish)'),nl,
    read_equations(Name, Type, 1),
    writef('Use lib_save(defeqn(%t)) to save and parse your definition.',[Name]),nl.

read_type(Name, Dm => Rn):-
        writef('Enter type for %t: ',[Name]),
        readfile(user, Dm => Rn),
        generate_args(Dm, Args),
        concat_atom([Name], NameSynth),
        NameArgs =.. [Name|Args],
        TermOfSynth =.. [term_of, NameSynth],
        generate_appl(TermOfSynth, Args, Defn),
        generate_synth_thm(Dm, Args, Rn, ThmSynth),
        add_thm(NameSynth, ThmSynth),
        record_thm(NameSynth, synth),
        add_def(NameArgs <==> Defn).

        % generate_synth_thm/4
        %
        %
generate_synth_thm(Dm, Args, Rn, []==>ThmSynth):-
        gen_synth_thm(Dm, Args, Rn, ThmSynth).

gen_synth_thm(Typ # Typs, [Arg|Args], RnTyp, Arg:Typ => Body):-
	gen_synth_thm(Typs, Args, RnTyp, Body).
gen_synth_thm(Typ, [Arg], RnTyp, Arg:Typ => RnTyp):-
        member(Typ, [int, list(int), pnat, list(pnat)]).
	
        % generate_args/2
        %
        %
generate_args(Type, Args):-
	generate_args_(Type, Args),
        make_ground(Args).
generate_args_(_ # Typs, [_|Args]):-
        generate_args_(Typs, Args).
generate_args_(_, [_]).

        % generate_appl/3
        %
        %
generate_appl(Func, [], Func).
generate_appl(Func, [Arg|Args], FuncApp):-
	generate_appl(Func of Arg, Args, FuncApp).

        % read_equations/3
        %
        %
read_equations(Eqn, Type, Cnt):-
    concat_atom([Eqn, Cnt], EqnCnt),
    writef('%t: ', [EqnCnt]),
    read_equation(EqnCnt, Type, Equation),
    (Equation = eod 
      -> writef("Defintion of %t completed.\n",[Eqn])
      ;  (NCnt is Cnt + 1,
	  read_equations(Eqn, Type, NCnt))).
read_equations(_Eqn, _Type, _Cnt):-
    nl,write('Bad defintion (syntax?)'), nl.



        % read_equation/2
        %
        %
read_equation(EqnCnt, DmType => RnType, Equation):-
    readfile(user, Equation),
    (\+ Equation = eod 
      -> ((Equation = (LHS = RHS)
	    -> Cond = []	%empty Condition
	    ;  Equation = (Cond => (LHS = RHS))),
	  generate_bindings(DmType, Cond => (LHS = RHS), Bindings),
	  (Cond = []
	    -> matrix(Bindings, LHS = RHS in RnType, EqnThm)
	    ;  matrix(Bindings, Cond => (LHS = RHS in RnType), EqnThm)),
	  add_thm(EqnCnt, []==>EqnThm),
	  record_thm(EqnCnt, eqn))
      ;  true).

        % generate_bindings/3
        %
        %
generate_bindings(Type, [] => LHS = RHS, Bindings):-
    freevarsinterm(LHS, VarsLHS),
    freevarsinterm(RHS, VarsRHS),
    subset(VarsRHS, VarsLHS),
    gen_bindings(Type, LHS, VarsLHS, Bindings).
generate_bindings(Type, Cond => LHS = RHS, Bindings):-
    \+Cond = [],
    freevarsinterm(LHS, VarsLHS),
    freevarsinterm(RHS, VarsRHS),
    freevarsinterm(Cond, VarsCond),
    (subset(VarsCond, VarsLHS)
      -> (subset(VarsRHS, VarsLHS) 
          -> gen_bindings(Type, LHS, VarsLHS, Bindings)
          ;  writef("Freevariables of rhs %t are not subset of those in lhs %t\n",[RHS,LHS]))
      ; writef("Freevariables of condition %t are not subset of those in lhs %t\n",[Cond,LHS])).

        % gen_bindings/3
        %
        %
gen_bindings(Type, Term, Vars, VarTyps):-
	Term =.. [_|Args],
        type_terms(Type, Args, ArgsTyps),
        type_vars(ArgsTyps, Vars, VarTyps).

type_terms(Typ # Type, [Arg|Args], [Arg-Typ|ArgsTyps]):- !,
	type_terms(Type, Args, ArgsTyps).
type_terms(Typ, [Arg], [Arg-Typ]).

type_vars([], _, []).
        %
        % varibale case
        %
type_vars([Term-Typ|TermTyps], Vars, [Term:Typ|Bindings]):-
	member(Term, Vars),
	type_vars(TermTyps, Vars, Bindings).
        %
        % constant case
        %
type_vars([Term-Typ|TermTyps], Vars, Bindings):-
	oyster_type(Typ, _, [Term]),  
        type_vars(TermTyps, Vars, Bindings).
	% 
        % constructor case
        %
type_vars([Term-Typ|TermTyps], Vars, Bindings):-
        oyster_type(Typ, [Term], _),
        decomp_term_typs(Term, Typ, TTs),
        append(TTs, TermTyps, NewTermTyps),
        type_vars(NewTermTyps, Vars, Bindings).

decomp_term_typs(s(X), pnat, [X-pnat]).
decomp_term_typs(X::Y, Z list, [X-Z, Y-(Z list)]).

/* tell/1 but with error message */
tell_on_file(File) :-
    tell(File),!.
tell_on_file(File) :-
    clam_user_error('Unable to write to file %t\n',[File]),
    fail.
