/*
 * @(#)$Id: transitivity.pl,v 1.1.2.1 1998/08/21 11:51:28 rjb Exp $
 *
 * $Log: transitivity.pl,v $
 * Revision 1.1.2.1  1998/08/21 11:51:28  rjb
 * Support for user-defined transitivity relations.
 *
 */

?-if(multifile_needed). ?-multifile file_version/1. ?-endif.
file_version('$Id: transitivity.pl,v 1.1.2.1 1998/08/21 11:51:28 rjb Exp $').

/*
 * This file contains code for recognizing transitivity rules.
 *
 * Transitivity rules are stored at load time.
 * This is done by the predicate add_transitivity_rule/1, called from the
 * library mechanism in library.pl
 */

add_transitivity_rule(RuleName) :-
    is_a_transitivity_rule(RuleName,Relation),
    (transitive(Relation); asserta(transitive(Relation))),
    uniq_recorda(transitivity,transitivity(Relation,RuleName),_),
    writef('Added transitivity record for %t\n',[RuleName]).
add_transitivity_rule(_).

is_a_transitivity_rule(RuleName,Relation) :-
    recorded(theorem,theorem(_,_,Thm,RuleName),_),
    matrix(_,Matrix,Thm),
    transitivity_fragments(Matrix,T1,T2,T3),
    T1 =.. [Relation,X,Y],
    T2 =.. [Relation,Y,Z],
    T3 =.. [Relation,X,Z].

transitivity_fragments((T1 # T2) => T3,T1,T2,T3).
transitivity_fragments((T2 # T1) => T3,T1,T2,T3).
transitivity_fragments(T1 => (T2 => T3),T1,T2,T3).
transitivity_fragments(T2 => (T1 => T3),T1,T2,T3).
