/*
 * @(#)$Id: propositional.pl,v 1.7 1997/09/26 14:37:22 img Exp $
 *
 * $Log: propositional.pl,v $
 * Revision 1.7  1997/09/26 14:37:22  img
 * typo
 *
 * Revision 1.6  1997/06/05 10:32:59  img
 * New decider for IPC
 *
 * Revision 1.5  1997/01/14 10:44:21  img
 * Generalized conditional for multifile declaration.
 *
 * Revision 1.4  1995/07/18 14:16:03  img
 * hyp(V) instead of intro since the derived rule sometimes gets it wrong
 *
 * Revision 1.3  1995/05/17  02:17:49  img
 * 	* Conditional multifile declaration (for Quintus).
 *
 * Revision 1.2  1995/03/01  04:14:28  img
 * 	* Added file_version/1 and associated multifile declaration
 *
 * Revision 1.1  1994/09/16  09:18:22  dream
 * Initial revision
 *
 */

?-if(multifile_needed). ?-multifile file_version/1. ?-endif.
file_version('$Id: propositional.pl,v 1.7 1997/09/26 14:37:22 img Exp $').

/* This file contains a decision procedure for the propositional part
 * of the Nuprl logic.  See Dyckhoff's JSL article for information
 * (1992).  */

/* propositional(+Sequent,?Tactic) succeeds iff Sequent is provable in
   the intuistionistic predicate calculus; Tactic is the Oyster
   tactic.  <=> is translated as normal.  If Sequent is not provable,
   propositional/2 will fail.   */

propositional(H==>G,P) :-ipc_tautology(H==>G,P).

ipc_tautology(H==>G, unfold_def_all(_ <=> _) then Prf) :-
    !,
    no_biimplications(G,GG),
    !,ipc_derivable(H==>GG,Prf),!.
ipc_tautology(G,unfold_def_all(_ <=> _) then Prf) :-
    no_biimplications(G,GG),
    ipc_derivable([]==>GG,Prf),!.

/* Build a derivation for Seq */
ipc_derivable(Seq,Rule) :-
    ax_ipc_rule(Rule,Seq),!.
ipc_derivable(Seq,Rule then Tacs) :-
    ipc_rule(Rule,Seq,SSeqs),
    ipc_derivable_map(SSeqs,Tacs).

ipc_derivable_map([],[]).
ipc_derivable_map([S|Ss],[R|Rs]) :-
    ipc_derivable(S,R),
    ipc_derivable_map(Ss,Rs).

atomic_prop(_ # _) :- !,fail.
atomic_prop( _  \ _ ) :- !,fail.
atomic_prop( _ => _ ) :- !,fail.
atomic_prop(_ <=> _ ) :- !,fail.
atomic_prop( void ) :- !,fail.
atomic_prop( _ ).

ax_ipc_rule(hyp(V), H==>G) :- member(V:G,H).
ax_ipc_rule(elim(V), H==>_) :- member(V:void,H).

ipc_rule(intro(new [V])then wfftacs, H==>(A=>B), [[V:A|H]==>B]) :-
    !.
ipc_rule(intro, H==>A#B, [H==>A,H==>B]) :- !.
ipc_rule(elim(V,new [VA,VB,_]), H==>G,
	 [[VA:A,VB:B|HH]==>G]) :-
    select(V:(A#B),H,HH),!.

ipc_rule(elim(V,new [VA,VB,_,_]), H==>G,		% orelim
	 [[VA:A|HH]==>G,
	  [VB:B|HH]==>G]) :- 
    select(V:(A\B),H,HH),!.
ipc_rule(intro(left), H==>A\_, [H==>A]).
ipc_rule(intro(right), H==>_\B, [H==>B]).

ipc_rule(ImpERule, H==>G, Seqs) :-
    member( V:(A=>B), H),
    impe_ipc_rule(ImpERule, V:(A=>B), H==>G, Seqs).

impe_ipc_rule(elim(V,new [VB]) then [hyp(VA), idtac],
	      V:A=>B, H==>G, [[VB:B|HH]==>G]) :-
    member(VA:A,H),
    atomic_prop(A),
    select(V:A=>B,H,HH),!.

impe_ipc_rule(lemma(ipc_dp_imp_e2,new[L])
			then [elim_on_thin(L,[C,D,B,G]) 
				  then elim(L,new [L2]) then
				  [intro(new [VCBD]) then [idtac,wfftacs],
				   elim(L2,new[L3])
			then
				       [hyp(V),hyp(L3)]]],
	      V:(C # D)=>B, H==>G, [[VCBD:(C=>(D=>B))|HH]==>G]) :-
    select(V:(C#D)=>B,H,HH),!.

impe_ipc_rule(lemma(ipc_dp_imp_e3,new[L1])then
		  elim_on_thin(L1,[C,D,B,G])then elim(L1,new[L3])then
		  [(intro(new[L3])then wfftacs)then elim(L3,new[VC,VD,_])then idtac,
		   elim(L3,new[L4])then[hyp(V),hyp(L4)]] ,
	      V:(C\D)=>B, H==>G, [[VC:C=>B,VD:D=>B|HH]==>G]) :-
    select(V:(C\D)=>B,H,HH),!.

impe_ipc_rule(lemma(ipc_dp_imp_e4,new[L1])
		  then elim_on_thin(L1,[G,B,C,D])
		  then elim(L1,new[L2])then
		  [intro then
		       [(intro(new[L2])then[idtac,wfftacs]),
			(intro(new[L2])then[idtac,wfftacs])],
		   elim(L2,new[L3])then[hyp(V),hyp(L3)] ] ,

	      V:(C=>D)=>B, H==>G, [[L2:B|HH]==>G,
				   [L2:D=>B|HH]==>(C=>D)]) :-
    select(V:(C=>D)=>B,H,HH),!.

/* no_biimplications(+U,?V) U and V are equivalent propositions such
   that V does not contain <=>  */ 
no_biimplications(A<=>B,(AA=>BB)#(BB=>AA)) :-
	no_biimplications(A,AA),
	no_biimplications(B,BB).
no_biimplications([],[]).
no_biimplications([A|As],[AA|AAs]) :-
	no_biimplications(A,AA),
	no_biimplications(As,AAs).
no_biimplications(A,A) :-atomic_prop(A),!.
no_biimplications(A,AA) :- A =.. [P|As],
	no_biimplications(As,AAs),
	AA =.. [P|AAs].
