/*
 * @(#)$Id: methodical.pl,v 1.6 1997/01/14 10:44:18 img Exp $
 *
 * $Log: methodical.pl,v $
 * Revision 1.6  1997/01/14 10:44:18  img
 * Generalized conditional for multifile declaration.
 *
 * Revision 1.5  1996/12/04 12:26:24  img
 * Add iterate_lazy methodical; remove stuff that interferes with portray/1
 *
 * Revision 1.4  1995/11/28  20:19:47  img
 * experimental until methodical added
 *
 * Revision 1.3  1995/05/17  02:17:43  img
 * 	* Conditional multifile declaration (for Quintus).
 *
 * Revision 1.2  1995/03/01  04:14:23  img
 * 	* Added file_version/1 and associated multifile declaration
 *
 * Revision 1.1  1994/09/16  09:18:22  dream
 * Initial revision
 *
 */

?-if(multifile_needed). ?-multifile file_version/1. ?-endif.
file_version('$Id: methodical.pl,v 1.6 1997/01/14 10:44:18 img Exp $').

/*
 * This file contains code for "methodical" which are operators which
 * apply to methods: a methodical is to a method what a tactical is to a
 * method.
 * Currently the system has two methodicals: "iterate Method" and
 * "try Method". We could imagine other methodicals, such as "complete",
 * "progress", etc.
 */

/* ITERATTION METHODICAL: */

/* The top-level predicates for producing iterated methods are
 * iterate_methods/2 (for iterating a set of methods), and
 * iterate_submethods/2 (for iterating a set of submethods). 
 * Both these predicates produce a method/6 terms, which, like the
 * normal (sub)method/6 clauses can be stored in the method database, as
 * defined in method-db.pl
 */

/*
 * Before giving the code, some brief experiences with the "iterator"
 * methodical:
 * 
 * [1] After playing with the iterator
 * methodical applied to wave and base, we found that the plans do
 * (of course) become shorter, but that the time it takes to generate
 * the plan (at least using dplan) increases a lot. This has mainly to
 * do with the fact that the applicability of method(Method,...) is
 * computed in the base case of every loop of 
 * the planner when it is looking for potentially completing plans. So
 * far, the base-case of the planning loop was always cheap, since the
 * insistence on Effects=[] ruled out most of the methods without even
 * computing their pre-conds (let alone their postconds), but since the
 * Effects of method(Method,...) for iterators is always just a Var, the
 * planners always 
 * computes the applicability of method(Method,...) for every base case,
 * even though this will never succeed eventually, since Var will never
 * turn out to be []. 
 *
 * To remedy this problem, iterate_methods(Methods, Methodical) tries
 * to find out if there is ever any chance of any of the Methods
 * producing an empty Effects slot. If not, it enforces the Effects slot of
 * method(Methodical,...) be a non-empty list, so as to avoid
 * the above problem with the base-case of the planning loop.
 *
 * [2] Remember that the code of an iterated version of a method goes
 * through exactly the same motions as the uniterated method (in fact,
 * it uses the uniterated method). Thus, the relation between a method and
 * its iterated version is *not* the same as the relation between
 * ind_strat version III and its constituents. There, the ind_strat is a
 * genuine "compilation/reformulation" of the actions of the constituent
 * methods. The ind_strat does the same thing as the constituent
 * methods, but does it in a very different way. The iterated version of
 * a method does the same as a sequence of applications of the single
 * method, but does it in exactly the *same* way. For illustration, the
 * corresponding thing to ind_strat, but for iteration of wave would
 * be not the code generated by iterate_methods([wave]), but something like:
 *
 *  method(wave,
 *         H==>G,
 *         [applicable(H==>G,wave(_))],
 *         [simplify_rules(Rules),
 *          canonical_form(G,Rules,NewG)],
 *         [H==>NewG],
 *         wave
 *  	  )
 *
 * which is much more efficient, but of course much harder (if not
 * impossible) to generate. As a result, planning becomes not more
 * efficient with iterated methods. In fact, it becomes a bit slower,
 * because of the added overhead of applicable/2 and applicable/4 etc.
 */

	% iterate_methods(+MthdList,+Methodical,+{methods,submethods},ItMethod)
	% binds ItMethod to an method/6 term which is the code for a
	% new Methodical which iterates all [sub_]methods in MethodList,
	% where the elements of MthdList are specified as skeletal
	% functors. The newly constructed Methodical will get the name
	% Methodical, which must be a functor of arity 1. The single
	% argument of Methodical will be the calls that the methodical
	% makes to the iterated methods from MthdList.
	% We also install the code for the tactic corresponding to the
	% newly constructed Methodical.
	% ItMethod must be bound to a method/6 or submethod/6 term
	% to determine wether we are constructing a method or a submethod.
	% 
	% To make the code for iterate_methods understandable, we list
	% here the code it would produce if we called
	% 	:- iterate_methods(it_104ab,[m_104a(_),m_104b(_,_)],ItM).
	% This would give:
	% 
	% ItM = method(it_104ab([Call|RestCalls]),
	%              H==>G, 
	% 	       [thereis {Call,O1}:
	%	                (member(Call,[m_104a(_),m_104b(_,_)]),
	%	                 applicable(H==>G,Call,_,O1))
	%	        ((O1=[],O2=O1);[O2]=O1)
	% 	       ],
	%              [(applicable(O2,it_104ab(RestCalls),_,[Out|Put])
	%                orelse
	%                ([Out|Put] = O1, RestCalls=[]) 
	%               ) 
	%              ], 
	%              [Out|Put], 
	%              it_104ab([Call|RestCalls]) 
	%             ).
	% 
	% A particular application of the newly constructed methodical
	% it_104ab could look like:
	% 
	%   it_104ab([m_104a([1],v0),m_104b([0],v1),m_104a([1],v1)])
	% 
	% In other words, the single argument of the it_104ab/1 methodical is
	% the list of applications of the individual iterated methods.
	% Some remarks about this code:
	% - Notice enforcing the non-empty [Out|Put] list if none of the
	% iterated methods can possibly terminate (see comments above).
	% 
	% - If some of the methods can terminate, we have a choice in
	% how to make the iterator behave: should it prefer
	% terminating methods over non-terminating ones, or should it
	% just iterate them in a fixed sequence, and stop when it
	% happens to hit a terminating method, without actually
	% gravitating towards one. The first (preferring terminating
	% methods) is obviously preferable, but makes the iterator
	% potentially more expensive, since it will first try all
	% methods to see if there is a terminating one, and if not, it
	% will have to iterate over the methods in sequence as usual.
	% These two behaviours can be obtained by changing the order
	% of the two conjuncts in the preconditions: having the
	% "thereis" first will allow termination but not prefer it,
	% while having the "thereis" second will prefer termination at
	% the cost of trying all methods first for termination.
	% Of course, even with the second option (no preference for
	% terminating methods), the iterated methods can be ordered in
	% the sequence so as to have the terminating ones first, but
	% this is not possible in all cases.
	% 
	% (In the following, Method is an element of MthdList):
	% - At the moment, Method is assumed return have a singleton
	% Effects slot (the use of [O1]). This could (and should)
	% be fixed sometime.
	% 
	% - Tactic for Method is assumed to have same name and arguments
	% as the Method. This assumption could be relaxed, but I can't
	% be bothered now.
	% 
	% - method(Methodical,...) does either all possible iterations
	% at a certain point in the proof or none at all. If it turns out
	% that it is sometimes necessary to do some Method
	% applications, but not all, then the method(Methodical,...)
	% method can be changed to allow subsequences of
	% Method applications. This can be done by simply 
	% changing the orelse in the postconds into a ;. This would
	% generate all subsequences of Method applications, the
	% longest sequence first,but would not bother about
	% permutations. Removing the "thereis" from the preconditions
	% as well would also generate all permutations.
	% (Removing only the "thereis" from the preconds and leaving the
	% orelse in the postconds would only generate all permutations of
	% maximum length, which is completely useless).
	% 
	% - At the moment iterations of length 1 are not suppressed.
	% Maybe this should be done sometime. Alternatively, we could
	% allow iterations of length 1 and remove the original Method.
	% 
	% Finally the code: we first check if any of the Methods is
	% potentially terminating. If not so, we can afford to make the
	% Output slot of the new Methodical to be a non-empty list. Pick
	% up the right version of applicable[_submethod], and do a big
	% assertz.
	%
	% We also want to update the pretty-printer for each iterator
	% (to suppress printing the longwinded argument of the iterator
	% method). We have to dynamically assert the clauses for the
	% tactic of the iterator.
	% This problem would go away if there was a unique way of
	% identifying iterators (for instance if they were always called
	% "iterator It(Arg)" or something). This used to be the case, but
	% created all kinds of other problems, in particular the fact
	% that a single M/A specification would no longer do for all
	% methods. 
iterate_methods(M,Methods,Types, ItMethod) :-
        % check for possibility that Method is terminating, see comments above:
    (Types=methods -> Type=method ; Type=submethod),
    (forall {O\(member(K,Methods),apply(Type,[K,_,_,_,O,_]))}:functor(O,'.',2)
     -> Output=[_|_]
     ;  true
    ),
        % Use either applicable or applicable_submethod as appropriate:
    (Types=methods
     -> Applicable=applicable
     ;  Applicable=applicable_submethod
    ),
    (functor(ItMethod,method,6)
     -> Continue=applicable
     ;  Continue=applicable_submethod
    ),
	% bind single argument of Methodical to call-list:
    Methodical =.. [M,[Call|RestCalls]],
    RestMethod =.. [M,RestCalls],
    ItMethod=..[_ITFunctor, Methodical,
                            Input,
% Jason: replace thereis{Call,O1} with thereis{Input,Call,O1}
% This ensures that all variables in the input goal which are copied by
% thereis/2 are unified with the corresponding original.
			    [thereis {Input,Call,O1}:
			            (member(Call,Methods),
			             apply(Applicable,[Input,Call,_,O1])),
			     ((O1=[],O2=O1) v [O2]=O1)
			    ],
			    [(apply(Continue,[O2,RestMethod,_,Output])
			      orelse
			      (Output = O1,RestCalls=[])
			     )
			    ],
			    Output,
			    Methodical
		],
	!,
 	% install the code for the Methodical-tactic
	% (not nice that this needs to be done here...).
	% Also, I wish Prolog had functor-variables. The code we so
	% painfully construct below looks as follows (assuming M is the
	% functor of Methodical(_)):
	% 
	%    M(Calls) :-
	%        var(Calls), !,
	%        applicable(M(Calls)), (or applicable_submethod(M(Calls)) )
	%        apply(M(Calls)).
	%    M([]) :- !.
	%    M([H|T]) :- !, apply(H then M(T)).
	%
	% Notice that we could accidentally overwrite an existing clause...
    Skel_M  =.. [M,Calls],
    remove_pred(M,1),
    Findout =.. [Continue, Skel_M,_,_],
    asserta((Skel_M :- 
	         var(Calls),!,
		 Findout,
		 apply(Skel_M))),
    Nil_M =.. [M,[]],
    assertz((Nil_M :- !)),
    List_M =.. [M,[Head|Tail]],
    Tail_M =.. [M,Tail],
    assertz((List_M :- !,
	         apply(Head then Tail_M))).

/* Lazy version.  The iterator constructs smaller chains first, longer
   chains on backtraking.  The postconditions are quite weak.  */
iterate_methods_lazy(M,Methods,Types, ItMethod) :-
        % check for possibility that Method is terminating, see comments above:
    (Types=methods -> Type=method ; Type=submethod),
    (forall {O\(member(K,Methods),apply(Type,[K,_,_,_,O,_]))}:functor(O,'.',2)
     -> Output=[_|_]
     ;  true
    ),
        % Use either applicable or applicable_submethod as appropriate:
    (Types=methods
     -> Applicable=applicable
     ;  Applicable=applicable_submethod
    ),
    (functor(ItMethod,method,6)
     -> Continue=applicable
     ;  Continue=applicable_submethod
    ),
	% bind single argument of Methodical to call-list:
    Methodical =.. [M,[Call|RestCalls]],
    RestMethod =.. [M,RestCalls],
    ItMethod=..[_ITFunctor, Methodical,
                            Input,
% Jason: replace thereis{Call,O1} with thereis{Input,Call,O1}
% This ensures that all variables in the input goal which are copied by
% thereis/2 are unified with the corresponding original.
			    [((Call=idtac,Output=[Input],RestCalls=[]);
			      ((thereis {Input,Call,O1}:
				   (member(Call,Methods),
				    apply(Applicable,[Input,Call,_,O1]))),
			       ((O1=[],O2=O1) v
				    (([O2]=O1),
				     apply(Continue,[O2,RestMethod,_,
						     Output])))))],
			    [],
			    Output,
			    Methodical
		],
	!,
 	% install the code for the Methodical-tactic
	% (not nice that this needs to be done here...).
	% Also, I wish Prolog had functor-variables. The code we so
	% painfully construct below looks as follows (assuming M is the
	% functor of Methodical(_)):
	% 
	%    M(Calls) :-
	%        var(Calls), !,
	%        applicable(M(Calls)), (or applicable_submethod(M(Calls)) )
	%        apply(M(Calls)).
	%    M([]) :- !.
	%    M([H|T]) :- !, apply(H then M(T)).
	%
	% Notice that we could accidentally overwrite an existing clause...
    Skel_M  =.. [M,Calls],
    remove_pred(M,1),
    Findout =.. [Continue, Skel_M,_,_],
    asserta((Skel_M :- 
	         var(Calls),!,
		 Findout,
		 apply(Skel_M))),
    Nil_M =.. [M,[]],
    assertz((Nil_M :- !)),
    List_M =.. [M,[Head|Tail]],
    Tail_M =.. [M,Tail],
    assertz((List_M :- !,
	         apply(Head then Tail_M))).

/* TRY METHODICAL: */
/* 
 * The try/1 methodical is handled in a different way from the iteration
 * methodical. We do not produce a special method for each try/1 method,
 * but instead produce special clauses for applicable(_submethod)/[2;4]
 * and for executing the corresponding tactic:
 */

	% Applicable/[2;4] clauses for the try/1 methodical:
	% applicable(try Method) succeeds just as applicable(Method)
	% does if Method is applicable, but does not fail if Method is
	% not applicable. Instead we succeed with emtpy Postconditions
	% and Effects=[Input].
	%
	% These clauses get called from the applcble-clauses in
	% applicable.pl.
	%
	% Each of these clauses starts with a line which tests if the
	% Methods argument is really instantiated to try/1, since we
	% don't want to generate try/1's when called with second
	% argument in mode -.
	% (Actually, this test is already done in applcble/[3;5]
	% before the code below gets called, but we might as well do it
	% here also, just to be sure....)
	%
	% All these clauses do is wrap an extra success-point around the
	% call to the appropriate applcble clause.
applicable_try(Type,Input,Try_Method) :-
    functorp(Try_Method,try,1), Try_Method = (try Method),
    applcble(Type,Input,Method).
applicable_try(Type,Input,Try_Method) :-
    functorp(Try_Method,try,1), Try_Method = (try Method),
    \+ applcble(Type,Input,Method).
applicable_try(_,_,Try_Method) :-
    functorp(Try_Method,try,1),
    !, fail.
	% similar clauses for applicable/4
applicable_try(Type,Input,Try_Method,Post,Effects) :-
    functorp(Try_Method,try,1), Try_Method = (try Method),
    applcble(Type,Input,Method,Post,Effects).
applicable_try(Type,Input,Try_Method,[],[Input]) :-
    functorp(Try_Method,try,1), Try_Method = (try Method),
    \+ applcble(Type,Input,Method,_,_).
applicable_try(_,_,Try_Method,_,_) :-
    functorp(Try_Method,try,1), 
    !, fail.

/* THEN/2 METHODICAL */
	% The then/2 methodical is exactly like the then/2 tactical.
	%
	% First clauses for applicable/3. We distinguish between
	% m1 then m2 and m1 then [m21,...,m2n].
applicable_then(Type,Input,M1 then M2) :-
    \+ functorp(M2,.,2),
    applcble(Type,Input,M1,_,E1s),
    map_list(E1s,E1:=>M2,applcble(Type,E1,M2),M2s),
    remove_dups(M2s,[M2]).
applicable_then(Type,Input,M1 then [M2|M2s]) :-
    applcble(Type,Input,M1,_,E1s),
    zip(Pairs,E1s,[M2|M2s]),
    map_list(Pairs, Inp-M:=>M, applcble(Type,Inp,M), [M2|M2s]).
    	% Similar clauses for applicable/5:
applicable_then(Type,Input,M1 then M2, Posts, Effects) :-
    \+ functorp(M2,.,2),
    applcble(Type,Input,M1,_,E1s),
    map_list(E1s, E1:=>Post-Effect-M2,
            applcble(Type,E1,M2,Post,Effect),
	    OutTripples),
    zip(OutTripples,OutPairs,M2s),
%%%%% Constraint removed A. Ireland 31/3/92   
    remove_dups(M2s,[M2]),
    zip(OutPairs,Posts,EffectsL),
    append(EffectsL,Effects).

applicable_then(Type,Input,M1 then [M2|M2s], Posts, Effects) :-
    applcble(Type,Input,M1,_,E1s),
    zip(Pairs,E1s,[M2|M2s]),
    map_list(Pairs, Inp-M:=>Post-Effect, applcble(Type,Inp,M,Post,Effect),
    	    PostsEffects),
    zip(PostsEffects,PostsL,EffectsL),
    append(PostsL,Posts),append(EffectsL,Effects).

/* OR/2 METHODICAL */
	% The or/2 methodical is exactly like the or/2 tactical.
	% First clauses for applicable/3. 
applicable_or(Type,Input,M1 or _) :-
    applcble(Type,Input,M1).
applicable_or(Type,Input,_ or M2) :-
    applcble(Type,Input,M2).
    	% Similar clauses for applicable/5:
applicable_or(Type,Input,M1 or _, Posts, Effects) :-
    applcble(Type,Input,M1,Posts,Effects).
applicable_or(Type,Input, _ or M2, Posts, Effects) :-
    applcble(Type,Input,M2,Posts,Effects).

/* until methodical. this is strange since it is more of a macro than 
 * a methodical */
applicable_until(Type,Input,[M|[Mrest]] until M2) :-
    \+ applcble(Type,Input,M2),
    copy(M,Mrest),				% continue the list
    applcble(Type,Input,M,_,[E1]),!,
    applicable_until(Type,E1,Mrest until M2).
applicable_until(Type,Input,[M2] until M2) :-
    applcble(Type,Input,M2).

applicable_until(Type,Input,[M|[Mrest|Rest]] until M2,Post,Effects) :-
    \+ applcble(Type,Input,M2),
    copy(M,Mrest),				% continue the list
    applcble(Type,Input,M,_,[E1]),!,
    applicable_until(Type,E1,[Mrest|Rest] until M2,Post,Effects).
applicable_until(Type,Input,[_] until M2,Post,Effects) :-
    applcble(Type,Input,M2,Post,Effects).
