signature VisibleTactic_sig =
sig
    type term
    type vtactic
    type classifier = term -> string * Fact.fact

    datatype direction = LEFT | RIGHT

    val pp_of        : vtactic -> PrettyPrint.ppstream -> unit
    val tactic_of    : vtactic -> tactic

    val RENAME       : thm -> string list list -> thm
    val IND_TAC      : thm -> term list -> tactic
    val QIND_TAC     : thm -> term frag list list -> tactic
    val IND          : string -> (term * term) list -> vtactic

    val GENL_TAC     : string list -> vtactic
    val ELEM_TAC     : tactic
    val ELEMENTARY   : vtactic

    val ORW_TAC      : thm -> int list -> direction -> tactic
    val OCC_RW_TAC   : string -> int list -> direction -> tactic
    val OCC_RW       : string * int list * direction -> vtactic

    val WFERT_EQ_TAC : int list * direction -> tactic
    val WFERT_EQ     : int list * direction -> vtactic

    val SFERT_TAC    : tactic
    val SFERT        : vtactic

    val QSPEC_TAC    : term frag list * term frag list -> tactic
    val SPEC_TAC     : term * term -> vtactic

    val QCASE_TAC    : term frag list -> tactic
    val CASE         : term -> vtactic

    val HUH_TAC      : 'a -> tactic
    val HUH          : string -> vtactic

    val MK_GEN_TAC   : vtactic
    val MK_DISCH_TAC : vtactic
    val MK_ALL_TAC   : vtactic
    val VSUBST_TAC   : term -> tactic

    val ASM_CONJ_TAC : tactic
    val ASM_CONJ     : vtactic

    val ASM_EQ_TAC   : tactic
    val ASM_EQ       : vtactic

    val OCC_ANT      : thm -> int list -> tactic
    val ARW_TAC      : thm -> int list -> direction -> tactic
    val ANT_RW_TAC   : string -> int list -> direction -> tactic
    val ANT_RW       : string * int list * direction -> vtactic

    val WFERT_IMP_TAC: int list * direction -> tactic
    val WFERT_IMP    : int list * direction -> vtactic

    val exp_at       : term -> int list -> term

    val DECIDE       : term frag list -> thm


    val CONJECTURE     : classifier -> (string * Fact.fact) Fact.age list ref 
                           -> term -> vtactic
    val CONJECTURE_TAC : term -> tactic

    val PROVED         : (string * Fact.fact) Fact.age list ref 
                          -> string -> vtactic
    val PROVED_TAC     : thm -> tactic

end
