structure EI : EI =

struct

type vdecider = (PrettyPrint.ppstream -> unit) * (term -> thm)

fun namesrc() = 
  Lib.mk_istream (fn i => i+1) 0 (fn i => "th"^Lib.int_to_string i)


(*---------------------------------------------------------------------------*
 * Takes a term (should maybe be a goal) and classifies it with `decider',   *
 * then gets a new name for the fact, then adds the fact into the fact       *
 * database. Finally returns the name and the fact.                          *
 *                                                                           *
 * Can't make my mind up whether this should go here or in vistactic. Notice *
 * that the partial evaluation of this function is crucially important.      *
 * The function should be applied to () only once in an extended interaction.*
 *---------------------------------------------------------------------------*)
local open PrettyPrint
in
fun classify0 (pp,decider) () = 
  let val names = namesrc()
  in fn M => 
      let val fact = 
            Fact.Proved(decider M,
              fn ppstrm => 
                (begin_block ppstrm CONSISTENT 2; pp ppstrm;
                 add_break ppstrm (1,0); add_string ppstrm "`"; 
                 Lib.with_flag Globals.show_types true (pp_term ppstrm) M;
                 add_string ppstrm "`"; end_block ppstrm))
             handle _ => if (can decider (mk_neg M)) 
                         then Fact.Refuted M else Fact.CantProve M
          val s = Lib.state names before (Lib.next names; ())
          val _ = Fact.add (s,fact)
      in 
       (s,fact)
      end
end end;


val std_classifier = 
   classify0
     (C PrettyPrint.add_string "VisibleTactic.DECIDE", decisionLib.DECIDE);


(* The classifier that always fails. *)
val alwaysFail = classify0 (Lib.C PrettyPrint.add_string "NO_TAC", 
                            fn tm => raise Fail "alwaysFail");

local open Fact
in
fun proved (NEW (_,Proved _)) = true
  | proved (OLD (_,Proved _)) = true
  | proved _ = false

fun NEWof (NEW x) = x
  | NEWof (OLD x) = raise Fail "NEWof";
end;


(*---------------------------------------------------------------------------*
 * Embark on an extended interaction.                                        *
 *---------------------------------------------------------------------------*)
fun EI0 class f g =
 let val _ = (Fact.clear();  (* reset the DB of facts *)
              CallClam.delete_all_facts ())
     val mk_tacAST = CallClam.CLAM_TAC_AST0 (class())
     fun roll n =
       let val _ = Portable.output(Portable.std_out, 
                    "Round "^Lib.int_to_string n^"\n")
           val (tacAST, facts) =  mk_tacAST g
       in 
          if (Lib.all proved facts)  (* done *)
          then f (tacAST, map Fact.dest_age facts) g
          else (map CallClam.send_fact (mapfilter NEWof facts);
                roll (n+1))
       end
 in 
     roll 0
 end;

fun EI f g = EI0 std_classifier f g;

end;
