(****************************************************************************)
(*                                                                          *)
(*               Copyright 1994, 1995 University of Cambridge               *)
(*                                                                          *)
(*                           All rights reserved.                           *)
(*                                                                          *)
(****************************************************************************)

(****************************************************************************)
(* FILE          : naturals.sml                                             *)
(* DESCRIPTION   : Type of natural numbers.                                 *)
(*                                                                          *)
(* AUTHOR        : R.J.Boulton                                              *)
(* DATE          : 24th May 1994                                            *)
(*                                                                          *)
(* LAST MODIFIED : R.J.Boulton                                              *)
(* DATE          : 21st June 1995                                           *)
(****************************************************************************)

signature NATURAL =
sig
   exception Natural
   eqtype nat
   val nat_of_int : int -> nat
   val int_of_nat : nat -> int
end;

structure Natural : NATURAL =
struct

exception Natural;

datatype nat = Nat of int;

fun nat_of_int i = if (i < 0) then raise Natural else Nat i;

fun int_of_nat (Nat i) = i;

end; (* Natural *)
