(****************************************************************************)
(*                                                                          *)
(*                  Copyright 1995 University of Cambridge                  *)
(*                                                                          *)
(*                           All rights reserved.                           *)
(*                                                                          *)
(****************************************************************************)

(****************************************************************************)
(* FILE          : characters.sml                                           *)
(* DESCRIPTION   : Type of ASCII characters.                                *)
(*                                                                          *)
(* AUTHOR        : R.J.Boulton                                              *)
(* DATE          : 27th June 1995                                           *)
(*                                                                          *)
(* LAST MODIFIED : R.J.Boulton                                              *)
(* DATE          : 27th June 1995                                           *)
(****************************************************************************)

signature CHAR =
sig
   exception Character
   eqtype char
   val char_of_string : string -> char
   val string_of_char : char -> string
end;

structure Char : CHAR =
struct

exception Character;

datatype char = Char of string;

fun char_of_string s = if (size s = 1) then Char s else raise Character;

fun string_of_char (Char s) = s;

end; (* Char *)
