(*--------------------------------------------------------------------------*)
(* Define structures required by the pretty-printer                         *)
(*--------------------------------------------------------------------------*)

structure ClamConstructors = ClamAST;
structure ClamDestructors = struct end;
structure ClamExternals = LexSupport;

(*--------------------------------------------------------------------------*)
(* Load the pretty-printer                                                  *)
(*--------------------------------------------------------------------------*)

use "clam.pp.sml";

(*--------------------------------------------------------------------------*)
(* Output functions                                                         *)
(*--------------------------------------------------------------------------*)

structure ClamPrint =
struct

structure Output = PPOutFun (ClamPP.PP.PPBoxes);

(*--------------------------------------------------------------------------*)
(* Printing to the display                                                  *)
(*--------------------------------------------------------------------------*)

val print_to_display =
   Output.display_ppbox (!System.Print.linewidth) o
   ClamPP.print_plan DefaultStringTable.string_table;

(*--------------------------------------------------------------------------*)
(* Printing to a file                                                       *)
(*--------------------------------------------------------------------------*)

fun print_to_file filename =
   Output.output_ppbox filename 78 o
   ClamPP.print_plan DefaultStringTable.string_table;

end; (* ClamPrint *)
