functor ClamLexFun (structure Tokens : Clam_TOKENS)=
   struct
    structure UserDeclarations =
      struct
structure Tokens = Tokens;

type pos = Integer.int;
type svalue = Tokens.svalue;
type ('a,'b) token = ('a,'b) Tokens.token;
type lexresult = (svalue,pos) token;

val eof = fn () => Tokens.EOF (0,0);
fun error (text,first:pos,last:pos) =
   let val f = makestring first
       and l = makestring last
       val location =
          if (first = 0)
          then ""
          else if (first = last)
               then ("Line " ^ f ^ ": ")
               else ("Lines " ^ f ^ "-" ^ l ^ ": ")
   in  output (std_out,location ^ text ^ "\n")
   end;
val quotelevel = ref 0;
val quote = ref "";
val quotelineno = ref 0;

fun keyword "external" = Tokens.EXTERNAL
  | keyword "induction" = Tokens.INDUCTION
  | keyword "generalise" = Tokens.GENERALISE
  | keyword "disjunction" = Tokens.DISJUNCTION
  | keyword "new" = Tokens.NEW
  | keyword "then" = Tokens.THEN
  | keyword "in" = Tokens.IN
  | keyword "conjecture" = Tokens.CONJECTURE
  | keyword "thm" = Tokens.THM
  | keyword "atom" = Tokens.ATOM
  | keyword "void" = Tokens.VOID
  | keyword "pnat" = Tokens.PNAT
  | keyword "int" = Tokens.INT
  | keyword "lambda" = Tokens.LAMBDA
  | keyword "list" = Tokens.LIST
  | keyword "of" = Tokens.OF
  | keyword _ = raise Fail "keyword";

fun is_special s =
   let fun sub sin = substring sin handle Substring => ""
       val s2 = sub (s,0,2)
       and s10 = sub (s,0,10)
       and s1 = sub (s,0,1)
       and s3 = sub (s,0,3)
       and s6 = sub (s,0,6)
   in s2 = "/*" orelse s2 = "*/" orelse s2 = "u(" orelse s2 = "::" orelse
      s2 = "=>" orelse s10 = "proof_plan" orelse
      (s1 = "(" orelse s1 = "," orelse s1 = ")" orelse s1 = "." orelse
       s1 = "-" orelse s1 = "[" orelse s1 = "]" orelse s1 = "=" orelse
       s1 = ":" orelse s1 = "#" orelse s1 = "\\") orelse
      (s3 = "==>" orelse s3 = "<=>") orelse s6 = "{true}"
   end;

end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s0 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s1 =
"\005\005\005\005\005\005\005\005\005\055\057\005\055\005\005\005\
\\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\005\
\\055\005\005\054\005\005\005\005\053\052\050\005\049\048\047\045\
\\043\043\043\043\043\043\043\043\043\043\041\005\038\034\005\005\
\\005\032\032\032\032\032\032\032\032\032\032\032\032\032\032\032\
\\032\032\032\032\032\032\032\032\032\032\032\031\030\029\005\027\
\\005\012\012\012\012\012\012\012\012\012\012\012\012\012\012\012\
\\017\012\012\012\012\015\012\012\012\012\012\006\005\005\005\005\
\\005"
val s3 =
"\058\058\058\058\058\058\058\058\058\058\061\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\059\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\
\\058"
val s6 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\007\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s7 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\008\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s8 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\009\000\000\000\000\000\000\000\000\000\000\
\\000"
val s9 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\010\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s10 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\011\000\000\
\\000"
val s12 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\000\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\013\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\014\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\013\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\
\\000"
val s14 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\000\
\\000\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\
\\014\014\014\014\014\014\014\014\014\014\014\000\000\000\000\014\
\\000\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\
\\014\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\
\\000"
val s15 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\016\000\000\000\000\000\000\000\
\\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\000\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\013\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\014\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\013\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\
\\000"
val s17 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\000\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\013\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\014\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\013\
\\013\013\018\013\013\013\013\013\013\013\013\000\000\000\000\000\
\\000"
val s18 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\000\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\013\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\014\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\019\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\
\\000"
val s19 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\000\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\013\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\014\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\020\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\
\\000"
val s20 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\000\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\013\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\014\
\\000\013\013\013\013\013\021\013\013\013\013\013\013\013\013\013\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\
\\000"
val s21 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\000\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\013\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\022\
\\000\013\013\013\013\013\013\013\013\013\013\013\013\013\013\013\
\\013\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\
\\000"
val s22 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\000\
\\000\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\
\\014\014\014\014\014\014\014\014\014\014\014\000\000\000\000\014\
\\000\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\
\\023\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\
\\000"
val s23 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\000\
\\000\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\
\\014\014\014\014\014\014\014\014\014\014\014\000\000\000\000\014\
\\000\014\014\014\014\014\014\014\014\014\014\014\024\014\014\014\
\\014\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\
\\000"
val s24 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\000\
\\000\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\
\\014\014\014\014\014\014\014\014\014\014\014\000\000\000\000\014\
\\000\025\014\014\014\014\014\014\014\014\014\014\014\014\014\014\
\\014\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\
\\000"
val s25 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\000\
\\000\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\
\\014\014\014\014\014\014\014\014\014\014\014\000\000\000\000\014\
\\000\014\014\014\014\014\014\014\014\014\014\014\014\014\026\014\
\\014\014\014\014\014\014\014\014\014\014\014\000\000\000\000\000\
\\000"
val s27 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\028\028\028\028\028\028\028\028\028\028\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s32 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\033\033\033\033\033\033\033\033\033\033\033\033\033\033\033\
\\033\033\033\033\033\033\033\033\033\033\033\000\000\000\000\000\
\\000\033\033\033\033\033\033\033\033\033\033\033\033\033\033\033\
\\033\033\033\033\033\033\033\033\033\033\033\000\000\000\000\000\
\\000"
val s34 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\036\035\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s36 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\037\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s38 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\039\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s39 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\040\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s41 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\042\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s43 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\044\044\044\044\044\044\044\044\044\044\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s45 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\046\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s50 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\051\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s55 =
"\000\000\000\000\000\000\000\000\000\056\000\000\056\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\056\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s59 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\060\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
in Vector.vector
[{fin = [], trans = s0},
{fin = [], trans = s1},
{fin = [], trans = s1},
{fin = [], trans = s3},
{fin = [], trans = s3},
{fin = [(N 84)], trans = s0},
{fin = [(N 84)], trans = s6},
{fin = [], trans = s7},
{fin = [], trans = s8},
{fin = [], trans = s9},
{fin = [], trans = s10},
{fin = [(N 54)], trans = s0},
{fin = [(N 15),(N 82),(N 84)], trans = s12},
{fin = [(N 15),(N 82)], trans = s12},
{fin = [(N 82)], trans = s14},
{fin = [(N 15),(N 82),(N 84)], trans = s15},
{fin = [(N 47)], trans = s0},
{fin = [(N 15),(N 82),(N 84)], trans = s17},
{fin = [(N 15),(N 82)], trans = s18},
{fin = [(N 15),(N 82)], trans = s19},
{fin = [(N 15),(N 82)], trans = s20},
{fin = [(N 15),(N 82)], trans = s21},
{fin = [(N 82)], trans = s22},
{fin = [(N 82)], trans = s23},
{fin = [(N 82)], trans = s24},
{fin = [(N 82)], trans = s25},
{fin = [(N 26),(N 82)], trans = s14},
{fin = [(N 84)], trans = s27},
{fin = [(N 76)], trans = s27},
{fin = [(N 40),(N 84)], trans = s0},
{fin = [(N 72),(N 84)], trans = s0},
{fin = [(N 38),(N 84)], trans = s0},
{fin = [(N 15),(N 84)], trans = s32},
{fin = [(N 15)], trans = s32},
{fin = [(N 59),(N 84)], trans = s34},
{fin = [(N 68)], trans = s0},
{fin = [], trans = s36},
{fin = [(N 44)], trans = s0},
{fin = [(N 84)], trans = s38},
{fin = [], trans = s39},
{fin = [(N 65)], trans = s0},
{fin = [(N 61),(N 84)], trans = s41},
{fin = [(N 57)], trans = s0},
{fin = [(N 79),(N 84)], trans = s43},
{fin = [(N 79)], trans = s43},
{fin = [(N 84)], trans = s45},
{fin = [(N 9)], trans = s0},
{fin = [(N 34),(N 84)], trans = s0},
{fin = [(N 36),(N 84)], trans = s0},
{fin = [(N 30),(N 84)], trans = s0},
{fin = [(N 84)], trans = s50},
{fin = [(N 12)], trans = s0},
{fin = [(N 32),(N 84)], trans = s0},
{fin = [(N 28),(N 84)], trans = s0},
{fin = [(N 70),(N 84)], trans = s0},
{fin = [(N 4),(N 84)], trans = s55},
{fin = [(N 4)], trans = s55},
{fin = [(N 6)], trans = s0},
{fin = [(N 91)], trans = s0},
{fin = [(N 91)], trans = s59},
{fin = [(N 87)], trans = s0},
{fin = [(N 89)], trans = s0}]
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val COMMENT1 = STARTSTATE 3;
val INITIAL = STARTSTATE 1;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
	exception Reject	(* for implementing REJECT *)
end

val yylineno = ref 0

fun makeLexer yyinput = 
let 
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref 1		(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

	val REJECT = fn () => raise Internal.Reject

fun lex () : Internal.result =
let fun continue() = lex() in
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			val _ = yylineno :=
(fold (fn (x,r) => if x ="\n" then r+1 else r)
(explode yytext) (!yylineno))
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  12 => (error ("unmatched close comment",! yylineno,! yylineno); continue ())
| 15 => (keyword yytext (! yylineno,! yylineno) handle _ => REJECT ())
| 26 => (Tokens.PROOFUNDERPLAN (! yylineno,! yylineno))
| 28 => (Tokens.LPAREN (! yylineno,! yylineno))
| 30 => (Tokens.COMMA (! yylineno,! yylineno))
| 32 => (Tokens.RPAREN (! yylineno,! yylineno))
| 34 => (Tokens.DOT (! yylineno,! yylineno))
| 36 => (Tokens.MINUS (! yylineno,! yylineno))
| 38 => (Tokens.LBRACKET (! yylineno,! yylineno))
| 4 => (continue ())
| 40 => (Tokens.RBRACKET (! yylineno,! yylineno))
| 44 => (Tokens.EQ2GREAT (! yylineno,! yylineno))
| 47 => (Tokens.ULPAREN (! yylineno,! yylineno))
| 54 => (Tokens.LBRACETRUERBRACE (! yylineno,! yylineno))
| 57 => (Tokens.COLON2 (! yylineno,! yylineno))
| 59 => (Tokens.EQ (! yylineno,! yylineno))
| 6 => (continue ())
| 61 => (Tokens.COLON (! yylineno,! yylineno))
| 65 => (Tokens.LESSEQGREAT (! yylineno,! yylineno))
| 68 => (Tokens.EQGREAT (! yylineno,! yylineno))
| 70 => (Tokens.SHARP (! yylineno,! yylineno))
| 72 => (Tokens.BSLASH (! yylineno,! yylineno))
| 76 => (if is_special yytext
    then REJECT ()
    else Tokens.METAVAR (yytext,! yylineno,! yylineno))
| 79 => (if is_special yytext
    then REJECT ()
    else Tokens.NUMBER
            (LexSupport.integer_of_string yytext,! yylineno,! yylineno))
| 82 => (if is_special yytext
    then REJECT ()
    else Tokens.IDENTIFIER (yytext,! yylineno,! yylineno))
| 84 => (error ("ignoring bad character " ^ yytext,! yylineno,! yylineno);
    continue ())
| 87 => (YYBEGIN INITIAL; continue ())
| 89 => (continue ())
| 9 => (YYBEGIN COMMENT1;
    quotelevel := 1;
    quote := "";
    quotelineno := ! yylineno;
    continue ())
| 91 => (continue ())
| _ => raise Internal.LexerError

		) end handle Internal.Reject => action(i,acts::l))

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof ()
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = ordof(!yyb,l)
		val NewState = if NewChar<128 then ordof(trans,NewChar) else ordof(trans,128)
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
end
  in lex
  end
end
