structure Tokens = Tokens;

type pos = Integer.int;
type svalue = Tokens.svalue;
type ('a,'b) token = ('a,'b) Tokens.token;
type lexresult = (svalue,pos) token;

val eof = fn () => Tokens.EOF (0,0);
fun error (text,first:pos,last:pos) =
   let val f = makestring first
       and l = makestring last
       val location =
          if (first = 0)
          then ""
          else if (first = last)
               then ("Line " ^ f ^ ": ")
               else ("Lines " ^ f ^ "-" ^ l ^ ": ")
   in  output (std_out,location ^ text ^ "\n")
   end;
val quotelevel = ref 0;
val quote = ref "";
val quotelineno = ref 0;

fun keyword "external" = Tokens.EXTERNAL
  | keyword "induction" = Tokens.INDUCTION
  | keyword "generalise" = Tokens.GENERALISE
  | keyword "disjunction" = Tokens.DISJUNCTION
  | keyword "new" = Tokens.NEW
  | keyword "then" = Tokens.THEN
  | keyword "in" = Tokens.IN
  | keyword "conjecture" = Tokens.CONJECTURE
  | keyword "thm" = Tokens.THM
  | keyword "atom" = Tokens.ATOM
  | keyword "void" = Tokens.VOID
  | keyword "pnat" = Tokens.PNAT
  | keyword "int" = Tokens.INT
  | keyword "lambda" = Tokens.LAMBDA
  | keyword "list" = Tokens.LIST
  | keyword "of" = Tokens.OF
  | keyword _ = raise Fail "keyword";

fun is_special s =
   let fun sub sin = substring sin handle Substring => ""
       val s2 = sub (s,0,2)
       and s10 = sub (s,0,10)
       and s1 = sub (s,0,1)
       and s3 = sub (s,0,3)
       and s6 = sub (s,0,6)
   in s2 = "/*" orelse s2 = "*/" orelse s2 = "u(" orelse s2 = "::" orelse
      s2 = "=>" orelse s10 = "proof_plan" orelse
      (s1 = "(" orelse s1 = "," orelse s1 = ")" orelse s1 = "." orelse
       s1 = "-" orelse s1 = "[" orelse s1 = "]" orelse s1 = "=" orelse
       s1 = ":" orelse s1 = "#" orelse s1 = "\\") orelse
      (s3 = "==>" orelse s3 = "<=>") orelse s6 = "{true}"
   end;

%%

%s COMMENT1;
%reject
%count
%header (functor ClamLexFun (structure Tokens : Clam_TOKENS));
identifier = [a-z][a-zA-Z0-9_]*;
number = [0-9]+;
metavar = _[0-9]+;

%%

<INITIAL>([\ \t]|"\012")+ => (continue ());
<INITIAL>\n => (continue ());
<INITIAL>"/*" =>
   (YYBEGIN COMMENT1;
    quotelevel := 1;
    quote := "";
    quotelineno := ! yylineno;
    continue ());
<INITIAL>"*/" =>
   (error ("unmatched close comment",! yylineno,! yylineno); continue ());
<INITIAL>[A-Za-z]+ =>
   (keyword yytext (! yylineno,! yylineno) handle _ => REJECT ());
<INITIAL>"proof_plan" => (Tokens.PROOFUNDERPLAN (! yylineno,! yylineno));
<INITIAL>"(" => (Tokens.LPAREN (! yylineno,! yylineno));
<INITIAL>"," => (Tokens.COMMA (! yylineno,! yylineno));
<INITIAL>")" => (Tokens.RPAREN (! yylineno,! yylineno));
<INITIAL>"." => (Tokens.DOT (! yylineno,! yylineno));
<INITIAL>"-" => (Tokens.MINUS (! yylineno,! yylineno));
<INITIAL>"[" => (Tokens.LBRACKET (! yylineno,! yylineno));
<INITIAL>"]" => (Tokens.RBRACKET (! yylineno,! yylineno));
<INITIAL>"==>" => (Tokens.EQ2GREAT (! yylineno,! yylineno));
<INITIAL>"u(" => (Tokens.ULPAREN (! yylineno,! yylineno));
<INITIAL>"{true}" => (Tokens.LBRACETRUERBRACE (! yylineno,! yylineno));
<INITIAL>"::" => (Tokens.COLON2 (! yylineno,! yylineno));
<INITIAL>"=" => (Tokens.EQ (! yylineno,! yylineno));
<INITIAL>":" => (Tokens.COLON (! yylineno,! yylineno));
<INITIAL>"<=>" => (Tokens.LESSEQGREAT (! yylineno,! yylineno));
<INITIAL>"=>" => (Tokens.EQGREAT (! yylineno,! yylineno));
<INITIAL>"#" => (Tokens.SHARP (! yylineno,! yylineno));
<INITIAL>"\\" => (Tokens.BSLASH (! yylineno,! yylineno));
<INITIAL>{metavar} =>
   (if is_special yytext
    then REJECT ()
    else Tokens.METAVAR (yytext,! yylineno,! yylineno));
<INITIAL>{number} =>
   (if is_special yytext
    then REJECT ()
    else Tokens.NUMBER
            (LexSupport.integer_of_string yytext,! yylineno,! yylineno));
<INITIAL>{identifier} =>
   (if is_special yytext
    then REJECT ()
    else Tokens.IDENTIFIER (yytext,! yylineno,! yylineno));
<INITIAL>. =>
   (error ("ignoring bad character " ^ yytext,! yylineno,! yylineno);
    continue ());
<COMMENT1>"*/" => (YYBEGIN INITIAL; continue ());
<COMMENT1>\n => (continue ());
<COMMENT1>. => (continue ());
