structure ClamAST =
struct

datatype plan = Plan of goal * identifier * number * method * identifier
and method
   = External of argument * argument * external
   | Induction of argument * indvar list
   | Generalise of typ * typ
   | Disjunction of typ list
   | New of identifier list
   | MethodApp of identifier * argument list
   | Methods of method list
   | MethodThen of method * method
and indvar = InductionVariable of typ * typ
and argument
   = Method of method
   | Metavar of metavar
   | In
   | Connective of connective
   | NumList of number list
and external = Conjecture of typ | Thm of identifier
and goal = Goal of typ list * typ
and typ
   = Universe of number
   | Atom
   | Void
   | True
   | Pnat
   | Int
   | Number of number
   | Identifier of identifier
   | Apply of identifier * typ list
   | Lambda of identifier * typ
   | List of typ
   | FunApp of typ * typ
   | Cons of typ * typ
   | Eq of typ * typ * typ
   | Inhabit of identifier * typ
   | Prop of typ * connective * typ
withtype connective = String.string
and identifier = String.string
and number = Integer.int
and metavar = String.string;

end;
