/*
 * @(#)$Id: external.pl,v 1.1.2.3 1998/08/05 11:18:11 rjb Exp $
 *
 * $Log: external.pl,v $
 * Revision 1.1.2.3  1998/08/05 11:18:11  rjb
 * Added operation for deleting all external facts.
 *
 * Revision 1.1.2.2  1998/05/22 13:08:16  rjb
 * New method for external lemmas.
 * Corrected matching.
 * Added operation for deleting facts.
 *
 * Revision 1.1.2.1  1998/05/12 16:08:24  rjb
 * New methods for co-operating with external systems.
 *
 */

/* external_fact(?Name,?Type,?Formula,?Vars,?Matrix)
 */
:- dynamic external_fact/5.

/* new_external_fact/3
 *
 * new_external_fact(+Name,+Type,+Formula)
 */
new_external_fact(Name,Type,Formula):-
    \+ external_fact(Name,_,_,_,_),
    matrix(Vars,Matrix,Formula),
    asserta(external_fact(Name,Type,Formula,Vars,Matrix)).

/* delete_external_fact/1
 */
delete_external_fact(Name):-
    retract(external_fact(Name,_,_,_,_)).

/* delete_all_external_facts/0
 */
delete_all_external_facts:-
    retractall(external_fact(_,_,_,_,_)).

/* find_external_fact(+Instance,?Name,?Type,?Formula).
 */
find_external_fact(Instance,Name,Type,Formula):-
    matrix(_,InstanceMatrix,Instance),
    external_fact(Name,Type,Formula,Vars,Matrix),
    match_term(Matrix,InstanceMatrix,Binding),
    check_binding(Vars,Binding).

/* check_binding/2.
 *
 * Non-universally quantified variables in the pattern must match to an
 * identical object in the target.
 */
check_binding(_,[]).
check_binding(Vars,[X-X|Binding]):-
    !, check_binding(Vars,Binding).
check_binding(Vars,[X-_|Binding]):-
    member(X:_,Vars),
    !, check_binding(Vars,Binding).

/* external/3.
 */
external(_H,G,thm(Name)):-
    find_external_fact(G,Name,proved,_).
external(_H,G,conjecture(G)):-
    \+ find_external_fact(G,_,_,_).

/* external_condition/3.
 */
external_condition(decidable(hol),_H,G):-
    hol_presburger_formula(G).
external_condition(fail,_,_):-   % Failure made explicit for clarity.
    !, fail.


hol_presburger_formula(_:_=>F):-
    hol_presburger_formula(F).
hol_presburger_formula(F1#F2):-
    hol_presburger_formula(F1),
    hol_presburger_formula(F2).
hol_presburger_formula(F1\F2):-
    hol_presburger_formula(F1),
    hol_presburger_formula(F2).
hol_presburger_formula(F=>void):-
    hol_presburger_formula(F).
hol_presburger_formula(F1=>F2):-
    hol_presburger_formula(F1),
    hol_presburger_formula(F2).
hol_presburger_formula(F1<=>F2):-
    hol_presburger_formula(F1),
    hol_presburger_formula(F2).
hol_presburger_formula(T1=T2 in holnum):-
    hol_presburger_term(T1),
    hol_presburger_term(T2).
hol_presburger_formula(holLESS(T1,T2)):-
    hol_presburger_term(T1),
    hol_presburger_term(T2).
hol_presburger_formula(holLESSEQ(T1,T2)):-
    hol_presburger_term(T1),
    hol_presburger_term(T2).
hol_presburger_formula(holGREAT(T1,T2)):-
    hol_presburger_term(T1),
    hol_presburger_term(T2).
hol_presburger_formula(holGREATEQ(T1,T2)):-
    hol_presburger_term(T1),
    hol_presburger_term(T2).
hol_presburger_formula({true}).
hol_presburger_formula(void).

hol_presburger_term(holSUC(T)):-
    hol_presburger_term(T).
hol_presburger_term(holPRE(T)):-
    hol_presburger_term(T).
hol_presburger_term(holPLUS(T1,T2)):-
    hol_presburger_term(T1),
    hol_presburger_term(T2).
hol_presburger_term(holMINUS(T1,T2)):-
    hol_presburger_term(T1),
    hol_presburger_term(T2).
hol_presburger_term(holTIMES(T1,T2)):-
    hol_presburger_const_struct(T1),
    hol_presburger_term(T2).
hol_presburger_term(holTIMES(T1,T2)):-
    hol_presburger_term(T1),
    hol_presburger_const_struct(T2).
hol_presburger_term(T):-
    atom(T).

hol_presburger_const_struct(T):-
    hol_num_const(T).
hol_presburger_const_struct(holSUC(T)):-
    hol_presburger_const_struct(T).
hol_presburger_const_struct(holPRE(T)):-
    hol_presburger_const_struct(T).
hol_presburger_const_struct(holPLUS(T1,T2)):-
    hol_presburger_const_struct(T1),
    hol_presburger_const_struct(T2).
hol_presburger_const_struct(holMINUS(T1,T2)):-
    hol_presburger_const_struct(T1),
    hol_presburger_const_struct(T2).
hol_presburger_const_struct(holTIMES(T1,T2)):-
    hol_presburger_const_struct(T1),
    hol_presburger_const_struct(T2).

hol_num_const(T):-
    atom(T),
    atom_chars(T,[104,111,108|Cs]),
    number_chars(N,Cs),
    number(N).
