(*---------------------------------------------------------------------------*
 * Database for the CPE.                                                     *
 *---------------------------------------------------------------------------*)
structure dBase =
struct

local open boolTheory 
           pairTheory 
           numTheory
           prim_recTheory
           arithmeticTheory
           listTheory
           optionTheory
           sumTheory
           oneTheory
           combinTheory
           TCTheory
           primWFTheory
           WFTheory
in
 val boss_thms = Binaryset.addList
    (Binaryset.empty 
      (fn ((s1,(_:thm*string)),(s2,_)) => String.compare(s1,s2)),

[("LEFT_FORALL_OR_THM", (LEFT_FORALL_OR_THM, "boolTheory")),
("FALSITY", (FALSITY, "boolTheory")),
("TYPE_DEFINITION", (TYPE_DEFINITION, "boolTheory")),
("RIGHT_FORALL_IMP_THM", (RIGHT_FORALL_IMP_THM, "boolTheory")),
("LEFT_EXISTS_IMP_THM", (LEFT_EXISTS_IMP_THM, "boolTheory")),
("BOOL_CASES_AX", (BOOL_CASES_AX, "boolTheory")),
("OR_INTRO_THM1", (OR_INTRO_THM1, "boolTheory")),
("EQ_EXPAND", (EQ_EXPAND, "boolTheory")),
("OR_INTRO_THM2", (OR_INTRO_THM2, "boolTheory")),
("ARB_DEF", (ARB_DEF, "boolTheory")),
("DISJ_ASSOC", (DISJ_ASSOC, "boolTheory")),
("BOOL_EQ_DISTINCT", (BOOL_EQ_DISTINCT, "boolTheory")),
("SELECT_AX", (SELECT_AX, "boolTheory")),
("LEFT_AND_OVER_OR", (LEFT_AND_OVER_OR, "boolTheory")),
("IMP_F_EQ_F", (IMP_F_EQ_F, "boolTheory")),
("COND_DEF", (COND_DEF, "boolTheory")),
("LEFT_OR_OVER_AND", (LEFT_OR_OVER_AND, "boolTheory")),
("EXISTS_SIMP", (EXISTS_SIMP, "boolTheory")),
("EQ_CLAUSES", (EQ_CLAUSES, "boolTheory")),
("EXISTS_OR_THM", (EXISTS_OR_THM, "boolTheory")),
("BOTH_FORALL_IMP_THM", (BOTH_FORALL_IMP_THM, "boolTheory")),
("COND_CLAUSES", (COND_CLAUSES, "boolTheory")),
("F_DEF", (F_DEF, "boolTheory")),
("LEFT_EXISTS_AND_THM", (LEFT_EXISTS_AND_THM, "boolTheory")),
("ETA_THM", (ETA_THM, "boolTheory")),
("EQ_SYM", (EQ_SYM, "boolTheory")),
("AND_IMP_INTRO", (AND_IMP_INTRO, "boolTheory")),
("ABS_REP_THM", (ABS_REP_THM, "boolTheory")),
("FORALL_AND_THM", (FORALL_AND_THM, "boolTheory")),
("COND_ABS", (COND_ABS, "boolTheory")),
("RIGHT_FORALL_OR_THM", (RIGHT_FORALL_OR_THM, "boolTheory")),
("ONTO_DEF", (ONTO_DEF, "boolTheory")),
("COND_ID", (COND_ID, "boolTheory")),
("T_DEF", (T_DEF, "boolTheory")),
("AND_INTRO_THM", (AND_INTRO_THM, "boolTheory")),
("BOTH_EXISTS_IMP_THM", (BOTH_EXISTS_IMP_THM, "boolTheory")),
("DISJ_SYM", (DISJ_SYM, "boolTheory")),
("ETA_AX", (ETA_AX, "boolTheory")),
("AND1_THM", (AND1_THM, "boolTheory")),
("COND_EXPAND", (COND_EXPAND, "boolTheory")),
("OR_DEF", (OR_DEF, "boolTheory")),
("RIGHT_AND_OVER_OR", (RIGHT_AND_OVER_OR, "boolTheory")),
("RIGHT_OR_OVER_AND", (RIGHT_OR_OVER_AND, "boolTheory")),
("LET_DEF", (LET_DEF, "boolTheory")),
("RIGHT_EXISTS_IMP_THM", (RIGHT_EXISTS_IMP_THM, "boolTheory")),
("FORALL_DEF", (FORALL_DEF, "boolTheory")),
("EXCLUDED_MIDDLE", (EXCLUDED_MIDDLE, "boolTheory")),
("SELECT_REFL", (SELECT_REFL, "boolTheory")),
("SELECT_UNIQUE", (SELECT_UNIQUE, "boolTheory")),
("EQ_IMP_THM", (EQ_IMP_THM, "boolTheory")),
("REFL_CLAUSE", (REFL_CLAUSE, "boolTheory")),
("LEFT_AND_FORALL_THM", (LEFT_AND_FORALL_THM, "boolTheory")),
("NOT_IMP", (NOT_IMP, "boolTheory")),
("AND_DEF", (AND_DEF, "boolTheory")),
("RIGHT_OR_EXISTS_THM", (RIGHT_OR_EXISTS_THM, "boolTheory")),
("OR_ELIM_THM", (OR_ELIM_THM, "boolTheory")),
("EXISTS_DEF", (EXISTS_DEF, "boolTheory")),
("EXISTS_UNIQUE_DEF", (EXISTS_UNIQUE_DEF, "boolTheory")),
("LEFT_FORALL_IMP_THM", (LEFT_FORALL_IMP_THM, "boolTheory")),
("NOT_CLAUSES", (NOT_CLAUSES, "boolTheory")),
("OR_CLAUSES", (OR_CLAUSES, "boolTheory")),
("EQ_TRANS", (EQ_TRANS, "boolTheory")),
("IMP_ANTISYM_AX", (IMP_ANTISYM_AX, "boolTheory")),
("IMP_DISJ_THM", (IMP_DISJ_THM, "boolTheory")),
("IMP_CLAUSES", (IMP_CLAUSES, "boolTheory")),
("RIGHT_EXISTS_AND_THM", (RIGHT_EXISTS_AND_THM, "boolTheory")),
("OR_IMP_THM", (OR_IMP_THM, "boolTheory")),
("DE_MORGAN_THM", (DE_MORGAN_THM, "boolTheory")),
("ONE_ONE_DEF", (ONE_ONE_DEF, "boolTheory")),
("BETA_THM", (BETA_THM, "boolTheory")),
("NOT_FORALL_THM", (NOT_FORALL_THM, "boolTheory")),
("bool_case_DEF", (bool_case_DEF, "boolTheory")),
("IMP_F", (IMP_F, "boolTheory")),
("BOTH_EXISTS_AND_THM", (BOTH_EXISTS_AND_THM, "boolTheory")),
("NOT_DEF", (NOT_DEF, "boolTheory")),
("ABS_SIMP", (ABS_SIMP, "boolTheory")),
("AND2_THM", (AND2_THM, "boolTheory")),
("NOT_EXISTS_THM", (NOT_EXISTS_THM, "boolTheory")),
("FORALL_SIMP", (FORALL_SIMP, "boolTheory")),
("EQ_REFL", (EQ_REFL, "boolTheory")),
("BOTH_FORALL_OR_THM", (BOTH_FORALL_OR_THM, "boolTheory")),
("AND_CLAUSES", (AND_CLAUSES, "boolTheory")),
("EQ_EXT", (EQ_EXT, "boolTheory")),
("NOT_F", (NOT_F, "boolTheory")),
("CONJ_SYM", (CONJ_SYM, "boolTheory")),
("EQ_SYM_EQ", (EQ_SYM_EQ, "boolTheory")),
("F_IMP", (F_IMP, "boolTheory")),
("COND_RAND", (COND_RAND, "boolTheory")),
("TRUTH", (TRUTH, "boolTheory")),
("CONJ_ASSOC", (CONJ_ASSOC, "boolTheory")),
("RIGHT_AND_FORALL_THM", (RIGHT_AND_FORALL_THM, "boolTheory")),
("INFINITY_AX", (INFINITY_AX, "boolTheory")),
("NOT_AND", (NOT_AND, "boolTheory")),
("LEFT_OR_EXISTS_THM", (LEFT_OR_EXISTS_THM, "boolTheory")),
("COND_RATOR", (COND_RATOR, "boolTheory")),

("FORALL_PROD", (FORALL_PROD, "pairTheory")),
("PAIR_EQ", (PAIR_EQ, "pairTheory")),
("PAIR", (PAIR, "pairTheory")),
("EXISTS_PROD", (EXISTS_PROD, "pairTheory")),
("MK_PAIR_DEF", (MK_PAIR_DEF, "pairTheory")),
("pair_Axiom", (pair_Axiom, "pairTheory")),
("prod_TY_DEF", (prod_TY_DEF, "pairTheory")),
("COMMA_DEF", (COMMA_DEF, "pairTheory")),
("CURRY_UNCURRY_THM", (CURRY_UNCURRY_THM, "pairTheory")),
("CURRY_ONE_ONE_THM", (CURRY_ONE_ONE_THM, "pairTheory")),
("SND", (SND, "pairTheory")),
("FST", (FST, "pairTheory")),
("SND_DEF", (SND_DEF, "pairTheory")),
("PEXISTS_THM", (PEXISTS_THM, "pairTheory")),
("UNCURRY_CURRY_THM", (UNCURRY_CURRY_THM, "pairTheory")),
("UNCURRY_VAR", (UNCURRY_VAR, "pairTheory")),
("ABS_PAIR_THM", (ABS_PAIR_THM, "pairTheory")),
("PFORALL_THM", (PFORALL_THM, "pairTheory")),
("IS_PAIR_DEF", (IS_PAIR_DEF, "pairTheory")),
("ABS_REP_prod", (ABS_REP_prod, "pairTheory")),
("UNCURRY_ONE_ONE_THM", (UNCURRY_ONE_ONE_THM, "pairTheory")),
("CLOSED_PAIR_EQ", (CLOSED_PAIR_EQ, "pairTheory")),
("UNCURRY_DEF", (UNCURRY_DEF, "pairTheory")),
("FST_DEF", (FST_DEF, "pairTheory")),
("CURRY_DEF", (CURRY_DEF, "pairTheory")),

("num_TY_DEF", (num_TY_DEF, "numTheory")),
("SUC_DEF", (SUC_DEF, "numTheory")),
("num_ISO_DEF", (num_ISO_DEF, "numTheory")),
("NOT_SUC", (NOT_SUC, "numTheory")),
("ZERO_DEF", (ZERO_DEF, "numTheory")),
("INV_SUC", (INV_SUC, "numTheory")),
("INDUCTION", (INDUCTION, "numTheory")),
("IS_NUM_REP", (IS_NUM_REP, "numTheory")),
("SUC_REP_DEF", (SUC_REP_DEF, "numTheory")),
("ZERO_REP_DEF", (ZERO_REP_DEF, "numTheory")),

("LESS_REFL", (LESS_REFL, "prim_recTheory")),
("SIMP_REC_EXISTS", (SIMP_REC_EXISTS, "prim_recTheory")),
("SIMP_REC_FUN", (SIMP_REC_FUN, "prim_recTheory")),
("SUC_LESS", (SUC_LESS, "prim_recTheory")),
("SIMP_REC_REL", (SIMP_REC_REL, "prim_recTheory")),
("PRIM_REC_THM", (PRIM_REC_THM, "prim_recTheory")),
("SIMP_REC", (SIMP_REC, "prim_recTheory")),
("SUC_ID", (SUC_ID, "prim_recTheory")),
("LESS_0", (LESS_0, "prim_recTheory")),
("LESS_THM", (LESS_THM, "prim_recTheory")),
("EQ_LESS", (EQ_LESS, "prim_recTheory")),
("LESS_LEMMA1", (LESS_LEMMA1, "prim_recTheory")),
("PRIM_REC", (PRIM_REC, "prim_recTheory")),
("PRIM_REC_EQN", (PRIM_REC_EQN, "prim_recTheory")),
("SIMP_REC_THM", (SIMP_REC_THM, "prim_recTheory")),
("LESS_LEMMA2", (LESS_LEMMA2, "prim_recTheory")),
("NOT_LESS_0", (NOT_LESS_0, "prim_recTheory")),
("LESS_DEF", (LESS_DEF, "prim_recTheory")),
("SIMP_REC_FUN_LEMMA", (SIMP_REC_FUN_LEMMA, "prim_recTheory")),
("PRE", (PRE, "prim_recTheory")),
("INV_SUC_EQ", (INV_SUC_EQ, "prim_recTheory")),
("PRE_DEF", (PRE_DEF, "prim_recTheory")),
("NOT_LESS_EQ", (NOT_LESS_EQ, "prim_recTheory")),
("LESS_0_0", (LESS_0_0, "prim_recTheory")),
("num_Axiom", (num_Axiom, "prim_recTheory")),
("LESS_MONO", (LESS_MONO, "prim_recTheory")),
("DC", (DC, "prim_recTheory")),
("LESS_SUC", (LESS_SUC, "prim_recTheory")),
("LESS_SUC_IMP", (LESS_SUC_IMP, "prim_recTheory")),
("LESS_SUC_REFL", (LESS_SUC_REFL, "prim_recTheory")),
("PRIM_REC_FUN", (PRIM_REC_FUN, "prim_recTheory")),
("LESS_NOT_EQ", (LESS_NOT_EQ, "prim_recTheory")),
("LESS_SUC_SUC", (LESS_SUC_SUC, "prim_recTheory")),

("ADD1", (ADD1, "arithmeticTheory")),
("ADD_EQ_0", (ADD_EQ_0, "arithmeticTheory")),
("FACT", (FACT, "arithmeticTheory")),
("MOD_ONE", (MOD_ONE, "arithmeticTheory")),
("ODD_DOUBLE", (ODD_DOUBLE, "arithmeticTheory")),
("SUC_ONE_ADD", (SUC_ONE_ADD, "arithmeticTheory")),
("LESS_TRANS", (LESS_TRANS, "arithmeticTheory")),
("ODD_EVEN", (ODD_EVEN, "arithmeticTheory")),
("SUB_RIGHT_LESS_EQ", (SUB_RIGHT_LESS_EQ, "arithmeticTheory")),
("LESS_EQ_CASES", (LESS_EQ_CASES, "arithmeticTheory")),
("LESS_EQ_EXISTS", (LESS_EQ_EXISTS, "arithmeticTheory")),
("NOT_EXP_0", (NOT_EXP_0, "arithmeticTheory")),
("LESS_EQ_ADD_SUB", (LESS_EQ_ADD_SUB, "arithmeticTheory")),
("LESS_EQ_SUB_LESS", (LESS_EQ_SUB_LESS, "arithmeticTheory")),
("LESS_MONO_ADD_EQ", (LESS_MONO_ADD_EQ, "arithmeticTheory")),
("SUB_RIGHT_LESS", (SUB_RIGHT_LESS, "arithmeticTheory")),
("LESS_EQ", (LESS_EQ, "arithmeticTheory")),
("MOD_MOD", (MOD_MOD, "arithmeticTheory")),
("DA", (DA, "arithmeticTheory")),
("ADD_MONO_LESS_EQ", (ADD_MONO_LESS_EQ, "arithmeticTheory")),
("LESS_ANTISYM", (LESS_ANTISYM, "arithmeticTheory")),
("LESS_MONO_REV", (LESS_MONO_REV, "arithmeticTheory")),
("MOD_UNIQUE", (MOD_UNIQUE, "arithmeticTheory")),
("MULT_0", (MULT_0, "arithmeticTheory")),
("MULT_LEFT_1", (MULT_LEFT_1, "arithmeticTheory")),
("SUC_ADD_SYM", (SUC_ADD_SYM, "arithmeticTheory")),
("SUB_RIGHT_GREATER", (SUB_RIGHT_GREATER, "arithmeticTheory")),
("SUB_LEFT_LESS_EQ", (SUB_LEFT_LESS_EQ, "arithmeticTheory")),
("FUN_EQ_LEMMA", (FUN_EQ_LEMMA, "arithmeticTheory")),
("LESS_CASES_IMP", (LESS_CASES_IMP, "arithmeticTheory")),
("LESS_EQ_LESS_TRANS", (LESS_EQ_LESS_TRANS, "arithmeticTheory")),
("LESS_MOD", (LESS_MOD, "arithmeticTheory")),
("LESS_MONO_ADD", (LESS_MONO_ADD, "arithmeticTheory")),
("LESS_MONO_MULT", (LESS_MONO_MULT, "arithmeticTheory")),
("MULT_EQ_0", (MULT_EQ_0, "arithmeticTheory")),
("ADD_CLAUSES", (ADD_CLAUSES, "arithmeticTheory")),
("MULT_EQ_1", (MULT_EQ_1, "arithmeticTheory")),
("SUB_ADD", (SUB_ADD, "arithmeticTheory")),
("SUB_LESS_0", (SUB_LESS_0, "arithmeticTheory")),
("GREATER_OR_EQ", (GREATER_OR_EQ, "arithmeticTheory")),
("EVEN_OR_ODD", (EVEN_OR_ODD, "arithmeticTheory")),
("DIV_UNIQUE", (DIV_UNIQUE, "arithmeticTheory")),
("LESS_ADD", (LESS_ADD, "arithmeticTheory")),
("DIV_LESS_EQ", (DIV_LESS_EQ, "arithmeticTheory")),
("EVEN_ODD_EXISTS", (EVEN_ODD_EXISTS, "arithmeticTheory")),
("LESS_CASES", (LESS_CASES, "arithmeticTheory")),
("NOT_NUM_EQ", (NOT_NUM_EQ, "arithmeticTheory")),
("SUB_SUB", (SUB_SUB, "arithmeticTheory")),
("LESS_ADD_1", (LESS_ADD_1, "arithmeticTheory")),
("SUB_0", (SUB_0, "arithmeticTheory")),
("MULT_SUC", (MULT_SUC, "arithmeticTheory")),
("NOT_SUC_LESS_EQ", (NOT_SUC_LESS_EQ, "arithmeticTheory")),
("ODD_ADD", (ODD_ADD, "arithmeticTheory")),
("SUB_LESS_EQ", (SUB_LESS_EQ, "arithmeticTheory")),
("ZERO_DIV", (ZERO_DIV, "arithmeticTheory")),
("SUB_LEFT_EQ", (SUB_LEFT_EQ, "arithmeticTheory")),
("SUB_LEFT_GREATER", (SUB_LEFT_GREATER, "arithmeticTheory")),
("SUB_RIGHT_EQ", (SUB_RIGHT_EQ, "arithmeticTheory")),
("ADD_ASSOC", (ADD_ASSOC, "arithmeticTheory")),
("MOD_EQ_0", (MOD_EQ_0, "arithmeticTheory")),
("MULT_SUC_EQ", (MULT_SUC_EQ, "arithmeticTheory")),
("EVEN_ADD", (EVEN_ADD, "arithmeticTheory")),
("LE", (LE, "arithmeticTheory")),
("ZERO_LESS_EQ", (ZERO_LESS_EQ, "arithmeticTheory")),
("MULT", (MULT, "arithmeticTheory")),
("LESS_EQ_LESS_EQ_MONO", (LESS_EQ_LESS_EQ_MONO, "arithmeticTheory")),
("MOD_PLUS", (MOD_PLUS, "arithmeticTheory")),
("LESS_OR_EQ_ADD", (LESS_OR_EQ_ADD, "arithmeticTheory")),
("SUB_LEFT_GREATER_EQ", (SUB_LEFT_GREATER_EQ, "arithmeticTheory")),
("LESS_MULT2", (LESS_MULT2, "arithmeticTheory")),
("NOT_SUC_ADD_LESS_EQ", (NOT_SUC_ADD_LESS_EQ, "arithmeticTheory")),
("RIGHT_ADD_DISTRIB", (RIGHT_ADD_DISTRIB, "arithmeticTheory")),
("ZERO_MOD", (ZERO_MOD, "arithmeticTheory")),
("NOT_ODD_EQ_EVEN", (NOT_ODD_EQ_EVEN, "arithmeticTheory")),
("SUC_SUB1", (SUC_SUB1, "arithmeticTheory")),
("LESS_MONO_ADD_INV", (LESS_MONO_ADD_INV, "arithmeticTheory")),
("LEFT_ADD_DISTRIB", (LEFT_ADD_DISTRIB, "arithmeticTheory")),
("EVEN_EXISTS", (EVEN_EXISTS, "arithmeticTheory")),
("EQ_MONO_ADD_EQ", (EQ_MONO_ADD_EQ, "arithmeticTheory")),
("LESS_EQ_ANTISYM", (LESS_EQ_ANTISYM, "arithmeticTheory")),
("LESS_EQ_IMP_LESS_SUC", (LESS_EQ_IMP_LESS_SUC, "arithmeticTheory")),
("LESS_NOT_SUC", (LESS_NOT_SUC, "arithmeticTheory")),
("ADD_EQ_SUB", (ADD_EQ_SUB, "arithmeticTheory")),
("INV_PRE_EQ", (INV_PRE_EQ, "arithmeticTheory")),
("NOT_LESS", (NOT_LESS, "arithmeticTheory")),
("num_case_def", (num_case_def, "arithmeticTheory")),
("MULT_SYM", (MULT_SYM, "arithmeticTheory")),
("LESS_LESS_SUC", (LESS_LESS_SUC, "arithmeticTheory")),
("MULT_CLAUSES", (MULT_CLAUSES, "arithmeticTheory")),
("SUB_EQ_EQ_0", (SUB_EQ_EQ_0, "arithmeticTheory")),
("EVEN_ODD", (EVEN_ODD, "arithmeticTheory")),
("MULT_ASSOC", (MULT_ASSOC, "arithmeticTheory")),
("EXP", (EXP, "arithmeticTheory")),
("FACT_LESS", (FACT_LESS, "arithmeticTheory")),
("SUB_CANCEL", (SUB_CANCEL, "arithmeticTheory")),
("PRE_SUC_EQ", (PRE_SUC_EQ, "arithmeticTheory")),
("NOT_GREATER", (NOT_GREATER, "arithmeticTheory")),
("SUB_EQUAL_0", (SUB_EQUAL_0, "arithmeticTheory")),
("SUB_RIGHT_ADD", (SUB_RIGHT_ADD, "arithmeticTheory")),
("ADD_INV_0", (ADD_INV_0, "arithmeticTheory")),
("LESS_MONO_EQ", (LESS_MONO_EQ, "arithmeticTheory")),
("EXP_ADD", (EXP_ADD, "arithmeticTheory")),
("CANCEL_SUB", (CANCEL_SUB, "arithmeticTheory")),
("LESS_OR_EQ", (LESS_OR_EQ, "arithmeticTheory")),
("LESS_EQUAL_ADD", (LESS_EQUAL_ADD, "arithmeticTheory")),
("SUB_RIGHT_SUB", (SUB_RIGHT_SUB, "arithmeticTheory")),
("EVEN", (EVEN, "arithmeticTheory")),
("LESS_MULT_MONO", (LESS_MULT_MONO, "arithmeticTheory")),
("SUB_LESS_EQ_ADD", (SUB_LESS_EQ_ADD, "arithmeticTheory")),
("WOP", (WOP, "arithmeticTheory")),
("LEFT_SUB_DISTRIB", (LEFT_SUB_DISTRIB, "arithmeticTheory")),
("SUB_RIGHT_GREATER_EQ", (SUB_RIGHT_GREATER_EQ, "arithmeticTheory")),
("TIMES2", (TIMES2, "arithmeticTheory")),
("ADD_INV_0_EQ", (ADD_INV_0_EQ, "arithmeticTheory")),
("INV_PRE_LESS_EQ", (INV_PRE_LESS_EQ, "arithmeticTheory")),
("ADD", (ADD, "arithmeticTheory")),
("LESS_LESS_CASES", (LESS_LESS_CASES, "arithmeticTheory")),
("MULT_RIGHT_1", (MULT_RIGHT_1, "arithmeticTheory")),
("LESS_IMP_LESS_OR_EQ", (LESS_IMP_LESS_OR_EQ, "arithmeticTheory")),
("MULT_EXP_MONO", (MULT_EXP_MONO, "arithmeticTheory")),
("NOT_LEQ", (NOT_LEQ, "arithmeticTheory")),
("PRE_SUB1", (PRE_SUB1, "arithmeticTheory")),
("SUB_EQ_0", (SUB_EQ_0, "arithmeticTheory")),
("SUB_MONO_EQ", (SUB_MONO_EQ, "arithmeticTheory")),
("SUB", (SUB, "arithmeticTheory")),
("ADD_SUB", (ADD_SUB, "arithmeticTheory")),
("EVEN_DOUBLE", (EVEN_DOUBLE, "arithmeticTheory")),
("ADD_SUC", (ADD_SUC, "arithmeticTheory")),
("MOD_TIMES", (MOD_TIMES, "arithmeticTheory")),
("ODD_EXISTS", (ODD_EXISTS, "arithmeticTheory")),
("PRE_SUB", (PRE_SUB, "arithmeticTheory")),
("LESS_0_CASES", (LESS_0_CASES, "arithmeticTheory")),
("SUB_PLUS", (SUB_PLUS, "arithmeticTheory")),
("EQ_LESS_EQ", (EQ_LESS_EQ, "arithmeticTheory")),
("LESS_ADD_NONZERO", (LESS_ADD_NONZERO, "arithmeticTheory")),
("LESS_EQUAL_ANTISYM", (LESS_EQUAL_ANTISYM, "arithmeticTheory")),
("LESS_SUC_NOT", (LESS_SUC_NOT, "arithmeticTheory")),
("MULT_MONO_EQ", (MULT_MONO_EQ, "arithmeticTheory")),
("NOT_SUC_LESS_EQ_0", (NOT_SUC_LESS_EQ_0, "arithmeticTheory")),
("ODD_MULT", (ODD_MULT, "arithmeticTheory")),
("num_CASES", (num_CASES, "arithmeticTheory")),
("LESS_EQ_SUC_REFL", (LESS_EQ_SUC_REFL, "arithmeticTheory")),
("LESS_EXP_SUC_MONO", (LESS_EXP_SUC_MONO, "arithmeticTheory")),
("GREATER_EQ", (GREATER_EQ, "arithmeticTheory")),
("LESS_OR", (LESS_OR, "arithmeticTheory")),
("DIV_MULT", (DIV_MULT, "arithmeticTheory")),
("LESS_ADD_SUC", (LESS_ADD_SUC, "arithmeticTheory")),
("NOT_GREATER_EQ", (NOT_GREATER_EQ, "arithmeticTheory")),
("SUB_LEFT_ADD", (SUB_LEFT_ADD, "arithmeticTheory")),
("ODD", (ODD, "arithmeticTheory")),
("LESS_SUB_ADD_LESS", (LESS_SUB_ADD_LESS, "arithmeticTheory")),
("LESS_EQ_ADD", (LESS_EQ_ADD, "arithmeticTheory")),
("LESS_EQ_TRANS", (LESS_EQ_TRANS, "arithmeticTheory")),
("LESS_LESS_EQ_TRANS", (LESS_LESS_EQ_TRANS, "arithmeticTheory")),
("SUB_LEFT_SUB", (SUB_LEFT_SUB, "arithmeticTheory")),
("LESS_EQ_MONO_ADD_EQ", (LESS_EQ_MONO_ADD_EQ, "arithmeticTheory")),
("OR_LESS", (OR_LESS, "arithmeticTheory")),
("RIGHT_SUB_DISTRIB", (RIGHT_SUB_DISTRIB, "arithmeticTheory")),
("SUB_LEFT_SUC", (SUB_LEFT_SUC, "arithmeticTheory")),
("MOD_MULT", (MOD_MULT, "arithmeticTheory")),
("ZERO_LESS_EXP", (ZERO_LESS_EXP, "arithmeticTheory")),
("GREATER_DEF", (GREATER_DEF, "arithmeticTheory")),
("COMPLETE_INDUCTION", (COMPLETE_INDUCTION, "arithmeticTheory")),
("LESS_EQ_0", (LESS_EQ_0, "arithmeticTheory")),
("LESS_SUC_EQ_COR", (LESS_SUC_EQ_COR, "arithmeticTheory")),
("ODD_OR_EVEN", (ODD_OR_EVEN, "arithmeticTheory")),
("SUB_LEFT_LESS", (SUB_LEFT_LESS, "arithmeticTheory")),
("ADD_SYM", (ADD_SYM, "arithmeticTheory")),
("EVEN_MULT", (EVEN_MULT, "arithmeticTheory")),
("LESS_EQ_MONO", (LESS_EQ_MONO, "arithmeticTheory")),
("LESS_EQ_REFL", (LESS_EQ_REFL, "arithmeticTheory")),
("SUB_LESS_OR", (SUB_LESS_OR, "arithmeticTheory")),
("INV_PRE_LESS", (INV_PRE_LESS, "arithmeticTheory")),
("LESS_IMP_LESS_ADD", (LESS_IMP_LESS_ADD, "arithmeticTheory")),
("NOT_LESS_EQUAL", (NOT_LESS_EQUAL, "arithmeticTheory")),
("SUC_NOT", (SUC_NOT, "arithmeticTheory")),
("DIVISION", (DIVISION, "arithmeticTheory")),
("MULT_LESS_EQ_SUC", (MULT_LESS_EQ_SUC, "arithmeticTheory")),
("EVEN_AND_ODD", (EVEN_AND_ODD, "arithmeticTheory")),
("ADD_0", (ADD_0, "arithmeticTheory")),

("HD", (HD, "listTheory")),
("EVERY_CONJ", (EVERY_CONJ, "listTheory")),
("LENGTH_EQ_NIL", (LENGTH_EQ_NIL, "listTheory")),
("NOT_CONS_NIL", (NOT_CONS_NIL, "listTheory")),
("MAP2", (MAP2, "listTheory")),
("EVERY_EL", (EVERY_EL, "listTheory")),
("LENGTH_NIL", (LENGTH_NIL, "listTheory")),
("NOT_EQ_LIST", (NOT_EQ_LIST, "listTheory")),
("EVERY_DEF", (EVERY_DEF, "listTheory")),
("list_ISO_DEF", (list_ISO_DEF, "listTheory")),
("CONS_DEF", (CONS_DEF, "listTheory")),
("NULL_DEF", (NULL_DEF, "listTheory")),
("LENGTH", (LENGTH, "listTheory")),
("APPEND_NIL", (APPEND_NIL, "listTheory")),
("list_Axiom", (list_Axiom, "listTheory")),
("SUM", (SUM, "listTheory")),
("list_CASES", (list_CASES, "listTheory")),
("MAP_APPEND", (MAP_APPEND, "listTheory")),
("NOT_NIL_CONS", (NOT_NIL_CONS, "listTheory")),
("list_case_def", (list_case_def, "listTheory")),
("FLAT", (FLAT, "listTheory")),
("LENGTH_MAP", (LENGTH_MAP, "listTheory")),
("list_size", (list_size, "listTheory")),
("LIST_NOT_EQ", (LIST_NOT_EQ, "listTheory")),
("list_INDUCT", (list_INDUCT, "listTheory")),
("EL", (EL, "listTheory")),
("IS_list_REP", (IS_list_REP, "listTheory")),
("CONS", (CONS, "listTheory")),
("NIL_DEF", (NIL_DEF, "listTheory")),
("APPEND_ASSOC", (APPEND_ASSOC, "listTheory")),
("EQ_LIST", (EQ_LIST, "listTheory")),
("APPEND_eq_NIL", (APPEND_eq_NIL, "listTheory")),
("LENGTH_EQ_CONS", (LENGTH_EQ_CONS, "listTheory")),
("list_TY_DEF", (list_TY_DEF, "listTheory")),
("CONS_11", (CONS_11, "listTheory")),
("MAP", (MAP, "listTheory")),
("TL", (TL, "listTheory")),
("APPEND", (APPEND, "listTheory")),
("LENGTH_CONS", (LENGTH_CONS, "listTheory")),
("LENGTH_APPEND", (LENGTH_APPEND, "listTheory")),
("NULL", (NULL, "listTheory")),
("CONS_ACYCLIC", (CONS_ACYCLIC, "listTheory")),


("NOT_NONE_SOME", (NOT_NONE_SOME, "optionTheory")),
("IS_SOME_DEF", (IS_SOME_DEF, "optionTheory")),
("SOME_DEF", (SOME_DEF, "optionTheory")),
("IS_NONE_DEF", (IS_NONE_DEF, "optionTheory")),
("option_Axiom", (option_Axiom, "optionTheory")),
("THE_DEF", (THE_DEF, "optionTheory")),
("NONE_DEF", (NONE_DEF, "optionTheory")),
("option_CASE_DEF", (option_CASE_DEF, "optionTheory")),
("option_REP_ABS_DEF", (option_REP_ABS_DEF, "optionTheory")),
("option_APPLY_DEF", (option_APPLY_DEF, "optionTheory")),
("option_TY_DEF", (option_TY_DEF, "optionTheory")),
("option_CASES", (option_CASES, "optionTheory")),
("option_Induct", (option_Induct, "optionTheory")),
("SOME_11", (SOME_11, "optionTheory")),
("NOT_SOME_NONE", (NOT_SOME_NONE, "optionTheory")),
("option_CLAUSES", (option_CLAUSES, "optionTheory")),


("I_o_ID", (I_o_ID, "combinTheory")),
("S_DEF", (S_DEF, "combinTheory")),
("K_THM", (K_THM, "combinTheory")),
("I_THM", (I_THM, "combinTheory")),
("o_DEF", (o_DEF, "combinTheory")),
("K_DEF", (K_DEF, "combinTheory")),
("S_THM", (S_THM, "combinTheory")),
("I_DEF", (I_DEF, "combinTheory")),
("o_ASSOC", (o_ASSOC, "combinTheory")),
("o_THM", (o_THM, "combinTheory")),

("sum_ISO_DEF", (sum_ISO_DEF, "sumTheory")),
("INR", (INR, "sumTheory")),
("sum_TY_DEF", (sum_TY_DEF, "sumTheory")),
("ISL_OR_ISR", (ISL_OR_ISR, "sumTheory")),
("ISL", (ISL, "sumTheory")),
("INR_DEF", (INR_DEF, "sumTheory")),
("OUTL", (OUTL, "sumTheory")),
("sum_Axiom", (sum_Axiom, "sumTheory")),
("ISR", (ISR, "sumTheory")),
("INL_DEF", (INL_DEF, "sumTheory")),
("INL", (INL, "sumTheory")),
("sum_axiom", (sum_axiom, "sumTheory")),
("IS_SUM_REP", (IS_SUM_REP, "sumTheory")),
("OUTR", (OUTR, "sumTheory")),

("one", (one, "oneTheory")),
("one_DEF", (one_DEF, "oneTheory")),
("one_Axiom", (one_Axiom, "oneTheory")),
("one_axiom", (one_axiom, "oneTheory")),
("one_TY_DEF", (one_TY_DEF, "oneTheory")),

("TC_DEF", (TC_DEF, "TCTheory")),
("transitive_def", (transitive_def, "TCTheory")),
("TC_INDUCT", (TC_INDUCT, "TCTheory")),
("TC_TRANSITIVE", (TC_TRANSITIVE, "TCTheory")),
("TC_SUBSET", (TC_SUBSET, "TCTheory")),
("TC_CASES1", (TC_CASES1, "TCTheory")),
("TC_CASES2", (TC_CASES2, "TCTheory")),

("WF_NOT_REFL", (WF_NOT_REFL, "primWFTheory")),
("WF_RPROD", (WF_RPROD, "primWFTheory")),
("WFREC_THM", (WFREC_THM, "primWFTheory")),
("WF_INDUCTION_THM", (WF_INDUCTION_THM, "primWFTheory")),
("WF_TC", (WF_TC, "primWFTheory")),
("RESTRICT_LEMMA", (RESTRICT_LEMMA, "primWFTheory")),
("RPROD_DEF", (RPROD_DEF, "primWFTheory")),
("WFREC_DEF", (WFREC_DEF, "primWFTheory")),
("WF_Empty", (WF_Empty, "primWFTheory")),
("WFREC_COROLLARY", (WFREC_COROLLARY, "primWFTheory")),
("LEX_DEF", (LEX_DEF, "primWFTheory")),
("WF_SUBSET", (WF_SUBSET, "primWFTheory")),
("inv_image_def", (inv_image_def, "primWFTheory")),
("RESTRICT_DEF", (RESTRICT_DEF, "primWFTheory")),
("WF_DEF", (WF_DEF, "primWFTheory")),
("WF_POLY", (WF_POLY, "primWFTheory")),
("approx_def", (approx_def, "primWFTheory")),
("WF_LEX", (WF_LEX, "primWFTheory")),
("the_fun_def", (the_fun_def, "primWFTheory")),
("Empty_def", (Empty_def, "primWFTheory")),
("WF_inv_image", (WF_inv_image, "primWFTheory")),
("WF_RECURSION_THM", (WF_RECURSION_THM, "primWFTheory")),

("WF_IFF_WELLFOUNDED", (WF_IFF_WELLFOUNDED, "WFTheory")),
("WF_LESS", (WF_LESS, "WFTheory")),
("wellfounded_def", (wellfounded_def, "WFTheory")),
("WF_PRED", (WF_PRED, "WFTheory")),
("measure_def", (measure_def, "WFTheory")),
("WF_measure", (WF_measure, "WFTheory")),
("WF_LIST_PRED", (WF_LIST_PRED, "WFTheory"))])
end

end;
