signature SocketUtils =
sig

  val createUnixServer
    : {archOS:string, HOLDIR:string}
        -> string -> int  (* command and rounds of probing *)
         -> (Socket.pf_file, Socket.active Socket.stream)Socket.socket
            * string 

  val createInetServer
    : {archOS:string, HOLDIR:string}
        -> string          (* command *)
         -> string -> int  (* Inet address and port number *)
          -> int           (* rounds of probing *)
           -> (Socket.pf_inet, Socket.active Socket.stream)Socket.socket

  val findInetServer 
    : string -> int 
        -> (Socket.pf_inet, Socket.active Socket.stream)Socket.socket

  val findUnixServer 
    : string 
        -> (Socket.pf_file, Socket.active Socket.stream)Socket.socket

  val serialMonogamist
    : (('a, Socket.active Socket.stream) Socket.socket -> bool ref -> unit)
       -> ('a, Socket.passive Socket.stream) Socket.socket * 'a Socket.sock_addr
        -> unit

  val sendString 
    : ('a, Socket.active Socket.stream)Socket.socket -> string -> unit

  val readString 
    : ('a, Socket.active Socket.stream)Socket.socket -> int * string

  val sendRqt
    : ('a, Socket.active Socket.stream)Socket.socket 
       -> 'a frag list -> string Utils.result

  val ask 
    : ('a, Socket.active Socket.stream)Socket.socket 
       -> unit frag list -> unit

  val end_client 
    : ('a, Socket.active Socket.stream)Socket.socket -> unit -> unit

  val rel_client 
    : ('a, Socket.active Socket.stream)Socket.socket -> unit -> unit
end
