(*---------------------------------------------------------------------------*
 * A Unix domain prototype of the Core Proof Engine. Start it with the       *
 * Unix invocation                                                           *
 *                                                                           *
 *    ./CPEunix <file> > /dev/null &                                         *
 *                                                                           *
 * Note that the shell variables `archOS' and `HOLDIR' should be set before  *
 * making the invocation. A reasonable value for the first can be obtained   *
 * via invoking <holdir>/tools/archOS, where <holdir> is the absolute path   *
 * to the Hol98 distribution. The second should simply be <holdir>.          *
 *                                                                           *
 * Example.                                                                  *
 *         archOS=x86-linux                                                  *
 *         HOLDIR=/home/kxs/hol98                                            *
 *         ./CPEunix /tmp/foo > /dev/null &                                  *
 *                                                                           *
 * See ./test for a simple example of how to start CPEunix from MoscowML.    *
 *---------------------------------------------------------------------------*)

open Utils;
infix after;

fun run file =
  let val serversock = Socket.fileStream ()
      val addr = Socket.fileAddr file
  in
     SocketUtils.serialMonogamist
            ServeOnce.handleClient (serversock,addr)
  end;

fun cleanup s = Process.system ("/bin/rm -f "^s);

val _ = 
  case CommandLine.arguments() 
   of [file] => ((cleanup after run) file; succeeded())
    |  _     => (stdOutput "Usage: CPEunix <file>\n"; failed())
