fun fileclient file s =
    let val sock = Socket.fileStream ()
	val addr = Socket.fileAddr file
	val vec  = Byte.stringToBytes s
	
	val _    = Socket.connect(sock, addr)
    in
	Socket.sendVec (sock, vec); 
	print(Byte.bytesToString(Socket.recvVec (sock, size s)));
	Socket.close sock 
    end
 

fun fileserver file =
    let val sock = Socket.fileStream ()
	val addr = Socket.fileAddr file
	val _    = Socket.bind(sock, addr)
	val c    = ref 5;
    in
	while !c > 0 do
	    let val _  = Socket.listen(sock, 150);
		val (n,a) = Socket.accept sock
		val vec = Socket.recvVec(n,255)
		val ls = Word8Vector.foldl op:: nil vec
		val s  = String.implode (map Byte.byteToChar ls)
	    in
		print (Byte.bytesToString vec^"\n");
		Socket.sendVec(n,Byte.stringToBytes s);
		Socket.close n;
		c := !c - 1
	    end;
	Socket.close sock
    end

fun inetclient ipno port s =
    let val sock = Socket.inetStream ()
	val addr = Socket.inetAddr ipno port
	val vec  = Byte.stringToBytes s
	
	val _    = Socket.connect(sock, addr)
    in
	Socket.sendVec (sock, vec); 
	print(Byte.bytesToString(Socket.recvVec (sock, size s)));
	Socket.close sock
    end
 

fun inetserver ipno port =
    let val sock = Socket.inetStream ()
	val addr = Socket.inetAddr ipno port
	val _    = Socket.bind(sock, addr)
	val _    = Socket.listen(sock, 150);
	val c    = ref 3;
    in
	((while !c > 0 do
	    let
		val (n,a) = Socket.accept sock
		val vec = Socket.recvVec(n,20)
		val ls = Word8Vector.foldl op:: nil vec
		val s   = String.implode (map Byte.byteToChar ls)
	    in
		print (Byte.bytesToString vec^"\n");
		Socket.sendVec(n,Byte.stringToBytes s);
		Socket.close n;
		c := !c - 1
	    end)
	    handle Interrupt => ());
	Socket.close sock
    end

fun revmsg from =
    let val (sock,a) = Socket.accept from
	val vec = Socket.recvVec(sock,20)
	val ls = Word8Vector.foldl op:: nil vec
	val s   = String.implode (map Byte.byteToChar ls)
    in
	print ("Server: "^Byte.bytesToString vec^"\n");
	Socket.sendVec(sock,Byte.stringToBytes s);
	Socket.close sock
    end

fun selinet ipno port1 port2 =
    let val sock1 = Socket.inetStream ()
	val sock2 = Socket.inetStream ()
	val addr1 = Socket.inetAddr ipno port1
	val addr2 = Socket.inetAddr ipno port2
	val _    = Socket.bind(sock1, addr1)
	val _    = Socket.bind(sock2, addr2)
	val _    = Socket.listen(sock1, 150);
	val _    = Socket.listen(sock2, 150);
	val rls  = [sock1, sock2]
    in 
	((while true do
	    let val (rds, _, _) = Socket.select rls nil nil NONE
	    in  app revmsg rds
	    end) handle _ => ());
	Socket.close sock1;
	Socket.close sock2
    end




