 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File: winlabel.tcl
#
# Description:
#	Procedure to extract a label to identify a window.

 # winlabel.tcl,v 1.1.1.1 1994/12/07 10:17:31 donald Exp
 # /homes/drs1004/repository/tkaux/winlabel.tcl,v
 # winlabel.tcl,v
# Revision 1.1.1.1  1994/12/07  10:17:31  donald
# First import after some small chanegs.
#
 # Revision 1.10  1994/10/27  18:29:42  kennykb
 # Release 2.0 -- 10-27-94.  To be uploaded to archive sites.
 #
 # Revision 1.9  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.8  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.7  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.6  1993/10/20  19:06:24  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.5  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.4  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.3  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.2  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.1  1993/06/03  15:34:30  kennykb
 # Initial revision
 #

# Procedure:	winlabel
#
# Synopsis:
#	Get a label by which to identify a window.
#
# Usage:
#c	winlabel pathName
#
# Parameters:
#c	pathName
#		Path name of a widget.
#
# Return value:
#	Name by which the widget may be identified in messages.
#
# Description:
#	`winlabel' finds a label by which a widget may be identified.
#	If the widget is the `entry' component of a labeled entry, the
#	label is returned.  Otherwise, the widget's name is returned.
#
# Bugs:
#	This really should be generalized, so that a widget can define its
#	own name.

proc winlabel w {
	set p [winfo parent $w]
	if {[winfo class $p] == "Labeledentry"} {
		if [winfo exists $p.head] {
			return [lindex [$p.head config -text] 4]
		}
	}
	return [winfo name $w]
}
