 #########################################################################
 #                                                                       #
 # Copyright (C) 1993, 1994 by General Electric Company.		 #
 # All rights reserved. 						 #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File:	setQ.tcl
#
# Description:
#	Conditional `set' command

 # setQ.tcl,v 1.1.1.1 1994/12/07 10:17:30 donald Exp
 # /homes/drs1004/repository/tkaux/setQ.tcl,v
 # setQ.tcl,v
# Revision 1.1.1.1  1994/12/07  10:17:30  donald
# First import after some small chanegs.
#
 # Revision 1.12  1994/10/27  18:29:42  kennykb
 # Release 2.0 -- 10-27-94.  To be uploaded to archive sites.
 #
 # Revision 1.11  1994/10/27  18:27:39  kennykb
 # Updated legal notices prior to release.
 #
 # Revision 1.10  1994/03/18  15:59:39  kennykb
 # Fixed typo that caused the variable to be set irrespective of
 # whether it existed.
 #
 # Revision 1.9  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.8  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.7  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.6  1993/10/20  19:04:11  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.5  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.4  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.3  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.2  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.1  1993/06/03  15:31:41  kennykb
 # Initial revision
 #

# Procedure:	set?
#
# Synopsis:
#	Conditional `set' command.
#
# Usage:
#c	set? variableName value
#
# Parameters:
#c	variableName
#		Name of a variable to set
#c	value
#		New content for the variable
#
# Return value:
#	New content of the variable.
#
# Description:
#	`set?' sets the content of a variable conditionally.  It doesn't
#	actually try to set the variable unless the desired content is
#	different from what's already there.  In this way, it avoids firing
#	`write' traces on the variable if the content hasn't changed.  This
#	can be a big performance win for variables whose content is displayed
#	in widgets.  It can also be used to avoid using a trace to set
#	a `file modified' flag.

proc set? {variable content} {
	upvar 1 $variable old
	if {![info exists old] || [string compare $content $old] != 0} {
		uplevel 1 set $variable [list $content]
	}
	return $content
}
