 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File: gensym.tcl

# Description:
#	File containing procedures for the management of generated symbols

# Global variables:
#c	gensym_priv(name)
#		Current index in list of generated symbols coded with `name'

 # gensym.tcl,v 1.1.1.1 1994/12/07 10:17:29 donald Exp
 # /homes/drs1004/repository/tkaux/gensym.tcl,v
 # gensym.tcl,v
# Revision 1.1.1.1  1994/12/07  10:17:29  donald
# First import after some small chanegs.
#
 # Revision 1.10  1994/10/27  18:29:42  kennykb
 # Release 2.0 -- 10-27-94.  To be uploaded to archive sites.
 #
 # Revision 1.9  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.8  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.7  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.6  1993/10/20  18:46:26  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.5  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.4  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.3  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.2  1993/07/20  19:17:12  kennykb
 # Improved structured comments.
 # Changed modules through `g' in the alphabet to follow `:' and `_' naming
 # conventions.
 #
 # Revision 1.1  1993/06/03  15:29:17  kennykb
 # Initial revision
 #

# Procedure:	gensym
#
# Synopsis:
#	Create a generated symbol.
#
# Usage:
#c	gensym ?series?
#
# Parameters:
#c	series
#		There may be several series of generated symbols, named with
#		unique strings.  The series parameter is the unique name that
#		selects a given series.  Default is `G'
#
# Return value:
#	Unique generated symbol in the given series
#
# Description:
#	`gensym' generates unique names for objects.

proc gensym {{name G}} {
	global gensym_priv
	if {[info exists gensym_priv($name)]} {
		incr gensym_priv($name)
	} else {
		set gensym_priv($name) 0
	}
	return [format "%s%05d" $name $gensym_priv($name)]
}

# Procedure:	gensym_dump
#
# Synopsis:
#	Dump the origin of generated symbols to a file.
#
# Usage:
#c	gensym_dump ?fileId ?series??
#
# Parameters:
#c	file
#		File identifier where gensym counter is to be saved.
#		May be the result of `open', or one of the standard
#		identifiers `stdout' or `stderr'.  Default is `stdout'.
#c	series
#		Series of generated symbols.
#
# Return value:
#	None
#
# Description:
#	gensym_dump saves the origin of a series of generated symbols to a
#	file.  The file may later be loaded using the `source' command, and
#	the generated symbol counter will be restored.

proc gensym_dump {{file stdout} {name G}} {
	global gensym_priv
	if {[info exists gensym_priv($name)]} {
		puts $file "gensym:set $name $gensym_priv($name)"
	}
}

# Procedure:	gensym:set
#
# Synopsis:
#	Internal procedure to set the origin of a series of generated symbols.
#
# Usage:
#c	gensym:set ?series ?value??
#
# Parameters:
#c	series
#		Series of generated symbols
#c	value
#		Value of the symbol counter.  Default is 0
#
# Return value:
#	New value of the symbol counter.
#
# Description:
#	gensym:set sets a symbol counter to the specified value.  It is
#	used to reload a counter in a file written by gensym_dump.

proc gensym:set {name {value 0}} {
	global gensym_priv
	set gensym_priv($name) $value
}

	# The gensym_set alias is present for upward compatibility with an
	# earlier version of gensym.tcl

proc gensym_set {name {value 0}} [info body gensym:set]
proc gensym.set {name {value 0}} [info body gensym_set]
