 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File:	checkint.tcl
#
# Description:
#	Procedure to verify that an entry box contains an integer.

 # checkint.tcl,v 1.1.1.1 1994/12/07 10:17:28 donald Exp
 # /homes/drs1004/repository/tkaux/checkint.tcl,v
 # checkint.tcl,v
# Revision 1.1.1.1  1994/12/07  10:17:28  donald
# First import after some small chanegs.
#
 # Revision 1.12  1994/10/27  18:29:42  kennykb
 # Release 2.0 -- 10-27-94.  To be uploaded to archive sites.
 #
 # Revision 1.11  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.10  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.9  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.8  1993/10/20  18:39:37  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.7  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.6  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.5  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.4  1993/10/14  13:25:44  kennykb
 # Added a `-predicate' flag to allow for restrictions on the integer's value.
 #
 # Revision 1.3  1993/07/19  19:54:28  kennykb
 # Cleaned up structured comments
 #
 # Revision 1.2  1993/07/16  15:58:00  kennykb
 # Renamed all commands that start with `wiget.' to either `widget_' or
 # `widget:'.  Added the code for creating composite widgets.
 #
 # Revision 1.1  1993/06/03  15:25:19  kennykb
 # Initial revision
 #

# Procedure:	checkInteger
#
# Synopsis:
#	Verify that an entry widget contains an integer.
#
# Usage:
#c	checkInteger pathName ?predicate?
#
# Parameters:
#c	pathName
#		Path name of an entry box.
#c	predicate
#		Expression giving additional constraints on the window's
#		content.  The window's content is expected to be in the
#		variable, `$content'.
#
# Results:
#	None.
#
# Description:
#	checkInteger checks that an entry box contains an integer.  It
#	does nothing if it does, and throws an error with an appropriate
#	message if it doesn't.
#
#	If a predicate is supplied, checkInteger also verifies that it
#	is true, and returns an error otherwise.
#
# Notes:
#	checkInteger is intended to be used as a validation procedure
#	with the widget_bind command.
#
# Example:
#c	widget_addBinding $w Validate "checkInteger $w"

proc checkInteger {w {predicate {1}}} {
	set content [$w get]
	if [catch {format "%d" $content} message] {
		global errorInfo
		if [string match "syntax error*" $message] {
			set message "expected an integer, found ``$content''"
		} 
		error $message $errorInfo
	}
	if {![expr $predicate]} {
		error "constraint failed, $content does not satisfy $predicate"
	}
}
