#############################################################################
#   ParentsFrame.tcl,v 1.15 1995/04/04 16:39:22 drs1004 Exp
#    Copyright (C) 1994  Donald Syme
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Contact Details:
#	Donald Syme
#	The Computer Laboratory
#	New Musuems Site
#	Pembroke St.
#	Cambridge U.K. CB2 3QG
#
#	email: Donald.Syme@cl.cam.ac.uk
#
#############################################################################

#----------------------------------------------------------------------------
#
# WIDGET CLASS ParentsFrame
#
# A widget showing the hierarchy of parents to the current theory.
# The widget automaically tracks changes to the current theory and
# the theory hierarchy.  It also supports a selection of theories.
#
# Options
#	All hierarchy options.
#
# Commands
#	ParentsFrame::configure widget [option value ...]
#		Configure the widget.
#
#	ParentsFrame::setselection widget [theory ...]
#		Set the selection to the given set of theories.
#		If multiple selection is off, this should be a single theory.
#----------------------------------------------------------------------------


proc ParentsFrame { w args} {
	global vals
	global TkTheoryViewer_flags
	global TkTheoryViewer_library
	global gui_flags
	frame $w -class ParentsFrame -relief sunken

#	pack [frame $w.controls -relief sunken -borderwidth 2] -side left -fill y
#	pack [button $w.controls.expand1 -bitmap @$TkTheoryViewer_library/expand1.xbm -command "hierarchy::expandnoden $w.hier"]
#	pack [button $w.controls.expand3 -bitmap @$TkTheoryViewer_library/expand3.xbm -command "hierarchy::expandselection $w.hier"]

	frame $w.box
	pack $w.box -expand yes -fill both -side left

	hierarchy $w.hier \
		-font "-Adobe-Helvetica-Bold-R-Normal--*-100-*"   \
		-expand 1 \
		-rootnode [ML current_theory()] \
		-rootanchor $TkTheoryViewer_flags(theoryTreeAnchor) \
		-debug 0 \
		-xscroll "$w.horiz set" \
		-yscroll "$w.vert set" \
		-padstack 10 \
		-paddepth 16 \
		-relief sunken \
		-commonselect 1 \
		-nodechildren "ParentsFrame::nodechildren $w"\
		-nodelook "ParentsFrame::nodelook $w"

	pack $w.hier -ipady 10 -ipadx 10 -in $w.box -side top -expand yes -fill both
	eval [list ParentsFrame::configure $w] $args
	
	
	scrollbar $w.horiz -orient hor -command "$w.hier.canv xview" -relief sunken
	scrollbar $w.vert -orient vert -command "$w.hier.canv yview" -relief sunken
	pack $w.horiz -in $w.box -side bottom -fill x
	pack $w.vert -side $gui_flags(scrollbarSide) -fill y

	hierarchy::expandnoden $w.hier [ML "current_theory()"] $TkTheoryViewer_flags(theoryTreeInitialExpand) -prune $TkTheoryViewer_flags(theoriesToPrune)
        if [hol88] {
	    ML -type void "current_theory_add_tcl_client ([ml_string ParentsFrame],[ml_string $w])"
	}
	if [hol90] {
	    ML -type void "TclCurrentTheoryNotification.add_client \n(TclCurrentTheoryNotification.mk_client([ml_string ParentsFrame],\n[ml_string $w]))"
	}
	widget_addBinding $w Destroy "ParentsFrame::upon_destroy $w"	
	trace variable TkTheoryViewer_flags(theoryTreeAnchor) w "ParentsFrame::anchor_change_notify $w"
	
}

				      

proc ParentsFrame::nodelook { w node_path showing_kids } {
	global hierarchy_library 
	set theory [lindex $node_path [expr [llength $node_path]-1]]
	set bitmap @$hierarchy_library/folder.xbm
	set textFill black
	set bitmapColor black
	return [list $theory $textFill {} $bitmap $bitmapColor] 
}


proc ParentsFrame::nodechildren { w node_path } {
	global TkTheoryViewer_flags
	set theory [lindex $node_path [expr [llength $node_path]-1]]
#	puts "In ParentsFrame::nodechildren, node_path = $node_path"
        if {[lsearch $TkTheoryViewer_flags(theoriesToFlatten) $theory]==-1} {
	    set parents [ML -type stringlist "parents [ml_string $theory]"]
	} else {
	    set parents [ML -type stringlist "[hol_ancestors] [ml_string $theory]"]
	}
	# Filter the parents to only show starter-theories if they
	# are the only parent theory, since they are rarely "real" parents.
	#
	# Also check for duplicated parents in the parent list (yes.. this
	# can happen, at least in hol88!)

	if {[llength $parents]!=1} {
		set new_parents ""
	        foreach parent $parents {
		    if {[lsearch $TkTheoryViewer_flags(theoriesToIgnore) $parent]==-1 && [lsearch $new_parents $parent]==-1} { 
			lappend new_parents $parent 
		    }
	        }
	        set parents $new_parents
	}
#	puts "Leaving ParentsFrame::nodechildren, node_path = $node_path, parents = $parents"
	return [lsort $parents]
}

proc ParentsFrame::upon_destroy { w } {
	unset_vals_for_widget $w
	global TkTheoryViewer_flags
        if [hol88] {
	    ML -type void "current_theory_remove_tcl_client ([ml_string ParentsFrame],[ml_string $w])"
	}
	if [hol90] {
	    ML -type void "TclCurrentTheoryNotification.remove_client \n(TclCurrentTheoryNotification.mk_client([ml_string ParentsFrame],\n[ml_string $w]))"
	}
	trace vdelete TkTheoryViewer_flags(theoryTreeAnchor) w "ParentsFrame::anchor_change_notify $w"
}

proc ParentsFrame::configure { w args} {
	global vals
	set passon_args $args
	if {[llength $passon_args]!=0} {
	    eval [list hierarchy::configure $w.hier] $passon_args
	}
}


proc ParentsFrame::setselection { w args} {
	eval [list hierarchy::setselection $w.hier] $args
}


proc ParentsFrame::anchor_change_notify { w args } {
	global TkTheoryViewer_flags
	hierarchy::configure $w.hier  -rootanchor $TkTheoryViewer_flags(theoryTreeAnchor)
}

#----------------------------------------------------------------------------
#  current_theory_change_Notify
#
# Called when the logical structure of the theory hierarchy changes.
# We force a redraw of the theory hierarchy to make sure all changes
# are reflected.  Unfortunately this will not maintain the same nodes
# open as before, but it is difficult to fix this.
#
#----------------------------------------------------------------------------



proc ParentsFrame::remake_hierarchy { w  } {
	global vals
	global TkTheoryViewer_flags
	set selection [hierarchy::selection $w.hier]
	hierarchy::configure $w.hier -rootnode [ML "current_theory()"]
	hierarchy::expandnoden $w.hier [ML "current_theory()"] $TkTheoryViewer_flags(theoryTreeInitialExpand) -prune $TkTheoryViewer_flags(theoriesToPrune)
	eval [list hierarchy::setselection $w.hier] $selection
}

proc ParentsFrame::current_theory_change_Notify { w new_current } {
	ParentsFrame::remake_hierarchy $w
}

proc ParentsFrame::current_theory_ancestry_change_Notify { w current } {
	ParentsFrame::remake_hierarchy $w
}


proc ParentsFrame::current_theory_mode_change_Notify { w newmode } {
}




