structure trs_lib :trs_lib_sig = 
struct

val trs_lib = 
   Library.new_library
         {name = "trs",
          doc = "Theorem Retrieval Library, by Richard Boulton, ported by Donald Syme",
          path = trs_lib_path,
          parents = [hol_lib],
          theories = [],
          code = [
		"extents.sig",
		"extents.sml",
		"sets.sig",
		"sets.sml",
		"struct.sig",
		"struct.sml",
		"name.sig",
		"name.sml",
		"matching.sig", 
		"matching.sml", 
		"sidecond.sig",
		"sidecond.sml",
		"search.sig",
		"search.sml",
		"user.sig",
		"user.sml"
	  ],
          help = [(trs_lib_path ^ "help/entries/"), (trs_lib_path ^ "help/internals/")],
          loaded = "fn () => ()"};
end;
