#############################################################################
#   InitialisePackage.tcl,v 1.6 1995/04/04 16:39:09 drs1004 Exp
#    Copyright (C) 1994  Donald Syme
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Contact Details:
#	Donald Syme
#	The Computer Laboratory
#	New Musuems Site
#	Pembroke St.
#	Cambridge U.K. CB2 3QG
#
#	email: Donald.Syme@cl.cam.ac.uk
#
#############################################################################



proc TkGoalProof::ProcessArgs { argc argv } {
	global TkGoalProof_flags
	global gui_flags

	if {[llength [info commands Preferences_Add]]==1} {

    	    Preferences_Add "TkGoalProof" " \
Options concerning TkGoalProof may be specified here." \
	 	[list \
		    [list TkGoalProof_flags(numberAssums) numberAssums \
			ON "Number Assumptions"  \
			"If this is true then the assumptions in the assumption list will be numbered." \
		    ] \
		    [list TkGoalProof_flags(assumptionOrdering) assumptionOrdering \
			[list CHOICE FirstOnTop FirstOnBottom] "Assumption Ordering"  \
			"This specifies whether the first assumption should be displayed at the top or the bottom of the assumption list." \
		    ] \
		    [list TkGoalProof_flags(automaticChangedTac) automaticChangedTac \
			ON "Automatic CHANGED_TAC"  \
			"If this option is set, applying a tactic which has no effect on the goal will be reported as an error (by wrapping the tactic in a CHANGED_TAC tactical)." \
		    ] \
		]
		


    	    Preferences_Add "User Specified Tactics" " \
Commonly used tactics may be specified \
here for inclusion in various $gui_flags(title) tools. \
Several groups of tactics may be specified.  Many common tactics \
built into the HOL system are specified by default.\n\
\nIf a tactic includes the text \"...\" then \
this indicates that the tactic should not be applied immediately \
when selected. \
In the case of TkGoalProof it will be inserted into the \"Next Tactic\" window to \
await possible further modification.  The \"...\" text will \
be removed and the cursor will be placed at this location \
within the tactic text." \
	 	[list \
		    [list TkGoalProof_flags(tactics1,title) tactics1Title \
			"Rewrite Tactics" "Common Tactics (1) Title" \
			"The title of the first list of commonly used tactics." \
		    ] \
		    [list TkGoalProof_flags(tactics1) tactics1 \
			[list LIST \
				{REWRITE_TAC [...]} \
				{ASM_REWRITE_TAC [...]} \
				{ONCE_REWRITE_TAC [...]} \
				{ONCE_ASM_REWRITE_TAC [...]} \
				{PURE_REWRITE_TAC [...]} \
				{PURE_ASM_REWRITE_TAC [...]} \
				{PURE_ONCE_REWRITE_TAC [...]} \
				{PURE_ONCE_ASM_REWRITE_TAC [...]} \
			] "Common Tactics (1)" "A list of commonly used tactics available for the user to specify. If the list is empty it will not appear in various tools." \
		    ] \
		    [list TkGoalProof_flags(tactics2,title) tactics2Title \
			"General Tactics" "Common Tactics (2) Title" \
			"The title of the second list of commonly used tactics." \
		    ] \
		    [list TkGoalProof_flags(tactics2) tactics2 \
			[list LIST \
				{ASM_CASES_TAC ...} \
				{ASSUME_TAC} \
				{BETA_TAC} \
				{CONJ_TAC} \
				{CONV_TAC ...} \
				{DISCH_TAC} \
				{DISJ_CASES_TAC ...} \
				{EQ_TAC ...} \
				{EXISTS_TAC ...} \
				{GEN_TAC} \
				{IMP_RES_TAC ...} \
				{MATCH_MP_TAC ...} \
				{CONV_TAC (DEPTH_CONV PAIRED_BETA_CONV)} \
				{STRIP_TAC} \
				{UNDISCH_TAC ...} \
			] "Common Tactics (2)" "A list of commonly used tactics available for the user to specify. If the list is empty it will not appear in various tools." \
		    ] \
		    [list TkGoalProof_flags(tactics3,title) tactics3Title \
			"Smart Tactics" "Common Tactics (3) Title" \
			"The title of the third list of commonly used tactics." \
		    ] \
		    [list TkGoalProof_flags(tactics3) userTactics3 \
			[list LIST \
				{SMART_ELIMINATE_TAC} \
				{SMART_VAR_ELIMINATE_TAC} \
				{SMART_TERM_ELIMINATE_TAC} \
				{SSMART_EXISTS_TAC} \
			] "Common Tactics (3)" "A list of commonly used tactics available for the user to specify. If the list is empty it will not appear in various tools." \
		    ] \
		    [list TkGoalProof_flags(tactics4,title) tactics4Title \
			"Tactics (4)" "Common Tactics (4) Title" \
			"The title of the fourth list of commonly used tactics." \
		    ] \
		    [list TkGoalProof_flags(tactics4) userTactics4 \
			[list LIST \
			] "Common Tactics (4)" "A list of commonly used tactics available for the user to specify. If the list is empty it will not appear in various tools." \
		    ] \
		]
		
		
    	    Preferences_Add "Tactic History" " \
The history of applied tactics may be viewed and \
edited here.  There is not alot of point in editing the \
actual list itself, although the other options may be useful." \
	 	[list \
		    [list TkGoalProof_flags(tactic_history,title) tacticHistoryTitle \
			"Tactic History" "Tactic History Title" \
			"The title of the tactic history list." \
		    ] \
		    [list TkGoalProof_flags(tactic_history,depth) tacticHistoryDepth \
			"40" "Tactic History Depth" \
			"The depth of the tactic history list." \
		    ] \
		    [list TkGoalProof_flags(tactic_history) tacticHistory \
			[list LIST \
			] "Tactic History" "The history of tactics applied through the user interface.  This gets changed dynamically by TkHolWorkbench." \
		    ] \
		]
		
		
		
    	    Preferences_Add "User Specified Conversions" " \
Commonly used conversions may be specified \
here for inclusion in various $gui_flags(title) tools. \
Several groups of conversions may be specified.  Many common conversions \
built into the HOL system are specified by default.  Some of these \
are not available unless the appropriate library has been loaded.\n\
\nIf a conversion includes the text \"...\" then \
this indicates that the conversion should not be applied immediately \
when selected. " \
	 	[list \
		    [list TkGoalProof_flags(conversions1,title) conversions1Title \
			"Conversions" "Common Conversions (1) Title" \
			"The title of the first list of commonly used conversions." \
		    ] \
		    [list TkGoalProof_flags(conversions1) conversions1 \
			[list LIST \
				{ADD_CONV} \
				{ARITH_CONV} \
				{BETA_CONV} \
				{FUN_EQ_CONV} \
				{let_CONV} \
				{list_EQ_CONV} \
				{num_EQ_CONV} \
				{PAIRED_BETA_CONV} \
				{REWRITE_CONV [...]} \
				{ONCE_REWRITE_CONV [...]} \
				{PURE_REWRITE_CONV [...]} \
				{PURE_ONCE_REWRITE_CONV [...]} \
			] "Common Conversions (1)" "A list of commonly accessed conversions, which the user may specify." \
		    ] \
		    [list TkGoalProof_flags(conversions2,title) conversions2Title \
			"Conversions (2)" "Common Conversions (2) Title" \
			"The title of the first list of commonly used conversions." \
		    ] \
		    [list TkGoalProof_flags(conversions2) conversions2 \
			[list LIST \
			] "Common Conversions (2)" "A list of commonly accessed conversions, which the user may specify. If the list is empty it will not appear in various tools." \
		    ] \
		]
		
		
    	    Preferences_Add "User Specified Tacticals" " \
Commonly used tacticals may be specified \
here for inclusion in various $gui_flags(title) tools. \
Several groups of tacticals may be specified.  Many common tacticals \
built into the HOL system are specified by default.\n\
\nIf a tactical includes the text \"...\" then \
this indicates that the tactical should not be applied immediately \
when selected. " \
	 	[list \
		    [list TkGoalProof_flags(tacticals1,title) tacticals1Title \
			"Tacticals" "Common Tacticals (1) Title" \
			"The title of the first list of commonly used tacticals." \
		    ] \
		    [list TkGoalProof_flags(tacticals1) tacticals1 \
			[list LIST \
				{INDUCT_THEN} \
				{REPEAT} \
				{THEN} \
				{TRY} \
			] "Common Tacticals (1)" "A list of commonly used tacticals, which the user may specify."\
		    ] \
		    [list TkGoalProof_flags(tacticals2,title) tacticals2Title \
			"General Tacticals" "Common Tacticals (2) Title" \
			"The title of the first list of commonly used tacticals." \
		    ] \
		    [list TkGoalProof_flags(tacticals2) tacticals2 \
			[list LIST \
			] "Common Tacticals (2)" "A list of commonly accessed tacticals, which the user may specify. If the list is empty it will not appear in various tools." \
		    ] \
	        ]
	     
		
    	    Preferences_Add "User Specified Rules" " \
Commonly used rules may be specified \
here for inclusion in various $gui_flags(title) tools. \
Several groups of rules may be specified.  Many common rules \
built into the HOL system are specified by default.\n\
\nIf a rule includes the text \"...\" then \
this indicates that the rule should not be applied immediately \
when selected. " \
	 	[list \
		    [list TkGoalProof_flags(rules1,title) rules1Title \
			"General Rules" "Common Rules (1) Title" \
			"The title of the first list of commonly used rules." \
		    ] \
		    [list TkGoalProof_flags(rules1) rules1 \
			[list LIST \
				{ISPECL [...]} \
				{GEN ...} \
				{GEN_ALL} \
				{GSYM ...} \
				{MATCH_MP ...} \
				{SPEC ...} \
				{SPEC_ALL} \
				{SPECL [...]} \
				{UNDISCH ...} \
			] "Common Rules (1)" "A list of commonly used rules, which the user may specify."\
		    ] \
		    [list TkGoalProof_flags(rules2,title) rules2Title \
			"General Rules" "Common Rules (2) Title" \
			"The title of the first list of commonly used rules." \
		    ] \
		    [list TkGoalProof_flags(rules2) rules2 \
			[list LIST \
			] "Common Rules (2)" "A list of commonly accessed rules, which the user may specify. If the list is empty it will not appear in various tools." \
		    ] \
	        ]
	     
    	}

}


