
#----------------------------------------------------------------------------
#
# PACKAGE SimplePackage
#
# 	A skeleton implementation of a GUI package.  This file exists
# 	to help you write your own packages to run with TkHol.
#
#	This file contains two things:
#	     	1. The necessary functions which 
#	 	make it a "package".  These functions get called
#		when the package is loaded and unloaded from the
#		system.
#
#		2. A Tk widget class, which creates a toplevel window.
#		This widget class is called SimpleWindow.  Other
#		examples of widget classes in TkHol are TkGoalProof
#		and TkTheoryViewer.
#
# LOADING THIS PACKAGE
#
# 	You may use this package immediately, though it won't do anything 
# 	very useful.  Simply run
#		tkholhelper \
#			-package ../SimplePackage \
#			-win SimpleWindow
#
# 	The first option tells TkHol helper to load the code of the package
# 	at startup.  
#
#	The second option tells it to create a window
# 	from the widget class "SimplePackage" at startup.
#
# 	You will probably want to make this an alias or a shell script.
# 	See the file
#		bin/tkholhelper
# 	for an example of a shell script.
#
# 	In future versions of TkHol it will be possible to load
# 	packages from the TkTheoryViewer.
#
# PACKAGE RELATED FUNCTIONS
#
#	As stated above, this file contains two things.  The first
#	is some functions which make it into a "package".  These are:
#
#		SimplePackage::ProcessArgs argc argv
#		SimplePackage::InitialisePackage
#		SimplePackage::ShutdownPackage
#
#	You will note these functions are commented out.  This
#	is because they do not *have* to be present, and are
# 	not needed if they don't do anything.
#
#	SimplePackage::ProcessArgs gets called at startup.
#	It is a good time to scan the command line arguments
#	for arguments relevant to this package, and to 
#	register lists of "preferences" or "options" with
#	the preferences package (which a;lways gets loaded
#	before this package).
#
#	SimplePackage::InitialisePackage gets called at startup
#	too, but after all the command line arguments have been
#	checked.  It is a good time to set any global variables used
#	by the pacakge, and to load any ML code the package needs.
#
# 	NOTE: The SimplePackage_library global variable is automatically
# 	defined and indicates where the root directory
# 	for the package is.
#
# 	NOTE: The best place to store package related flags is in the
#	global array SimplePackage_flags(...)
#
#----------------------------------------------------------------------------


#proc SimplePackage::ProcessArgs { argc argv } {
#	global SimplePackage_flags
#	set SimplePackage_flags(option1) 0
#	set SimplePackage_flags(option2) 0
#	for {set arg 0} {$arg < $argc} {incr arg} {
#	    switch -- [lindex $argv $arg] {
#		-option1 {
#			incr arg
#	        	set SimplePackage_flags(option1) [lindex $argv $arg] 
#		}
#		-option2 {
#			incr arg
#	        	set SimplePackage_flags(option2) [lindex $argv $arg] 
#		}
#	    }
#	}
#}

#proc SimplePackage::InitialisePackage { args } {
#       global SimplePackage_flags 
#	global SimplePackage_library
#}

#proc SimplePackage::ShutdownPackage { } {
#}



#----------------------------------------------------------------------------
#
# WIDGET CLASS SimpleWindow
#
# CONFIGURATION OPTIONS
#
# COMMANDS
#
# IMPLEMENTATION (GLOBAL VARIABLES)
#
#	vals($w,...) 
#		Used to store data about the widget.
#
#	busy 
#		Used as normal.  Increment to indicate
#		a cursor change to "watch", decrement after the
#		operation is complete.
#
#		Other parts of the application set a trace on this
#		variable and react when it is set.
#
#	feedback
#		Used to provide feedback to the user.  Set to a pair.
#		The first element should be empty or a window
#		identifier indicating a context.  The second should
#		be the text of the feedback itself.
#		
#		For example:
#			set feedback [list $w "Searching..."]
#
#		Other parts of the application set a trace on this
#		variable and react when it is set.
#
#	gui_flags
#		Various entries in this array are expected to have been
#		set by some external source.  These are:
#
#			gui_flags(font,buttons)
#			gui_flags(font,textentry)
#			gui_flags(font,codeentry)
#			gui_flags(font,listboxes)
#			gui_flags(title)
#
#		This widget will not be useable without these values
#		set.
#----------------------------------------------------------------------------

option add *SimpleWindow.withfeedback 1 widgetDefault
option add *SimpleWindow.option2 "" widgetDefault

proc SimpleWindow { w args } {
	global gui_flags 
	global SimpleWindow_flags
	global feedback
	global busy
	incr busy

	global vals

	for {set i 0} {$i<[llength $args]} {incr i} {
	    switch -- [lindex $args $i] -withfeedback {
	    	incr i
	    	set withfeedback [lindex $args $i]
	    } -option2 {
	    	incr i
	    	set vals($w,option2) [lindex $args $i]
	    } default {
	    	    error "unrecognized arg [lindex $args $i]"
	    }
	}

	toplevel $w -class SimpleWindow

	if ![info exists withfeedback] { set withfeedback [option get $w withfeedback WithFeedback] }
	if ![info exists option2] { set option2 [option get $w option2 Option2] }


	wm withdraw $w
	wm minsize $w 1 1
	wm title $w "Simple Window"
	
	set feedback [list {} "Creating SimpleWindow display..."]
	
	if {$withfeedback} {
	    fontcheck label $w.feedback \
		-height 1 \
		-width 40 \
		-anchor w \
		-relief sunken \
		-font $gui_flags(font,feedback)
	    pack $w.feedback -side bottom -expand no -fill x
	}

	pack [frame $w.controls -borderwidth 2] -side bottom
	pack [fontcheck focusable button $w.controls.ok \
		-command "SimpleWindow::ok $w" \
		-text "Ok" \
		-width 11 \
		-font $gui_flags(font,buttons)] \
	    -side left -fill x -padx 10 -pady 10

	pack [fontcheck focusable button $w.controls.help \
		-command "HolHelp::hol90_help syntax.html" \
		-text "Help" \
		-width 11 \
		-font $gui_flags(font,buttons)] \
	    -side left -fill x -padx 10 -pady 10
	    
	pack [fontcheck focusable button $w.controls.close \
		-command "destroy $w" \
		-text "Close" \
		-width 11 \
		-font $gui_flags(font,buttons)] \
	    -side left -fill x -padx 10 -pady 10
	
	pack [frame $w.options -width 200 -height 200 ] -side bottom
	
	
	bind $w <Destroy> "unset_vals_for_widget $w"

	update
	focus_goToFirst $w.controls
	button_setDefault $w.controls.ok

	wm deiconify $w
	tkwait visibility $w

	incr busy -1
	return $w
}


#----------------------------------------------------------------------------
# SimpleWindow::define
#
#----------------------------------------------------------------------------

proc SimpleWindow::ok { w  } {

	global feedback
	global busy
	global vals
	incr busy
	
	puts {You just press "Ok" in SimpleWindow $w}

	incr busy -1	

}



#----------------------------------------------------------------------------
#
#----------------------------------------------------------------------------

proc sw { } {
   after 1 {
   	source $SimpleWindow_library/SimpleWindow.tcl
   	newwin SimpleWindow
   }
}






















