#############################################################################
#   Utils.tcl,v 1.9 1995/03/01 11:32:02 drs1004 Exp
#    Copyright (C) 1994  Donald Syme
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Contact Details:
#	Donald Syme
#	The Computer Laboratory
#	New Musuems Site
#	Pembroke St.
#	Cambridge U.K. CB2 3QG
#
#	email: Donald.Syme@cl.cam.ac.uk
#
#############################################################################

#----------------------------------------------------------------------------
# Utils.tcl,v 1.9 1995/03/01 11:32:02 drs1004 Exp
#
#
#----------------------------------------------------------------------------


#----------------------------------------------------------------------------
# lremove
#
# Remove all occurences of the element from the list.
#----------------------------------------------------------------------------

proc lremove { l e } {
    set result ""
    foreach el $l {
        if {$el != $e}  { lappend  result $el }
    }
    return $result
}


proc unset_vals_for_widget { w } {
	global vals
	set searchid [array startsearch vals]
	set toremove ""
	while {[array anymore vals $searchid]} {
	    set elem [array nextelement vals $searchid]
	    if [string match $w,* $elem] {
		lappend toremove $elem
	    }
	}
	array donesearch vals $searchid
	foreach elem $toremove {
           unset vals($elem)
	}
}


proc search_pathlist {paths file} {
	foreach dir $paths {
	    if [file exists $dir/$file] {
	        return $dir/$file
	    }
	}
	error "search_pathlist failed"
}


proc fontcheck { args } {
	if [catch {eval $args} err] {
	    puts stderr "warning: $err"
	    return [eval $args [list -font fixed]]
	} else {
	    return $err
	}
}


#----------------------------------------------------------------------------
# GetString
#
# Prompt the user to type a string in.
#
# IMPLEMENTATION
#
# Pretty much a copy of dialog.tcl from the Tk library, with
# an entry field added.
#
# The code is pretty grotty to make it look nice, especially the button
# defaulting.  
#
# BUGS
#
# No keyboard binding with Tab keys is implemented
# either here or in dialog.tcl.
#
#----------------------------------------------------------------------------


proc GetString { w name label } {
	global got_string
	global gui_flags

	toplevel $w
	wm title $w $name

    	frame $w.top -relief raised -bd 1
    	pack $w.top -side top -fill both
    	frame $w.bot -relief raised -bd 1
    	pack $w.bot -side bottom -fill both


	fontcheck label $w.lab -text $label -anchor w -font $gui_flags(font,labels)
	pack $w.lab -side left -ipady 10 -fill y -expand yes -in $w.top

	fontcheck entry $w.get -width 30 -relief sunken -borderwidth 2 -font $gui_flags(font,textentry)
	pack $w.get -side right -fill x -in $w.top
	bind $w.get <Return> "$w.buttonok flash; set got_string \[list Ok \[$w.get get\]\]"

	fontcheck button $w.buttonok -text Ok -command "set got_string \[list Ok \[$w.get get\]\]" -font $gui_flags(font,buttons)
        frame $w.default -relief sunken -bd 1
        raise $w.buttonok $w.default
        pack $w.default -in $w.bot -side left -expand 1 -padx 3m -pady 2m
        pack $w.buttonok -in $w.default -padx 2m -pady 2m \
                    -ipadx 2m -ipady 1m
	fontcheck button $w.buttoncancel -text Cancel -command "set got_string \[list Cancel {}\]" -font $gui_flags(font,buttons)
	pack $w.buttoncancel  -in $w.bot -side left -expand 1 \
                    -padx 3m -pady 3m -ipadx 2m -ipady 1m


    # Straight from dialog.tcl...
    # 
    # Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
            - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
            - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w


	grab $w
	set oldfocus [focus]
	focus $w.get
	tkwait variable got_string
	focus $oldfocus
	destroy $w
	return $got_string
}
