#############################################################################
#   MakeMenus.tcl,v 1.4 1995/02/17 16:38:51 drs1004 Exp
#    Copyright (C) 1994  Donald Syme
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Contact Details:
#	Donald Syme
#	The Computer Laboratory
#	New Musuems Site
#	Pembroke St.
#	Cambridge U.K. CB2 3QG
#
#	email: Donald.Syme@cl.cam.ac.uk
#
#############################################################################

#----------------------------------------------------------------------------
# MakeMenus.tcl,v 1.4 1995/02/17 16:38:51 drs1004 Exp
#
# MakeMenus
#
#
# Utility to make a set of menus given a structure describing
# the menus.  To save endless lists of menu creation commands
# in widget code.  See TheoryEditor.tcl for example of how
# its called. 
#----------------------------------------------------------------------------


proc MakeMenus { w menus } {
	global gui_flags
	    if ![winfo exists $w.menu] {
		frame $w.menu -relief raised -borderwidth 1
	    	pack $w.menu -side top -fill x
		if {[llength [pack slaves $w]]!=0} {
		    pack config $w.menu -before [lindex [pack slaves $w] 0]
		}
	    }
	    set menubuttons ""
	    foreach m $menus {
	 	set menuname [lindex $m 0]
	        set menutext [lindex $m 1]
	        set menuunderline [lindex $m 2]
	        set menupack [lindex $m 3]
	        menubutton $w.menu.$menuname -text $menutext \
			-menu $w.menu.$menuname.m \
			-underline $menuunderline \
			    -font $gui_flags(font,menus)
	        menu $w.menu.$menuname.m \
			    -font $gui_flags(font,menus)
		foreach menuitem [lindex $m 4] {
		    case [lindex $menuitem 0] sep {
	    		$w.menu.$menuname.m add sep
		    } command {
		        $w.menu.$menuname.m add command \
			    -label [lindex $menuitem 1] \
			    -command [lindex $menuitem 2] \
			    -underline [lindex $menuitem 3]
		    } cascade {
		        $w.menu.$menuname.m add cascade \
			    -label [lindex $menuitem 1] \
			    -menu [lindex $menuitem 2] \
			    -underline [lindex $menuitem 3]
		    } checkbutton {
		        $w.menu.$menuname.m add checkbutton \
			    -label [lindex $menuitem 1] \
			    -variable [lindex $menuitem 2] \
			    -command [lindex $menuitem 3] \
			    -underline [lindex $menuitem 4]
		    } default {
			error "Bad menu entry type passed to MakeMenus"
		    }
		}
	        pack $w.menu.$menuname -side $menupack
		lappend menubuttons $w.menu.$menuname
	    }
	eval [list tk_menuBar $w.menu] $menubuttons
	return $w.menu
}
