%<--------------------------------------------------------------       	>%
%< The function tcl is needed to seperately compile this file      	>%
%< It must be identical to the one defined in HolSlave.tcl.		>%
%<                                                                      >%
%<--------------------------------------------------------------       >%

letrec tcl s = tty_write (`\LSTARTTCL\L{` ^ s ^ `}\LENDTCL\L`);; 

%<--------------------------------------------------------------       >%
%< theory_notify.ml,v 1.8 1995/04/04 16:38:58 drs1004 Exp	       >%
%< 								       >%
%< Provides a replacement set of "theory functions", i.e.	       >%
%< save_thm, new_parent, close_theory, extend_theory and so on.	       >%
%<								       >%
%< Things in this file should be considered pretty volatile, but	>%
%< they will eventually settle down.					>%
%<									>%
%< My hope would be that this functionality will eventually be 		>%
%< incorporated into the base HOL systems.				>%
%<								       >%
%< The repacement functions are operationally equivalent, except       >%
%< that they will also "notify" other interested clients in the system >%
%< of the change that has occured in the theory.  This can be used     >%
%< to mimic the changes in an interface, even if the operations are    >%
%< performed by a package external to the interface.		       >%
%<								       >%
%< CLIENTS							       >%
%<								       >%
%< There are two types of clients - ML and Tcl.  		       >%
%<								       >%
%< ML clients are a group of ML functions each of which is called      >%
%< when appropriate.  An ML client also has a			       >%
%< name (which should be unique amongst clients)		       >%
%< by which it may be removed.					       >%
%<								       >%
%< Tcl clients							       >%
%< are a special class of client which pass calls directly	       >%
%< through to tcl functions with particular names and argument	       >%
%< patterns.  For instance, for each tcl client of the theory	       >%
%< the function							       >%
%<								       >%
%<	<tclclass>::save_thm_Notify <tclobj> <theory> <thmname>	       >%
%<								       >%
%< will be called each time a theorem is save to the theory.  Here     >%
%< <tclclass> and <tclobj> are specified when creating the client.     >%
%< <theory> is the theory to which the theorem was saved, and	       >%
%< <thmname> is the name of the theorem just saved.		       >%
%<								       >%
%< Tcl clients do not have to support all the notification messages    >%
%< (unlike ML clients), and they must indicate which ones they want    >%
%< to recieve by using 						       >%
%<								       >%
%<								       >%
%< At the moment all this functionality				       >%
%< is only used for notifying TheoryEditor			       >%
%< whenever a theorem is saved into the theory by a proofpackage.      >%
%< It will be used by alot of other things later.		       >%
%<								       >%
%<--------------------------------------------------------------       >%
let save_thm_safe = save_thm;;
let new_specification_safe = new_specification;;
let new_definition_safe = new_definition;;
let new_axiom_safe = new_axiom;; 
let define_type_safe = define_type;;
let new_parent_safe = new_parent;;
let extend_theory_safe = extend_theory;;
let new_theory_safe = new_theory;;
let load_theory_safe = load_theory;;
let close_theory_safe = close_theory;;
let new_parent_safe = new_parent;;
let load_library_safe = load_library;;

								        
%<--------------------------------------------------------------       >%
%< Watching the current theory  				       >%
%<--------------------------------------------------------------       >%

lettype current_theory_client = 
		string # 
		(string -> void) #	%< called when chrrent theory change >%
		(string -> void) #	%< called when new parent added to current theory >%
		(bool -> void);;	%< called when current theory mode change >%

letref current_theory_notification_list = []: current_theory_client list;; 

letrec current_theory_add_client client =
	(current_theory_notification_list := 
		(append [client] (current_theory_notification_list));
	());;

letrec current_theory_remove_client clientname =
	(current_theory_notification_list := 
	    filter (\(cl,_,_,_). not(cl = clientname)) (current_theory_notification_list);
	());;

%<--------------------------------------------------------------       >%
%< Watching the internals of a theory				       >%
%<--------------------------------------------------------------       >%

lettype theory_client =
		string # 				%< the theory being watched >%
		(string -> string -> thm -> void) #	%< called when a new theorem is added to theory >%
		(string -> string -> thm -> void) #    	%< called when a new definition is added to theory >%
		(string -> string -> thm -> void) #	%< called when a new axiom is added to theory >%
		(string -> term -> void) #		%< called when a new constant is added to theory >%
		(string -> (int # string) -> void);;	%< called when a new type is added to theory >%
		
letref theory_notification_list = []: (string # theory_client) list;; 

letrec theory_add_client theory client =
	(theory_notification_list := 
		(append [(theory,client)] (theory_notification_list));
	());;

letrec theory_remove_client theory clientname =
	(theory_notification_list := 
	    filter (\(th,(cl,_,_,_,_,_)). not(th = theory & cl = clientname)) (theory_notification_list);
	());;

letrec relevant_client_functions theory selector =
	map selector (filter (\client. fst(client) = theory) (theory_notification_list));;

let most_general_theory_wrapper op =
	let constants_before = constants `-`
	and types_before = types `-`
	and theorems_before = theorems `-`
	and definitions_before = definitions `-`
	and axioms_before = axioms `-` in
	(\res. 
	        map (\new_theorem. map (\f. f (current_theory()) (fst new_theorem) (snd new_theorem))
		      (relevant_client_functions (current_theory()) (\(_,(_,x,_,_,_,_)). x))   
		    ) (subtract (theorems `-`) theorems_before)
	      ; map (\new_definition. map (\f. f (current_theory()) (fst new_definition) (snd new_definition))
		      (relevant_client_functions (current_theory()) (\(_,(_,_,x,_,_,_)). x))   
		    ) (subtract (definitions `-`) definitions_before)
	      ; map (\new_axiom. map (\f. f (current_theory()) (fst new_axiom) (snd new_axiom))
		      (relevant_client_functions (current_theory()) (\(_,(_,_,_,x,_,_)). x))   
		    ) (subtract (axioms `-`) axioms_before)
	      ; map (\new_constant. map (\f. f (current_theory()) new_constant)
		      (relevant_client_functions (current_theory()) (\(_,(_,_,_,_,x,_)). x))   
		    ) (subtract (constants `-`) constants_before)
	      ; map (\new_type. map (\f. f (current_theory()) new_type)
		      (relevant_client_functions (current_theory()) (\(_,(_,_,_,_,_,x)). x))
		    ) (subtract (types `-`) types_before)
	      ; res)
 	(op ());;

%<--------------------------------------------------------------       >%
%< Now the actual replacement interface which generates notify         >%
%< calls.       						       >%
%< 								       >%
%<--------------------------------------------------------------       >%

letrec save_thm_and_notify (name,thm) =
	(\thm. (map (\f. f (current_theory()) name thm) 
		(relevant_client_functions (current_theory()) (\(_,(_,x,_,_,_)). x)))
	      ; thm)
 	(save_thm_safe(name,thm));;

letrec new_axiom_and_notify (name,term) =							
		(\thm. (map (\f. f (current_theory()) name thm) 				
			(relevant_client_functions (current_theory()) (\(_,(_,x,_,_,_)). x)))	
	      ; thm)										
	 	(new_axiom(name,term));;							

letrec new_specification_and_notify name specs given_thm =
	most_general_theory_wrapper (\(). new_specification_safe name specs given_thm);;
			
letrec new_definition_and_notify (name,term) =
	most_general_theory_wrapper (\(). new_definition_safe (name,term));;
			
letrec define_type_and_notify name spec =
	most_general_theory_wrapper (\(). define_type_safe name spec);;


%<--------------------------------------------------------------       >%
%< 								       >%
%<--------------------------------------------------------------       >%

letrec load_theory_and_notify th =
        (load_theory_safe th;
	map (\ (_,client,_,_). client (current_theory())) (current_theory_notification_list); 
 	());;

letrec new_theory_and_notify th =
        (new_theory_safe th;
	map (\ (_,client,_,_). client (current_theory())) (current_theory_notification_list); 
	());;

letrec extend_theory_and_notify th =
        (if (th = current_theory()) then
             (extend_theory_safe th;
	     map (\ (_,_,_,client). client (draft_mode())) (current_theory_notification_list))
         else
	     (extend_theory_safe th;
             map (\ (_,client,_,_). client (current_theory())) (current_theory_notification_list)); 
         ());;

letrec close_theory_and_notify th =
        (close_theory_safe th;
	map (\(_,_,_,client). client (draft_mode())) (current_theory_notification_list); 
	());;


letrec new_parent_and_notify th =
         (new_parent_safe th;
	   map (\(_,_,client,_). client (current_theory())) (current_theory_notification_list); 
         ());;
	 
letrec load_library_and_notify th = 		                    
   	let old_parents = parents `-`
	and old_current = current_theory() in			
        (load_library_safe th;
         if (not (old_current = current_theory())) then
          	(map (\(_,x,_,_). x (current_theory()))
            	(current_theory_notification_list);())
         else if (not (old_parents = parents `-`)) then
             	(map (\(_,_,x,_). x (current_theory()))
            	(current_theory_notification_list);())
	 else ());;

%<--------------------------------------------------------------       >%
%< 								       >%
%<--------------------------------------------------------------       >%


let save_thm = save_thm_and_notify;;
let new_specification = new_specification_and_notify;;
let new_definition = new_definition_and_notify;;
let new_axiom = new_axiom_and_notify;; 
let define_type = define_type_and_notify;;
let new_parent = new_parent_and_notify;;
let extend_theory = extend_theory_and_notify;;
let new_theory = new_theory_and_notify;;
let load_theory = load_theory_and_notify;;
let close_theory = close_theory_and_notify;;
let new_parent = new_parent_and_notify;;
let load_library = load_library_and_notify;;



%<--------------------------------------------------------------       	>%
%< theory tcl clients		 					>%
%<        						       		>%
%< For testing:       						       	>%
%< letrec tcl x= tty_write x;; 						>%
%< 								       	>%
%<--------------------------------------------------------------       	>%

type theory_tcl_client_notification_selection = 
		on_new_thm | 
		on_new_definition | 
		on_new_axiom | 
		on_new_constant |
		on_new_type;;

lettype theory_tcl_client = (string # string # (theory_tcl_client_notification_selection) list);;

letrec theory_add_tcl_client theory (tclclass,tclobj,selection) =
	theory_add_client theory (
	   (tclclass ^ tclobj),
	   (if (mem on_new_thm selection) 
	       then (\thr. \thmname. \thm. tcl (tclclass ^ `::new_thm_Notify `  ^ tclobj ^ ` ` ^ thr ^ ` ` ^ thmname))
	       else (\thr. \thmname. \thm. ())),
	   (if (mem on_new_definition selection) 
	       then (\thr. \thmname. \thm. tcl (tclclass ^ `::new_definition_Notify `  ^ tclobj ^ ` ` ^ thr ^ ` ` ^ thmname))
	       else (\thr. \thmname. \thm. ())),
	   (if (mem on_new_axiom selection) 
	       then (\thr. \thmname. \thm. tcl (tclclass ^ `::new_axiom_Notify `  ^ tclobj ^ ` ` ^ thr ^ ` ` ^ thmname))
	       else (\thr. \thmname. \thm. ())),
	   (if (mem on_new_constant selection) 
	       then (\thr. \const. tcl (tclclass ^ `::new_const_Notify `  ^ tclobj ^ ` ` ^ thr ^ ` ` ^ (fst (dest_const const))))
	       else (\thr. \const. ())),
	   (if (mem on_new_type selection) 
	       then (\thr. \newtype. tcl (tclclass ^ `::new_type_Notify `  ^ tclobj ^ ` ` ^ thr ^ ` ` ^ (snd newtype)))
	       else (\thr. \newtype. ()))
	);;


letrec theory_remove_tcl_client theory ((tclclass,tclobj,selection):theory_tcl_client) =
	theory_remove_client theory (tclclass ^ tclobj);;

%<--------------------------------------------------------------       	>%
%< current theory tcl clients		 				>%
%<        						       		>%
%< For testing:       						       	>%
%< letrec tcl x= tty_write x;; 						>%
%< 								       	>%
%<--------------------------------------------------------------       	>%

lettype current_theory_tcl_client = string # string;;

letrec current_theory_add_tcl_client (tclclass,tclobj) =
	current_theory_add_client (
	   (tclclass ^ tclobj),
	   (\thr. tcl (tclclass ^ `::current_theory_change_Notify `  ^ tclobj ^ ` ` ^ thr)),
	   (\thr. tcl (tclclass ^ `::current_theory_ancestry_change_Notify `  ^ tclobj ^ ` ` ^ thr)),
	   (\draftmode. tcl (tclclass ^ `::current_theory_mode_change_Notify `  ^ tclobj ^ ` ` ^ (if (draftmode) then `1` else `0`)))
 	);;

letrec current_theory_remove_tcl_client (tclclass,tclobj) =
	current_theory_remove_client (tclclass ^ tclobj);;

%<--------------------------------------------------------------       >%
%< Test Fragments      						       >%
%< 								       >%
%<--------------------------------------------------------------       >%

%<
letrec tcl x= tty_write x;;
letrec tcl x = output(std_out,x);

system `rm junk2.th`;;
loadt `theory_notify.ml`;;
current_theory_add_tcl_client (`Class`,`Obj`);;
new_theory_and_notify `junk2`;;
theory_add_tcl_client `junk2` (`Class`,`Obj`,[on_new_thm]);;
save_thm_and_notify (`blah`,ETA_AX);;

load_library {lib=find_library "set", theory = "-"}

>%
